/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.vintage_animations.mixin;

import dev.architectury.platform.Platform;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.pixeldreamstudios.vintage_animations.IAnimatedPlayer;
import net.pixeldreamstudios.vintage_animations.ToolAnimationManager;
import net.pixeldreamstudios.vintage_animations.VintageAnimations;
import net.pixeldreamstudios.vintage_animations.compat.FirstPersonModelCompat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private ModifierLayer<IAnimation> vintageAnimations$animationContainer;
    @Unique
    private boolean vintageAnimations$switchedMainHandLeft = false;
    @Unique
    private boolean vintageAnimations$switchedMainHandRight = true;
    @Unique
    private String vintageAnimations$currentAnimation = null;
    @Unique
    private long vintageAnimations$lastAnimationTime = 0L;

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="HEAD")})
    private void playAnimation(InteractionHand interactionHand, CallbackInfo ci) {
        Player player;
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof Player) || !(player = (Player)entity).level().isClientSide()) {
            return;
        }
        if (this.isAnimationActive() && !this.shouldAllowNewAnimation()) {
            return;
        }
        ItemStack itemStack = player.getItemInHand(interactionHand);
        ToolAnimationManager.getAnimationFor(itemStack).ifPresent(animId -> {
            String animName = animId.getPath();
            this.playAnim((LivingEntity)player, animName);
            this.vintageAnimations$currentAnimation = animName;
            this.vintageAnimations$lastAnimationTime = System.currentTimeMillis();
        });
    }

    @Unique
    private boolean isAnimationActive() {
        return this.vintageAnimations$animationContainer != null && this.vintageAnimations$animationContainer.getAnimation() != null && this.vintageAnimations$animationContainer.getAnimation().isActive();
    }

    @Unique
    private boolean shouldAllowNewAnimation() {
        long animDurationMs;
        if (this.vintageAnimations$currentAnimation == null) {
            return true;
        }
        KeyframeAnimation anim = this.getAnimationByName(this.vintageAnimations$currentAnimation);
        if (anim == null) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.vintageAnimations$lastAnimationTime;
        return (double)elapsedTime >= (double)(animDurationMs = (long)anim.endTick * 50L) * 0.9;
    }

    @Unique
    private KeyframeAnimation getAnimationByName(String animName) {
        ResourceLocation animLocation = ResourceLocation.fromNamespaceAndPath((String)"vintage_animations", (String)animName);
        return (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)animLocation);
    }

    @Inject(method={"getAttackAnim(F)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void cancelVanillaAttackAnim(float f, CallbackInfoReturnable<Float> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof Player)) {
            return;
        }
        if (entity.level().isClientSide() && this.isAnimationActive()) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void updateAnimationState(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof Player) || !entity.level().isClientSide()) {
            return;
        }
        if (this.vintageAnimations$animationContainer != null) {
            boolean mainHandLeft = ((HumanoidArm)Minecraft.getInstance().options.mainHand().get()).equals((Object)HumanoidArm.LEFT);
            if (mainHandLeft && !this.vintageAnimations$switchedMainHandLeft) {
                this.vintageAnimations$animationContainer.addModifier((AbstractModifier)new MirrorModifier(true), 0);
                this.vintageAnimations$switchedMainHandLeft = true;
                this.vintageAnimations$switchedMainHandRight = false;
            } else if (!mainHandLeft && !this.vintageAnimations$switchedMainHandRight) {
                this.vintageAnimations$animationContainer.removeModifier(0);
                this.vintageAnimations$switchedMainHandRight = true;
                this.vintageAnimations$switchedMainHandLeft = false;
            }
            if (!this.isAnimationActive()) {
                this.vintageAnimations$currentAnimation = null;
            }
        }
    }

    @Unique
    private void playAnim(LivingEntity player, String animName) {
        ResourceLocation animLocation = ResourceLocation.fromNamespaceAndPath((String)"vintage_animations", (String)animName);
        KeyframeAnimation anim = (KeyframeAnimation)PlayerAnimationRegistry.getAnimation((ResourceLocation)animLocation);
        if (anim == null) {
            VintageAnimations.LOGGER.warn("Animation not found: {}", (Object)animLocation);
            return;
        }
        KeyframeAnimationPlayer animPlayer = new KeyframeAnimationPlayer(anim).setFirstPersonConfiguration(this.createFirstPersonConfig());
        animPlayer.setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL);
        this.applyCompatibilitySettings(animPlayer);
        this.vintageAnimations$animationContainer = ((IAnimatedPlayer)player).vintage_animations_getModAnimation();
        this.vintageAnimations$animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTEXPO), (IAnimation)animPlayer, true);
    }

    @Unique
    private FirstPersonConfiguration createFirstPersonConfig() {
        return new FirstPersonConfiguration(VintageAnimations.config.showArmsInFirstPerson, VintageAnimations.config.showArmsInFirstPerson && VintageAnimations.config.showOffHandInFirstPerson, true, VintageAnimations.config.showOffHandInFirstPerson);
    }

    @Unique
    private void applyCompatibilitySettings(KeyframeAnimationPlayer animPlayer) {
        if (Platform.isModLoaded((String)"firstperson")) {
            new FirstPersonModelCompat(animPlayer);
        }
        if (Platform.isModLoaded((String)"realcamera")) {
            animPlayer.setFirstPersonMode(FirstPersonMode.DISABLED);
        }
    }
}

