/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.vintage_animations;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.pixeldreamstudios.vintage_animations.VintageAnimations;

public class ToolAnimationManager {
    private static final Map<ResourceLocation, Predicate<ItemStack>> ANIMATION_PREDICATES = new HashMap<ResourceLocation, Predicate<ItemStack>>();

    private static void registerAnimation(String name, Predicate<ItemStack> predicate) {
        ANIMATION_PREDICATES.put(ResourceLocation.fromNamespaceAndPath((String)"vintage_animations", (String)name), predicate);
    }

    public static Optional<ResourceLocation> getAnimationFor(ItemStack stack) {
        return ANIMATION_PREDICATES.entrySet().stream().filter(entry -> ((Predicate)entry.getValue()).test(stack)).map(Map.Entry::getKey).findFirst();
    }

    static {
        ToolAnimationManager.registerAnimation("chop", stack -> stack.is(ItemTags.AXES) && VintageAnimations.config.chopAnimation);
        ToolAnimationManager.registerAnimation("pick", stack -> stack.is(ItemTags.PICKAXES) && VintageAnimations.config.pickAnimation);
        ToolAnimationManager.registerAnimation("dig", stack -> stack.is(ItemTags.SHOVELS) && VintageAnimations.config.digAnimation);
        ToolAnimationManager.registerAnimation("till", stack -> stack.is(ItemTags.HOES) && VintageAnimations.config.tillAnimation);
    }
}

