/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.noise;

import org.joml.Vector3f;
import org.joml.Vector4f;

public class OpenSimplex2S {
    private static final long PRIME_X = 5910200641878280303L;
    private static final long PRIME_Y = 6452764530575939509L;
    private static final long PRIME_Z = 6614699811220273867L;
    private static final long PRIME_W = 6254464313819354443L;
    private static final long HASH_MULTIPLIER = 6026932503003350773L;
    private static final long SEED_FLIP_3D = -5968755714895566377L;
    private static final double ROOT3OVER3 = 0.577350269189626;
    private static final double FALLBACK_ROTATE3 = 0.6666666666666666;
    private static final double ROTATE3_ORTHOGONALIZER = -0.21132486540518713;
    private static final float SKEW_4D = 0.309017f;
    private static final float UNSKEW_4D = -0.1381966f;
    private static final int N_GRADS_3D_EXPONENT = 8;
    private static final int N_GRADS_4D_EXPONENT = 9;
    private static final int N_GRADS_3D = 256;
    private static final int N_GRADS_4D = 512;
    private static final int GRAD_HASH_MASK_3D = 1020;
    private static final int GRAD_HASH_MASK_4D = 2044;
    private static final int N_OUTPUT_VEC3 = 256;
    private static final int VEC3_HASH_SHIFT_3D = 8;
    private static final int VEC3_HASH_MASK_3D = 1020;
    private static final double NORMALIZER_3D = 0.2781926117527186;
    private static final double NORMALIZER_4D = 0.11127401889945551;
    private static final float RSQUARED_3D = 0.75f;
    private static final float RSQUARED_4D = 0.8f;
    private static float[] GRADIENTS_3D;
    private static float[] GRADIENTS_4D;
    private static int[] LOOKUP_4D_A;
    private static LatticeVertex4D[] LOOKUP_4D_B;
    private static final float[] OUTPUT_VEC3;

    public static float noise3_ImproveXY(long seed, double x, double y, double z) {
        double xy = x + y;
        double s2 = xy * -0.21132486540518713;
        double zz = z * 0.577350269189626;
        double xr = x + s2 + zz;
        double yr = y + s2 + zz;
        double zr = xy * -0.577350269189626 + zz;
        return OpenSimplex2S.noise3_UnrotatedBase(seed, xr, yr, zr);
    }

    public static float noise3_ImproveXZ(long seed, double x, double y, double z) {
        double xz = x + z;
        double s2 = xz * -0.21132486540518713;
        double yy = y * 0.577350269189626;
        double xr = x + s2 + yy;
        double zr = z + s2 + yy;
        double yr = xz * -0.577350269189626 + yy;
        return OpenSimplex2S.noise3_UnrotatedBase(seed, xr, yr, zr);
    }

    public static float noise3_Fallback(long seed, double x, double y, double z) {
        double r = 0.6666666666666666 * (x + y + z);
        double xr = r - x;
        double yr = r - y;
        double zr = r - z;
        return OpenSimplex2S.noise3_UnrotatedBase(seed, xr, yr, zr);
    }

    private static float noise3_UnrotatedBase(long seed, double xr, double yr, double zr) {
        float aD;
        float a9;
        float a5;
        int xrb = OpenSimplex2S.fastFloor(xr);
        int yrb = OpenSimplex2S.fastFloor(yr);
        int zrb = OpenSimplex2S.fastFloor(zr);
        float xi = (float)(xr - (double)xrb);
        float yi = (float)(yr - (double)yrb);
        float zi = (float)(zr - (double)zrb);
        long xrbp = (long)xrb * 5910200641878280303L;
        long yrbp = (long)yrb * 6452764530575939509L;
        long zrbp = (long)zrb * 6614699811220273867L;
        long seed2 = seed ^ 0xAD2AB84D169129D7L;
        int xNMask = (int)(-0.5f - xi);
        int yNMask = (int)(-0.5f - yi);
        int zNMask = (int)(-0.5f - zi);
        float x0 = xi + (float)xNMask;
        float y0 = yi + (float)yNMask;
        float z0 = zi + (float)zNMask;
        float a0 = 0.75f - x0 * x0 - y0 * y0 - z0 * z0;
        float value = a0 * a0 * (a0 * a0) * OpenSimplex2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), x0, y0, z0);
        float x1 = xi - 0.5f;
        float y1 = yi - 0.5f;
        float z1 = zi - 0.5f;
        float a1 = 0.75f - x1 * x1 - y1 * y1 - z1 * z1;
        value += a1 * a1 * (a1 * a1) * OpenSimplex2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + 6452764530575939509L, zrbp + 6614699811220273867L, x1, y1, z1);
        float xAFlipMask0 = (float)((xNMask | 1) << 1) * x1;
        float yAFlipMask0 = (float)((yNMask | 1) << 1) * y1;
        float zAFlipMask0 = (float)((zNMask | 1) << 1) * z1;
        float xAFlipMask1 = (float)(-2 - (xNMask << 2)) * x1 - 1.0f;
        float yAFlipMask1 = (float)(-2 - (yNMask << 2)) * y1 - 1.0f;
        float zAFlipMask1 = (float)(-2 - (zNMask << 2)) * z1 - 1.0f;
        boolean skip5 = false;
        float a2 = xAFlipMask0 + a0;
        if (a2 > 0.0f) {
            float x2 = x0 - (float)(xNMask | 1);
            float y2 = y0;
            float z2 = z0;
            value += a2 * a2 * (a2 * a2) * OpenSimplex2S.grad(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), x2, y2, z2);
        } else {
            float a4;
            float a3 = yAFlipMask0 + zAFlipMask0 + a0;
            if (a3 > 0.0f) {
                float x3 = x0;
                float y3 = y0 - (float)(yNMask | 1);
                float z3 = z0 - (float)(zNMask | 1);
                value += a3 * a3 * (a3 * a3) * OpenSimplex2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL), x3, y3, z3);
            }
            if ((a4 = xAFlipMask1 + a1) > 0.0f) {
                float x4 = (float)(xNMask | 1) + x1;
                float y4 = y1;
                float z4 = z1;
                value += a4 * a4 * (a4 * a4) * OpenSimplex2S.grad(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + 6452764530575939509L, zrbp + 6614699811220273867L, x4, y4, z4);
                skip5 = true;
            }
        }
        boolean skip9 = false;
        float a6 = yAFlipMask0 + a0;
        if (a6 > 0.0f) {
            float x6 = x0;
            float y6 = y0 - (float)(yNMask | 1);
            float z6 = z0;
            value += a6 * a6 * (a6 * a6) * OpenSimplex2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), x6, y6, z6);
        } else {
            float a8;
            float a7 = xAFlipMask0 + zAFlipMask0 + a0;
            if (a7 > 0.0f) {
                float x7 = x0 - (float)(xNMask | 1);
                float y7 = y0;
                float z7 = z0 - (float)(zNMask | 1);
                value += a7 * a7 * (a7 * a7) * OpenSimplex2S.grad(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL), x7, y7, z7);
            }
            if ((a8 = yAFlipMask1 + a1) > 0.0f) {
                float x8 = x1;
                float y8 = (float)(yNMask | 1) + y1;
                float z8 = z1;
                value += a8 * a8 * (a8 * a8) * OpenSimplex2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + 6614699811220273867L, x8, y8, z8);
                skip9 = true;
            }
        }
        boolean skipD = false;
        float aA = zAFlipMask0 + a0;
        if (aA > 0.0f) {
            float xA = x0;
            float yA = y0;
            float zA = z0 - (float)(zNMask | 1);
            value += aA * aA * (aA * aA) * OpenSimplex2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL), xA, yA, zA);
        } else {
            float aC;
            float aB = xAFlipMask0 + yAFlipMask0 + a0;
            if (aB > 0.0f) {
                float xB = x0 - (float)(xNMask | 1);
                float yB = y0 - (float)(yNMask | 1);
                float zB = z0;
                value += aB * aB * (aB * aB) * OpenSimplex2S.grad(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), xB, yB, zB);
            }
            if ((aC = zAFlipMask1 + a1) > 0.0f) {
                float xC = x1;
                float yC = y1;
                float zC = (float)(zNMask | 1) + z1;
                value += aC * aC * (aC * aC) * OpenSimplex2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + 6452764530575939509L, zrbp + ((long)zNMask & 0xB79844DD3F417596L), xC, yC, zC);
                skipD = true;
            }
        }
        if (!skip5 && (a5 = yAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x5 = x1;
            float y5 = (float)(yNMask | 1) + y1;
            float z5 = (float)(zNMask | 1) + z1;
            value += a5 * a5 * (a5 * a5) * OpenSimplex2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + ((long)zNMask & 0xB79844DD3F417596L), x5, y5, z5);
        }
        if (!skip9 && (a9 = xAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x9 = (float)(xNMask | 1) + x1;
            float y9 = y1;
            float z9 = (float)(zNMask | 1) + z1;
            value += a9 * a9 * (a9 * a9) * OpenSimplex2S.grad(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + 6452764530575939509L, zrbp + ((long)zNMask & 0xB79844DD3F417596L), x9, y9, z9);
        }
        if (!skipD && (aD = xAFlipMask1 + yAFlipMask1 + a1) > 0.0f) {
            float xD = (float)(xNMask | 1) + x1;
            float yD = (float)(yNMask | 1) + y1;
            float zD = z1;
            value += aD * aD * (aD * aD) * OpenSimplex2S.grad(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + 6614699811220273867L, xD, yD, zD);
        }
        return value;
    }

    public static void vec3Noise3_ImproveXZ(long seed, double x, double y, double z, Vector3f output) {
        double xz = x + z;
        double s2 = xz * -0.21132486540518713;
        double yy = y * 0.577350269189626;
        double xr = x + s2 + yy;
        double zr = z + s2 + yy;
        double yr = xz * -0.577350269189626 + yy;
        OpenSimplex2S.vec3Noise3_UnrotatedBase(seed, xr, yr, zr, output);
    }

    private static void vec3Noise3_UnrotatedBase(long seed, double xr, double yr, double zr, Vector3f output) {
        float aD;
        float a9;
        float a5;
        int xrb = OpenSimplex2S.fastFloor(xr);
        int yrb = OpenSimplex2S.fastFloor(yr);
        int zrb = OpenSimplex2S.fastFloor(zr);
        float xi = (float)(xr - (double)xrb);
        float yi = (float)(yr - (double)yrb);
        float zi = (float)(zr - (double)zrb);
        long xrbp = (long)xrb * 5910200641878280303L;
        long yrbp = (long)yrb * 6452764530575939509L;
        long zrbp = (long)zrb * 6614699811220273867L;
        long seed2 = seed ^ 0xAD2AB84D169129D7L;
        int xNMask = (int)(-0.5f - xi);
        int yNMask = (int)(-0.5f - yi);
        int zNMask = (int)(-0.5f - zi);
        float x0 = xi + (float)xNMask;
        float y0 = yi + (float)yNMask;
        float z0 = zi + (float)zNMask;
        float a0 = 0.75f - x0 * x0 - y0 * y0 - z0 * z0;
        int h0 = OpenSimplex2S.v3Hash(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL));
        float v0 = a0 * a0 * (a0 * a0) * OpenSimplex2S.grad(h0, x0, y0, z0);
        int vi0 = h0 >> 8 & 0x3FC;
        float vx = v0 * OUTPUT_VEC3[vi0 | 0];
        float vy = v0 * OUTPUT_VEC3[vi0 | 1];
        float vz = v0 * OUTPUT_VEC3[vi0 | 2];
        float x1 = xi - 0.5f;
        float y1 = yi - 0.5f;
        float z1 = zi - 0.5f;
        float a1 = 0.75f - x1 * x1 - y1 * y1 - z1 * z1;
        int h1 = OpenSimplex2S.v3Hash(seed2, xrbp + 5910200641878280303L, yrbp + 6452764530575939509L, zrbp + 6614699811220273867L);
        float v1 = a1 * a1 * (a1 * a1) * OpenSimplex2S.grad(h1, x1, y1, z1);
        int vi1 = h1 >> 8 & 0x3FC;
        vx += v1 * OUTPUT_VEC3[vi1 | 0];
        vy += v1 * OUTPUT_VEC3[vi1 | 1];
        vz += v1 * OUTPUT_VEC3[vi1 | 2];
        float xAFlipMask0 = (float)((xNMask | 1) << 1) * x1;
        float yAFlipMask0 = (float)((yNMask | 1) << 1) * y1;
        float zAFlipMask0 = (float)((zNMask | 1) << 1) * z1;
        float xAFlipMask1 = (float)(-2 - (xNMask << 2)) * x1 - 1.0f;
        float yAFlipMask1 = (float)(-2 - (yNMask << 2)) * y1 - 1.0f;
        float zAFlipMask1 = (float)(-2 - (zNMask << 2)) * z1 - 1.0f;
        boolean skip5 = false;
        float a2 = xAFlipMask0 + a0;
        if (a2 > 0.0f) {
            float x2 = x0 - (float)(xNMask | 1);
            float y2 = y0;
            float z2 = z0;
            int h2 = OpenSimplex2S.v3Hash(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL));
            float v2 = a2 * a2 * (a2 * a2) * OpenSimplex2S.grad(h2, x2, y2, z2);
            int vi2 = h2 >> 8 & 0x3FC;
            vx += v2 * OUTPUT_VEC3[vi2 | 0];
            vy += v2 * OUTPUT_VEC3[vi2 | 1];
            vz += v2 * OUTPUT_VEC3[vi2 | 2];
        } else {
            float a4;
            float a3 = yAFlipMask0 + zAFlipMask0 + a0;
            if (a3 > 0.0f) {
                float x3 = x0;
                float y3 = y0 - (float)(yNMask | 1);
                float z3 = z0 - (float)(zNMask | 1);
                int h3 = OpenSimplex2S.v3Hash(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL));
                float v3 = a3 * a3 * (a3 * a3) * OpenSimplex2S.grad(h3, x3, y3, z3);
                int vi3 = h3 >> 8 & 0x3FC;
                vx += v3 * OUTPUT_VEC3[vi3 | 0];
                vy += v3 * OUTPUT_VEC3[vi3 | 1];
                vz += v3 * OUTPUT_VEC3[vi3 | 2];
            }
            if ((a4 = xAFlipMask1 + a1) > 0.0f) {
                float x4 = (float)(xNMask | 1) + x1;
                float y4 = y1;
                float z4 = z1;
                int h4 = OpenSimplex2S.v3Hash(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + 6452764530575939509L, zrbp + 6614699811220273867L);
                float v4 = a4 * a4 * (a4 * a4) * OpenSimplex2S.grad(h4, x4, y4, z4);
                int vi4 = h4 >> 8 & 0x3FC;
                vx += v4 * OUTPUT_VEC3[vi4 | 0];
                vy += v4 * OUTPUT_VEC3[vi4 | 1];
                vz += v4 * OUTPUT_VEC3[vi4 | 2];
                skip5 = true;
            }
        }
        boolean skip9 = false;
        float a6 = yAFlipMask0 + a0;
        if (a6 > 0.0f) {
            float x6 = x0;
            float y6 = y0 - (float)(yNMask | 1);
            float z6 = z0;
            int h6 = OpenSimplex2S.v3Hash(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL));
            float v6 = a6 * a6 * (a6 * a6) * OpenSimplex2S.grad(h6, x6, y6, z6);
            int vi6 = h6 >> 8 & 0x3FC;
            vx += v6 * OUTPUT_VEC3[vi6 | 0];
            vy += v6 * OUTPUT_VEC3[vi6 | 1];
            vz += v6 * OUTPUT_VEC3[vi6 | 2];
        } else {
            float a8;
            float a7 = xAFlipMask0 + zAFlipMask0 + a0;
            if (a7 > 0.0f) {
                float x7 = x0 - (float)(xNMask | 1);
                float y7 = y0;
                float z7 = z0 - (float)(zNMask | 1);
                int h7 = OpenSimplex2S.v3Hash(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL));
                float v7 = a7 * a7 * (a7 * a7) * OpenSimplex2S.grad(h7, x7, y7, z7);
                int vi7 = h7 >> 8 & 0x3FC;
                vx += v7 * OUTPUT_VEC3[vi7 | 0];
                vy += v7 * OUTPUT_VEC3[vi7 | 1];
                vz += v7 * OUTPUT_VEC3[vi7 | 2];
            }
            if ((a8 = yAFlipMask1 + a1) > 0.0f) {
                float x8 = x1;
                float y8 = (float)(yNMask | 1) + y1;
                float z8 = z1;
                int h8 = OpenSimplex2S.v3Hash(seed2, xrbp + 5910200641878280303L, yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + 6614699811220273867L);
                float v8 = a8 * a8 * (a8 * a8) * OpenSimplex2S.grad(h8, x8, y8, z8);
                int vi8 = h8 >> 8 & 0x3FC;
                vx += v8 * OUTPUT_VEC3[vi8 | 0];
                vy += v8 * OUTPUT_VEC3[vi8 | 1];
                vz += v8 * OUTPUT_VEC3[vi8 | 2];
                skip9 = true;
            }
        }
        boolean skipD = false;
        float aA = zAFlipMask0 + a0;
        if (aA > 0.0f) {
            float xA = x0;
            float yA = y0;
            float zA = z0 - (float)(zNMask | 1);
            int hA = OpenSimplex2S.v3Hash(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL));
            float vA = aA * aA * (aA * aA) * OpenSimplex2S.grad(hA, xA, yA, zA);
            int viA = hA >> 8 & 0x3FC;
            vx += vA * OUTPUT_VEC3[viA | 0];
            vy += vA * OUTPUT_VEC3[viA | 1];
            vz += vA * OUTPUT_VEC3[viA | 2];
        } else {
            float aC;
            float aB = xAFlipMask0 + yAFlipMask0 + a0;
            if (aB > 0.0f) {
                float xB = x0 - (float)(xNMask | 1);
                float yB = y0 - (float)(yNMask | 1);
                float zB = z0;
                int hB = OpenSimplex2S.v3Hash(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL));
                float vB = aB * aB * (aB * aB) * OpenSimplex2S.grad(hB, xB, yB, zB);
                int viB = hB >> 8 & 0x3FC;
                vx += vB * OUTPUT_VEC3[viB | 0];
                vy += vB * OUTPUT_VEC3[viB | 1];
                vz += vB * OUTPUT_VEC3[viB | 2];
            }
            if ((aC = zAFlipMask1 + a1) > 0.0f) {
                float xC = x1;
                float yC = y1;
                float zC = (float)(zNMask | 1) + z1;
                int hC = OpenSimplex2S.v3Hash(seed2, xrbp + 5910200641878280303L, yrbp + 6452764530575939509L, zrbp + ((long)zNMask & 0xB79844DD3F417596L));
                float vC = aC * aC * (aC * aC) * OpenSimplex2S.grad(hC, xC, yC, zC);
                int viC = hC >> 8 & 0x3FC;
                vx += vC * OUTPUT_VEC3[viC | 0];
                vy += vC * OUTPUT_VEC3[viC | 1];
                vz += vC * OUTPUT_VEC3[viC | 2];
                skipD = true;
            }
        }
        if (!skip5 && (a5 = yAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x5 = x1;
            float y5 = (float)(yNMask | 1) + y1;
            float z5 = (float)(zNMask | 1) + z1;
            int h5 = OpenSimplex2S.v3Hash(seed2, xrbp + 5910200641878280303L, yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + ((long)zNMask & 0xB79844DD3F417596L));
            float v5 = a5 * a5 * (a5 * a5) * OpenSimplex2S.grad(h5, x5, y5, z5);
            int vi5 = h5 >> 8 & 0x3FC;
            vx += v5 * OUTPUT_VEC3[vi5 | 0];
            vy += v5 * OUTPUT_VEC3[vi5 | 1];
            vz += v5 * OUTPUT_VEC3[vi5 | 2];
        }
        if (!skip9 && (a9 = xAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x9 = (float)(xNMask | 1) + x1;
            float y9 = y1;
            float z9 = (float)(zNMask | 1) + z1;
            int h9 = OpenSimplex2S.v3Hash(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + 6452764530575939509L, zrbp + ((long)zNMask & 0xB79844DD3F417596L));
            float v9 = a9 * a9 * (a9 * a9) * OpenSimplex2S.grad(h9, x9, y9, z9);
            int vi9 = h9 >> 8 & 0x3FC;
            vx += v9 * OUTPUT_VEC3[vi9 | 0];
            vy += v9 * OUTPUT_VEC3[vi9 | 1];
            vz += v9 * OUTPUT_VEC3[vi9 | 2];
        }
        if (!skipD && (aD = xAFlipMask1 + yAFlipMask1 + a1) > 0.0f) {
            float xD = (float)(xNMask | 1) + x1;
            float yD = (float)(yNMask | 1) + y1;
            float zD = z1;
            int hD = OpenSimplex2S.v3Hash(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + 6614699811220273867L);
            float vD = aD * aD * (aD * aD) * OpenSimplex2S.grad(hD, xD, yD, zD);
            int viD = hD >> 8 & 0x3FC;
            vx += vD * OUTPUT_VEC3[viD | 0];
            vy += vD * OUTPUT_VEC3[viD | 1];
            vz += vD * OUTPUT_VEC3[viD | 2];
        }
        output.set(vx, vy, vz);
    }

    public static double noise4Grad_ImproveXYZ_ImproveXZ(long seed, double x, double y, double z, double w, Vector4f gradient) {
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        double yy = y * 0.2886751345948129;
        double ww = w * 1.118033988749894;
        double xr = x + (yy + ww + s2);
        double zr = z + (yy + ww + s2);
        double yr = xz * -0.577350269189626 + (yy + ww);
        double wr = y * -0.866025403784439 + ww;
        double value = OpenSimplex2S.noise4Grad_UnskewedBase(seed, xr, yr, zr, wr, gradient);
        float xzd = gradient.x() + gradient.z();
        float xyzd = xzd + gradient.y();
        float s2d = xzd * -0.21132487f;
        float yyd = gradient.y() * 0.57735026f;
        gradient.set(gradient.x() + (s2d - yyd), xyzd * 0.28867513f + gradient.w() * -0.8660254f, gradient.z() + (s2d - yyd), (xyzd + gradient.w()) * 0.5f);
        return value;
    }

    private static float noise4Grad_UnskewedBase(long seed, double xs, double ys, double zs, double ws, Vector4f gradient) {
        int xsb = OpenSimplex2S.fastFloor(xs);
        int ysb = OpenSimplex2S.fastFloor(ys);
        int zsb = OpenSimplex2S.fastFloor(zs);
        int wsb = OpenSimplex2S.fastFloor(ws);
        float xsi = (float)(xs - (double)xsb);
        float ysi = (float)(ys - (double)ysb);
        float zsi = (float)(zs - (double)zsb);
        float wsi = (float)(ws - (double)wsb);
        float ssi = (xsi + ysi + zsi + wsi) * -0.1381966f;
        float xi = xsi + ssi;
        float yi = ysi + ssi;
        float zi = zsi + ssi;
        float wi = wsi + ssi;
        long xsvp = (long)xsb * 5910200641878280303L;
        long ysvp = (long)ysb * 6452764530575939509L;
        long zsvp = (long)zsb * 6614699811220273867L;
        long wsvp = (long)wsb * 6254464313819354443L;
        int index = (OpenSimplex2S.fastFloor(xs * 4.0) & 3) << 0 | (OpenSimplex2S.fastFloor(ys * 4.0) & 3) << 2 | (OpenSimplex2S.fastFloor(zs * 4.0) & 3) << 4 | (OpenSimplex2S.fastFloor(ws * 4.0) & 3) << 6;
        float value = 0.0f;
        float dVdx = 0.0f;
        float dVdy = 0.0f;
        float dVdz = 0.0f;
        float dVdw = 0.0f;
        int secondaryIndexStartAndStop = LOOKUP_4D_A[index];
        int secondaryIndexStart = secondaryIndexStartAndStop & 0xFFFF;
        int secondaryIndexStop = secondaryIndexStartAndStop >> 16;
        for (int i = secondaryIndexStart; i < secondaryIndexStop; ++i) {
            LatticeVertex4D c = LOOKUP_4D_B[i];
            float dx = xi + c.dx;
            float dy = yi + c.dy;
            float dz = zi + c.dz;
            float dw = wi + c.dw;
            float na = dx * dx + dy * dy + (dz * dz + dw * dw);
            if (!(na < 0.8f)) continue;
            float aa = (na -= 0.8f) * na;
            float naaa = aa * na;
            float aaaa = aa * aa;
            int gi = OpenSimplex2S.v4GradIndex(seed, xsvp + c.xsvp, ysvp + c.ysvp, zsvp + c.zsvp, wsvp + c.wsvp);
            float gx = GRADIENTS_4D[gi | 0];
            float gy = GRADIENTS_4D[gi | 1];
            float gz = GRADIENTS_4D[gi | 2];
            float gw = GRADIENTS_4D[gi | 3];
            float rampValue = gx * dx + gy * dy + gz * dz + gw * dw;
            value += aa * aa * rampValue;
            dVdx += gx * aaaa + 8.0f * rampValue * naaa * dx;
            dVdy += gy * aaaa + 8.0f * rampValue * naaa * dy;
            dVdz += gz * aaaa + 8.0f * rampValue * naaa * dz;
            dVdw += gw * aaaa + 8.0f * rampValue * naaa * dw;
        }
        gradient.set(dVdx, dVdy, dVdz, dVdw);
        return value;
    }

    private static float grad(long seed, long xrvp, long yrvp, long zrvp, float dx, float dy, float dz) {
        long hash = seed ^ xrvp ^ (yrvp ^ zrvp);
        hash *= 6026932503003350773L;
        hash ^= hash >> 54;
        return OpenSimplex2S.grad((int)hash, dx, dy, dz);
    }

    private static float grad(int hash, float dx, float dy, float dz) {
        int gi = hash & 0x3FC;
        return GRADIENTS_3D[gi | 0] * dx + GRADIENTS_3D[gi | 1] * dy + GRADIENTS_3D[gi | 2] * dz;
    }

    private static int v3Hash(long seed, long xrvp, long yrvp, long zrvp) {
        long hash = seed ^ xrvp ^ (yrvp ^ zrvp);
        hash *= 6026932503003350773L;
        hash ^= hash >> 310;
        return (int)hash;
    }

    private static int v4GradIndex(long seed, long xsvp, long ysvp, long zsvp, long wsvp) {
        long hash = seed ^ (xsvp ^ ysvp) ^ (zsvp ^ wsvp);
        hash *= 6026932503003350773L;
        hash ^= hash >> 53;
        return (int)hash & 0x7FC;
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    /*
     * Opcode count of 22827 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int i;
        int i2;
        int i3;
        GRADIENTS_3D = new float[1024];
        float[] grad3 = new float[]{2.2247448f, 2.2247448f, -1.0f, 0.0f, 2.2247448f, 2.2247448f, 1.0f, 0.0f, 3.0862665f, 1.1721513f, 0.0f, 0.0f, 1.1721513f, 3.0862665f, 0.0f, 0.0f, -2.2247448f, 2.2247448f, -1.0f, 0.0f, -2.2247448f, 2.2247448f, 1.0f, 0.0f, -1.1721513f, 3.0862665f, 0.0f, 0.0f, -3.0862665f, 1.1721513f, 0.0f, 0.0f, -1.0f, -2.2247448f, -2.2247448f, 0.0f, 1.0f, -2.2247448f, -2.2247448f, 0.0f, 0.0f, -3.0862665f, -1.1721513f, 0.0f, 0.0f, -1.1721513f, -3.0862665f, 0.0f, -1.0f, -2.2247448f, 2.2247448f, 0.0f, 1.0f, -2.2247448f, 2.2247448f, 0.0f, 0.0f, -1.1721513f, 3.0862665f, 0.0f, 0.0f, -3.0862665f, 1.1721513f, 0.0f, -2.2247448f, -2.2247448f, -1.0f, 0.0f, -2.2247448f, -2.2247448f, 1.0f, 0.0f, -3.0862665f, -1.1721513f, 0.0f, 0.0f, -1.1721513f, -3.0862665f, 0.0f, 0.0f, -2.2247448f, -1.0f, -2.2247448f, 0.0f, -2.2247448f, 1.0f, -2.2247448f, 0.0f, -1.1721513f, 0.0f, -3.0862665f, 0.0f, -3.0862665f, 0.0f, -1.1721513f, 0.0f, -2.2247448f, -1.0f, 2.2247448f, 0.0f, -2.2247448f, 1.0f, 2.2247448f, 0.0f, -3.0862665f, 0.0f, 1.1721513f, 0.0f, -1.1721513f, 0.0f, 3.0862665f, 0.0f, -1.0f, 2.2247448f, -2.2247448f, 0.0f, 1.0f, 2.2247448f, -2.2247448f, 0.0f, 0.0f, 1.1721513f, -3.0862665f, 0.0f, 0.0f, 3.0862665f, -1.1721513f, 0.0f, -1.0f, 2.2247448f, 2.2247448f, 0.0f, 1.0f, 2.2247448f, 2.2247448f, 0.0f, 0.0f, 3.0862665f, 1.1721513f, 0.0f, 0.0f, 1.1721513f, 3.0862665f, 0.0f, 2.2247448f, -2.2247448f, -1.0f, 0.0f, 2.2247448f, -2.2247448f, 1.0f, 0.0f, 1.1721513f, -3.0862665f, 0.0f, 0.0f, 3.0862665f, -1.1721513f, 0.0f, 0.0f, 2.2247448f, -1.0f, -2.2247448f, 0.0f, 2.2247448f, 1.0f, -2.2247448f, 0.0f, 3.0862665f, 0.0f, -1.1721513f, 0.0f, 1.1721513f, 0.0f, -3.0862665f, 0.0f, 2.2247448f, -1.0f, 2.2247448f, 0.0f, 2.2247448f, 1.0f, 2.2247448f, 0.0f, 1.1721513f, 0.0f, 3.0862665f, 0.0f, 3.0862665f, 0.0f, 1.1721513f, 0.0f};
        for (i3 = 0; i3 < grad3.length; ++i3) {
            grad3[i3] = (float)((double)grad3[i3] / 0.2781926117527186);
        }
        i3 = 0;
        int j = 0;
        while (i3 < GRADIENTS_3D.length) {
            if (j == grad3.length) {
                j = 0;
            }
            OpenSimplex2S.GRADIENTS_3D[i3] = grad3[j];
            ++i3;
            ++j;
        }
        GRADIENTS_4D = new float[2048];
        float[] grad4 = new float[]{-0.6740059f, -0.32398477f, -0.32398477f, 0.5794685f, -0.7504884f, -0.40046722f, 0.15296486f, 0.502986f, -0.7504884f, 0.15296486f, -0.40046722f, 0.502986f, -0.8828162f, 0.08164729f, 0.08164729f, 0.4553054f, -0.4553054f, -0.08164729f, -0.08164729f, 0.8828162f, -0.502986f, -0.15296486f, 0.40046722f, 0.7504884f, -0.502986f, 0.40046722f, -0.15296486f, 0.7504884f, -0.5794685f, 0.32398477f, 0.32398477f, 0.6740059f, -0.6740059f, -0.32398477f, 0.5794685f, -0.32398477f, -0.7504884f, -0.40046722f, 0.502986f, 0.15296486f, -0.7504884f, 0.15296486f, 0.502986f, -0.40046722f, -0.8828162f, 0.08164729f, 0.4553054f, 0.08164729f, -0.4553054f, -0.08164729f, 0.8828162f, -0.08164729f, -0.502986f, -0.15296486f, 0.7504884f, 0.40046722f, -0.502986f, 0.40046722f, 0.7504884f, -0.15296486f, -0.5794685f, 0.32398477f, 0.6740059f, 0.32398477f, -0.6740059f, 0.5794685f, -0.32398477f, -0.32398477f, -0.7504884f, 0.502986f, -0.40046722f, 0.15296486f, -0.7504884f, 0.502986f, 0.15296486f, -0.40046722f, -0.8828162f, 0.4553054f, 0.08164729f, 0.08164729f, -0.4553054f, 0.8828162f, -0.08164729f, -0.08164729f, -0.502986f, 0.7504884f, -0.15296486f, 0.40046722f, -0.502986f, 0.7504884f, 0.40046722f, -0.15296486f, -0.5794685f, 0.6740059f, 0.32398477f, 0.32398477f, 0.5794685f, -0.6740059f, -0.32398477f, -0.32398477f, 0.502986f, -0.7504884f, -0.40046722f, 0.15296486f, 0.502986f, -0.7504884f, 0.15296486f, -0.40046722f, 0.4553054f, -0.8828162f, 0.08164729f, 0.08164729f, 0.8828162f, -0.4553054f, -0.08164729f, -0.08164729f, 0.7504884f, -0.502986f, -0.15296486f, 0.40046722f, 0.7504884f, -0.502986f, 0.40046722f, -0.15296486f, 0.6740059f, -0.5794685f, 0.32398477f, 0.32398477f, -0.753341f, -0.3796829f, -0.3796829f, -0.3796829f, -0.78216845f, -0.43214726f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, -0.43214726f, -0.85865086f, -0.5086297f, 0.04480237f, 0.04480237f, -0.85865086f, 0.04480237f, -0.5086297f, 0.04480237f, -0.85865086f, 0.04480237f, 0.04480237f, -0.5086297f, -0.9982829f, -0.033819415f, -0.033819415f, -0.033819415f, -0.3796829f, -0.753341f, -0.3796829f, -0.3796829f, -0.43214726f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, -0.43214726f, -0.5086297f, -0.85865086f, 0.04480237f, 0.04480237f, 0.04480237f, -0.85865086f, -0.5086297f, 0.04480237f, 0.04480237f, -0.85865086f, 0.04480237f, -0.5086297f, -0.033819415f, -0.9982829f, -0.033819415f, -0.033819415f, -0.3796829f, -0.3796829f, -0.753341f, -0.3796829f, -0.43214726f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, -0.43214726f, -0.5086297f, 0.04480237f, -0.85865086f, 0.04480237f, 0.04480237f, -0.5086297f, -0.85865086f, 0.04480237f, 0.04480237f, 0.04480237f, -0.85865086f, -0.5086297f, -0.033819415f, -0.033819415f, -0.9982829f, -0.033819415f, -0.3796829f, -0.3796829f, -0.3796829f, -0.753341f, -0.43214726f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, -0.43214726f, -0.78216845f, -0.5086297f, 0.04480237f, 0.04480237f, -0.85865086f, 0.04480237f, -0.5086297f, 0.04480237f, -0.85865086f, 0.04480237f, 0.04480237f, -0.5086297f, -0.85865086f, -0.033819415f, -0.033819415f, -0.033819415f, -0.9982829f, -0.32398477f, -0.6740059f, -0.32398477f, 0.5794685f, -0.40046722f, -0.7504884f, 0.15296486f, 0.502986f, 0.15296486f, -0.7504884f, -0.40046722f, 0.502986f, 0.08164729f, -0.8828162f, 0.08164729f, 0.4553054f, -0.08164729f, -0.4553054f, -0.08164729f, 0.8828162f, -0.15296486f, -0.502986f, 0.40046722f, 0.7504884f, 0.40046722f, -0.502986f, -0.15296486f, 0.7504884f, 0.32398477f, -0.5794685f, 0.32398477f, 0.6740059f, -0.32398477f, -0.32398477f, -0.6740059f, 0.5794685f, -0.40046722f, 0.15296486f, -0.7504884f, 0.502986f, 0.15296486f, -0.40046722f, -0.7504884f, 0.502986f, 0.08164729f, 0.08164729f, -0.8828162f, 0.4553054f, -0.08164729f, -0.08164729f, -0.4553054f, 0.8828162f, -0.15296486f, 0.40046722f, -0.502986f, 0.7504884f, 0.40046722f, -0.15296486f, -0.502986f, 0.7504884f, 0.32398477f, 0.32398477f, -0.5794685f, 0.6740059f, -0.32398477f, -0.6740059f, 0.5794685f, -0.32398477f, -0.40046722f, -0.7504884f, 0.502986f, 0.15296486f, 0.15296486f, -0.7504884f, 0.502986f, -0.40046722f, 0.08164729f, -0.8828162f, 0.4553054f, 0.08164729f, -0.08164729f, -0.4553054f, 0.8828162f, -0.08164729f, -0.15296486f, -0.502986f, 0.7504884f, 0.40046722f, 0.40046722f, -0.502986f, 0.7504884f, -0.15296486f, 0.32398477f, -0.5794685f, 0.6740059f, 0.32398477f, -0.32398477f, -0.32398477f, 0.5794685f, -0.6740059f, -0.40046722f, 0.15296486f, 0.502986f, -0.7504884f, 0.15296486f, -0.40046722f, 0.502986f, -0.7504884f, 0.08164729f, 0.08164729f, 0.4553054f, -0.8828162f, -0.08164729f, -0.08164729f, 0.8828162f, -0.4553054f, -0.15296486f, 0.40046722f, 0.7504884f, -0.502986f, 0.40046722f, -0.15296486f, 0.7504884f, -0.502986f, 0.32398477f, 0.32398477f, 0.6740059f, -0.5794685f, -0.32398477f, 0.5794685f, -0.6740059f, -0.32398477f, -0.40046722f, 0.502986f, -0.7504884f, 0.15296486f, 0.15296486f, 0.502986f, -0.7504884f, -0.40046722f, 0.08164729f, 0.4553054f, -0.8828162f, 0.08164729f, -0.08164729f, 0.8828162f, -0.4553054f, -0.08164729f, -0.15296486f, 0.7504884f, -0.502986f, 0.40046722f, 0.40046722f, 0.7504884f, -0.502986f, -0.15296486f, 0.32398477f, 0.6740059f, -0.5794685f, 0.32398477f, -0.32398477f, 0.5794685f, -0.32398477f, -0.6740059f, -0.40046722f, 0.502986f, 0.15296486f, -0.7504884f, 0.15296486f, 0.502986f, -0.40046722f, -0.7504884f, 0.08164729f, 0.4553054f, 0.08164729f, -0.8828162f, -0.08164729f, 0.8828162f, -0.08164729f, -0.4553054f, -0.15296486f, 0.7504884f, 0.40046722f, -0.502986f, 0.40046722f, 0.7504884f, -0.15296486f, -0.502986f, 0.32398477f, 0.6740059f, 0.32398477f, -0.5794685f, 0.5794685f, -0.32398477f, -0.6740059f, -0.32398477f, 0.502986f, -0.40046722f, -0.7504884f, 0.15296486f, 0.502986f, 0.15296486f, -0.7504884f, -0.40046722f, 0.4553054f, 0.08164729f, -0.8828162f, 0.08164729f, 0.8828162f, -0.08164729f, -0.4553054f, -0.08164729f, 0.7504884f, -0.15296486f, -0.502986f, 0.40046722f, 0.7504884f, 0.40046722f, -0.502986f, -0.15296486f, 0.6740059f, 0.32398477f, -0.5794685f, 0.32398477f, 0.5794685f, -0.32398477f, -0.32398477f, -0.6740059f, 0.502986f, -0.40046722f, 0.15296486f, -0.7504884f, 0.502986f, 0.15296486f, -0.40046722f, -0.7504884f, 0.4553054f, 0.08164729f, 0.08164729f, -0.8828162f, 0.8828162f, -0.08164729f, -0.08164729f, -0.4553054f, 0.7504884f, -0.15296486f, 0.40046722f, -0.502986f, 0.7504884f, 0.40046722f, -0.15296486f, -0.502986f, 0.6740059f, 0.32398477f, 0.32398477f, -0.5794685f, 0.033819415f, 0.033819415f, 0.033819415f, 0.9982829f, -0.04480237f, -0.04480237f, 0.5086297f, 0.85865086f, -0.04480237f, 0.5086297f, -0.04480237f, 0.85865086f, -0.121284805f, 0.43214726f, 0.43214726f, 0.78216845f, 0.5086297f, -0.04480237f, -0.04480237f, 0.85865086f, 0.43214726f, -0.121284805f, 0.43214726f, 0.78216845f, 0.43214726f, 0.43214726f, -0.121284805f, 0.78216845f, 0.3796829f, 0.3796829f, 0.3796829f, 0.753341f, 0.033819415f, 0.033819415f, 0.9982829f, 0.033819415f, -0.04480237f, 0.04480237f, 0.85865086f, 0.5086297f, -0.04480237f, 0.5086297f, 0.85865086f, -0.04480237f, -0.121284805f, 0.43214726f, 0.78216845f, 0.43214726f, 0.5086297f, -0.04480237f, 0.85865086f, -0.04480237f, 0.43214726f, -0.121284805f, 0.78216845f, 0.43214726f, 0.43214726f, 0.43214726f, 0.78216845f, -0.121284805f, 0.3796829f, 0.3796829f, 0.753341f, 0.3796829f, 0.033819415f, 0.9982829f, 0.033819415f, 0.033819415f, -0.04480237f, 0.85865086f, -0.04480237f, 0.5086297f, -0.04480237f, 0.85865086f, 0.5086297f, -0.04480237f, -0.121284805f, 0.78216845f, 0.43214726f, 0.43214726f, 0.5086297f, 0.85865086f, -0.04480237f, -0.04480237f, 0.43214726f, 0.78216845f, -0.121284805f, 0.43214726f, 0.43214726f, 0.78216845f, 0.43214726f, -0.121284805f, 0.3796829f, 0.753341f, 0.3796829f, 0.3796829f, 0.9982829f, 0.033819415f, 0.033819415f, 0.033819415f, 0.85865086f, -0.04480237f, -0.04480237f, 0.5086297f, 0.85865086f, -0.04480237f, 0.5086297f, -0.04480237f, 0.78216845f, -0.121284805f, 0.43214726f, 0.43214726f, 0.85865086f, 0.5086297f, -0.04480237f, -0.04480237f, 0.78216845f, 0.43214726f, -0.121284805f, 0.43214726f, 0.78216845f, 0.43214726f, 0.43214726f, -0.121284805f, 0.753341f, 0.3796829f, 0.3796829f, 0.3796829f};
        for (i2 = 0; i2 < grad4.length; ++i2) {
            grad4[i2] = (float)((double)grad4[i2] / 0.11127401889945551);
        }
        i2 = 0;
        int j2 = 0;
        while (i2 < GRADIENTS_4D.length) {
            if (j2 == grad4.length) {
                j2 = 0;
            }
            OpenSimplex2S.GRADIENTS_4D[i2] = grad4[j2];
            ++i2;
            ++j2;
        }
        int[][] lookup4DVertexCodes = new int[][]{{21, 69, 81, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {21, 69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 170}, {1, 5, 17, 21, 65, 69, 81, 85, 86, 90, 102, 106, 150, 154, 166, 170}, {1, 21, 22, 69, 70, 81, 82, 85, 86, 90, 102, 106, 150, 154, 166, 170, 171}, {21, 69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 169, 170}, {5, 21, 69, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 170}, {5, 21, 69, 85, 86, 89, 90, 102, 106, 150, 154, 170}, {5, 21, 22, 69, 70, 85, 86, 89, 90, 102, 106, 150, 154, 170, 171}, {4, 5, 20, 21, 68, 69, 84, 85, 89, 90, 105, 106, 153, 154, 169, 170}, {5, 21, 69, 85, 86, 89, 90, 105, 106, 153, 154, 170}, {5, 21, 69, 85, 86, 89, 90, 106, 154, 170}, {5, 21, 22, 69, 70, 85, 86, 89, 90, 91, 106, 154, 170, 171}, {4, 21, 25, 69, 73, 84, 85, 88, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {5, 21, 25, 69, 73, 85, 86, 89, 90, 105, 106, 153, 154, 170, 174}, {5, 21, 25, 69, 73, 85, 86, 89, 90, 94, 106, 154, 170, 174}, {5, 21, 26, 69, 74, 85, 86, 89, 90, 91, 94, 106, 154, 170, 171, 174, 175}, {21, 81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 165, 166, 169, 170}, {17, 21, 81, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 165, 166, 170}, {17, 21, 81, 85, 86, 90, 101, 102, 106, 150, 166, 170}, {17, 21, 22, 81, 82, 85, 86, 90, 101, 102, 106, 150, 166, 170, 171}, {20, 21, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 153, 165, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 149, 154, 166, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 150, 154, 166, 170, 171}, {21, 22, 85, 86, 90, 102, 106, 107, 150, 154, 166, 170, 171}, {20, 21, 84, 85, 89, 90, 101, 105, 106, 153, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 154, 170}, {21, 22, 85, 86, 89, 90, 102, 106, 107, 154, 170, 171}, {20, 21, 25, 84, 85, 88, 89, 90, 101, 105, 106, 153, 169, 170, 174}, {21, 25, 85, 89, 90, 105, 106, 110, 153, 154, 169, 170, 174}, {21, 25, 85, 86, 89, 90, 105, 106, 110, 154, 170, 174}, {21, 26, 85, 86, 89, 90, 106, 107, 110, 154, 170, 171, 174, 175}, {16, 17, 20, 21, 80, 81, 84, 85, 101, 102, 105, 106, 165, 166, 169, 170}, {17, 21, 81, 85, 86, 101, 102, 105, 106, 165, 166, 170}, {17, 21, 81, 85, 86, 101, 102, 106, 166, 170}, {17, 21, 22, 81, 82, 85, 86, 101, 102, 103, 106, 166, 170, 171}, {20, 21, 84, 85, 89, 101, 102, 105, 106, 165, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 166, 170}, {21, 22, 85, 86, 90, 101, 102, 106, 107, 166, 170, 171}, {20, 21, 84, 85, 89, 101, 105, 106, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 170}, {21, 22, 85, 86, 89, 90, 101, 102, 105, 106, 107, 170, 171}, {20, 21, 25, 84, 85, 88, 89, 101, 105, 106, 109, 169, 170, 174}, {21, 25, 85, 89, 90, 101, 105, 106, 110, 169, 170, 174}, {21, 25, 85, 86, 89, 90, 101, 102, 105, 106, 110, 170, 174}, {21, 85, 86, 89, 90, 102, 105, 106, 107, 110, 154, 170, 171, 174, 175}, {16, 21, 37, 81, 84, 85, 97, 100, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {17, 21, 37, 81, 85, 86, 97, 101, 102, 105, 106, 165, 166, 170, 186}, {17, 21, 37, 81, 85, 86, 97, 101, 102, 106, 118, 166, 170, 186}, {17, 21, 38, 81, 85, 86, 98, 101, 102, 103, 106, 118, 166, 170, 171, 186, 187}, {20, 21, 37, 84, 85, 89, 100, 101, 102, 105, 106, 165, 169, 170, 186}, {21, 37, 85, 101, 102, 105, 106, 122, 165, 166, 169, 170, 186}, {21, 37, 85, 86, 101, 102, 105, 106, 122, 166, 170, 186}, {21, 38, 85, 86, 101, 102, 106, 107, 122, 166, 170, 171, 186, 187}, {20, 21, 37, 84, 85, 89, 100, 101, 105, 106, 121, 169, 170, 186}, {21, 37, 85, 89, 101, 102, 105, 106, 122, 169, 170, 186}, {21, 37, 85, 86, 89, 90, 101, 102, 105, 106, 122, 170, 186}, {21, 85, 86, 90, 101, 102, 105, 106, 107, 122, 166, 170, 171, 186, 187}, {20, 21, 41, 84, 85, 89, 101, 104, 105, 106, 109, 121, 169, 170, 174, 186, 190}, {21, 41, 85, 89, 101, 105, 106, 110, 122, 169, 170, 174, 186, 190}, {21, 85, 89, 90, 101, 102, 105, 106, 110, 122, 169, 170, 174, 186, 190}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 107, 110, 122, 170, 171, 174, 186, 191}, {69, 81, 84, 85, 86, 89, 101, 149, 150, 153, 154, 165, 166, 169, 170}, {65, 69, 81, 85, 86, 89, 90, 101, 102, 149, 150, 153, 154, 165, 166, 170}, {65, 69, 81, 85, 86, 90, 102, 149, 150, 154, 166, 170}, {65, 69, 70, 81, 82, 85, 86, 90, 102, 149, 150, 154, 166, 170, 171}, {68, 69, 84, 85, 86, 89, 90, 101, 105, 149, 150, 153, 154, 165, 169, 170}, {69, 85, 86, 89, 90, 101, 106, 149, 150, 153, 154, 166, 169, 170}, {69, 85, 86, 89, 90, 102, 106, 149, 150, 153, 154, 166, 170, 171}, {69, 70, 85, 86, 90, 102, 106, 150, 154, 155, 166, 170, 171}, {68, 69, 84, 85, 89, 90, 105, 149, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 105, 106, 149, 150, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 106, 149, 150, 153, 154, 170}, {69, 70, 85, 86, 89, 90, 106, 150, 154, 155, 170, 171}, {68, 69, 73, 84, 85, 88, 89, 90, 105, 149, 153, 154, 169, 170, 174}, {69, 73, 85, 89, 90, 105, 106, 153, 154, 158, 169, 170, 174}, {69, 73, 85, 86, 89, 90, 106, 153, 154, 158, 170, 174}, {69, 74, 85, 86, 89, 90, 106, 154, 155, 158, 170, 171, 174, 175}, {80, 81, 84, 85, 86, 89, 101, 102, 105, 149, 150, 153, 165, 166, 169, 170}, {81, 85, 86, 89, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170}, {81, 85, 86, 90, 101, 102, 106, 149, 150, 154, 165, 166, 170, 171}, {81, 82, 85, 86, 90, 102, 106, 150, 154, 166, 167, 170, 171}, {84, 85, 86, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {21, 69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 170, 171}, {85, 86, 90, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 89, 90, 101, 105, 106, 149, 153, 154, 165, 169, 170, 174}, {21, 69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 169, 170, 174}, {21, 69, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 166, 169, 170, 171, 174}, {85, 86, 89, 90, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 88, 89, 90, 105, 106, 153, 154, 169, 170, 173, 174}, {85, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {85, 86, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {85, 86, 89, 90, 106, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 102, 105, 149, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 105, 106, 149, 150, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 106, 149, 150, 165, 166, 170}, {81, 82, 85, 86, 101, 102, 106, 150, 166, 167, 170, 171}, {84, 85, 89, 101, 102, 105, 106, 149, 153, 165, 166, 169, 170, 186}, {21, 81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 165, 166, 169, 170, 186}, {21, 81, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 154, 165, 166, 169, 170, 171, 186}, {85, 86, 90, 101, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 89, 101, 105, 106, 149, 153, 165, 169, 170}, {21, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 153, 154, 165, 166, 169, 170, 174, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 154, 166, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 150, 154, 166, 170, 171}, {84, 85, 88, 89, 101, 105, 106, 153, 169, 170, 173, 174}, {85, 89, 90, 101, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 102, 105, 106, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 97, 100, 101, 102, 105, 149, 165, 166, 169, 170, 186}, {81, 85, 97, 101, 102, 105, 106, 165, 166, 169, 170, 182, 186}, {81, 85, 86, 97, 101, 102, 106, 165, 166, 170, 182, 186}, {81, 85, 86, 98, 101, 102, 106, 166, 167, 170, 171, 182, 186, 187}, {84, 85, 100, 101, 102, 105, 106, 165, 166, 169, 170, 185, 186}, {85, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {85, 86, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {85, 86, 101, 102, 106, 166, 170, 171, 186, 187}, {84, 85, 89, 100, 101, 105, 106, 165, 169, 170, 185, 186}, {85, 89, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 90, 101, 102, 105, 106, 166, 170, 171, 186, 187}, {84, 85, 89, 101, 104, 105, 106, 169, 170, 173, 174, 185, 186, 190}, {85, 89, 101, 105, 106, 169, 170, 174, 186, 190}, {21, 85, 89, 90, 101, 102, 105, 106, 169, 170, 174, 186, 190}, {85, 86, 89, 90, 101, 102, 105, 106, 170, 171, 174, 186, 191}, {64, 65, 68, 69, 80, 81, 84, 85, 149, 150, 153, 154, 165, 166, 169, 170}, {65, 69, 81, 85, 86, 149, 150, 153, 154, 165, 166, 170}, {65, 69, 81, 85, 86, 149, 150, 154, 166, 170}, {65, 69, 70, 81, 82, 85, 86, 149, 150, 151, 154, 166, 170, 171}, {68, 69, 84, 85, 89, 149, 150, 153, 154, 165, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 166, 170}, {69, 70, 85, 86, 90, 149, 150, 154, 155, 166, 170, 171}, {68, 69, 84, 85, 89, 149, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 170}, {69, 70, 85, 86, 89, 90, 149, 150, 153, 154, 155, 170, 171}, {68, 69, 73, 84, 85, 88, 89, 149, 153, 154, 157, 169, 170, 174}, {69, 73, 85, 89, 90, 149, 153, 154, 158, 169, 170, 174}, {69, 73, 85, 86, 89, 90, 149, 150, 153, 154, 158, 170, 174}, {69, 85, 86, 89, 90, 106, 150, 153, 154, 155, 158, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 149, 150, 153, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 101, 102, 149, 150, 154, 165, 166, 170}, {81, 82, 85, 86, 102, 149, 150, 154, 166, 167, 170, 171}, {84, 85, 89, 101, 105, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 81, 84, 85, 86, 89, 101, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 234}, {85, 86, 90, 102, 106, 149, 150, 154, 166, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 154, 165, 169, 170}, {69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 174, 234}, {69, 85, 86, 89, 90, 106, 149, 150, 153, 154, 166, 169, 170}, {69, 85, 86, 89, 90, 102, 106, 149, 150, 153, 154, 166, 170, 171}, {84, 85, 88, 89, 105, 149, 153, 154, 169, 170, 173, 174}, {85, 89, 90, 105, 106, 149, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 105, 106, 149, 150, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 106, 150, 153, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 149, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 170}, {81, 82, 85, 86, 101, 102, 149, 150, 165, 166, 167, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 165, 166, 169, 170}, {81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 186, 234}, {81, 85, 86, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170}, {81, 85, 86, 90, 101, 102, 106, 149, 150, 154, 165, 166, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 165, 169, 170}, {84, 85, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 169, 170, 171}, {84, 85, 88, 89, 101, 105, 149, 153, 165, 169, 170, 173, 174}, {84, 85, 89, 90, 101, 105, 106, 149, 153, 154, 165, 169, 170, 174}, {85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 166, 169, 170, 174}, {85, 86, 89, 90, 102, 105, 106, 150, 153, 154, 166, 169, 170, 171, 174, 175}, {80, 81, 84, 85, 97, 100, 101, 149, 165, 166, 169, 170, 181, 186}, {81, 85, 97, 101, 102, 149, 165, 166, 169, 170, 182, 186}, {81, 85, 86, 97, 101, 102, 149, 150, 165, 166, 170, 182, 186}, {81, 85, 86, 101, 102, 106, 150, 165, 166, 167, 170, 171, 182, 186, 187}, {84, 85, 100, 101, 105, 149, 165, 166, 169, 170, 185, 186}, {85, 101, 102, 105, 106, 149, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 105, 106, 149, 150, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 106, 150, 165, 166, 170, 171, 186, 187}, {84, 85, 89, 100, 101, 105, 149, 153, 165, 169, 170, 185, 186}, {84, 85, 89, 101, 102, 105, 106, 149, 153, 165, 166, 169, 170, 186}, {85, 86, 89, 101, 102, 105, 106, 149, 154, 165, 166, 169, 170, 186}, {85, 86, 90, 101, 102, 105, 106, 150, 154, 165, 166, 169, 170, 171, 186, 187}, {84, 85, 89, 101, 105, 106, 153, 165, 169, 170, 173, 174, 185, 186, 190}, {84, 85, 89, 101, 105, 106, 153, 165, 169, 170, 174, 186, 190}, {85, 89, 90, 101, 102, 105, 106, 153, 154, 165, 166, 169, 170, 174, 186, 190}, {85, 86, 89, 90, 101, 102, 105, 106, 154, 166, 169, 170, 171, 174, 186}, {64, 69, 81, 84, 85, 133, 145, 148, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {65, 69, 81, 85, 86, 133, 145, 149, 150, 153, 154, 165, 166, 170, 234}, {65, 69, 81, 85, 86, 133, 145, 149, 150, 154, 166, 170, 214, 234}, {65, 69, 81, 85, 86, 134, 146, 149, 150, 151, 154, 166, 170, 171, 214, 234, 235}, {68, 69, 84, 85, 89, 133, 148, 149, 150, 153, 154, 165, 169, 170, 234}, {69, 85, 133, 149, 150, 153, 154, 165, 166, 169, 170, 218, 234}, {69, 85, 86, 133, 149, 150, 153, 154, 166, 170, 218, 234}, {69, 85, 86, 134, 149, 150, 154, 155, 166, 170, 171, 218, 234, 235}, {68, 69, 84, 85, 89, 133, 148, 149, 153, 154, 169, 170, 217, 234}, {69, 85, 89, 133, 149, 150, 153, 154, 169, 170, 218, 234}, {69, 85, 86, 89, 90, 133, 149, 150, 153, 154, 170, 218, 234}, {69, 85, 86, 90, 149, 150, 153, 154, 155, 166, 170, 171, 218, 234, 235}, {68, 69, 84, 85, 89, 137, 149, 152, 153, 154, 157, 169, 170, 174, 217, 234, 238}, {69, 85, 89, 137, 149, 153, 154, 158, 169, 170, 174, 218, 234, 238}, {69, 85, 89, 90, 149, 150, 153, 154, 158, 169, 170, 174, 218, 234, 238}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 155, 158, 170, 171, 174, 218, 234, 239}, {80, 81, 84, 85, 101, 145, 148, 149, 150, 153, 165, 166, 169, 170, 234}, {81, 85, 145, 149, 150, 153, 154, 165, 166, 169, 170, 230, 234}, {81, 85, 86, 145, 149, 150, 154, 165, 166, 170, 230, 234}, {81, 85, 86, 146, 149, 150, 154, 166, 167, 170, 171, 230, 234, 235}, {84, 85, 148, 149, 150, 153, 154, 165, 166, 169, 170, 233, 234}, {85, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 149, 150, 154, 166, 170, 171, 234, 235}, {84, 85, 89, 148, 149, 153, 154, 165, 169, 170, 233, 234}, {85, 89, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 90, 149, 150, 153, 154, 166, 170, 171, 234, 235}, {84, 85, 89, 149, 152, 153, 154, 169, 170, 173, 174, 233, 234, 238}, {85, 89, 149, 153, 154, 169, 170, 174, 234, 238}, {69, 85, 89, 90, 149, 150, 153, 154, 169, 170, 174, 234, 238}, {85, 86, 89, 90, 149, 150, 153, 154, 170, 171, 174, 234, 239}, {80, 81, 84, 85, 101, 145, 148, 149, 165, 166, 169, 170, 229, 234}, {81, 85, 101, 145, 149, 150, 165, 166, 169, 170, 230, 234}, {81, 85, 86, 101, 102, 145, 149, 150, 165, 166, 170, 230, 234}, {81, 85, 86, 102, 149, 150, 154, 165, 166, 167, 170, 171, 230, 234, 235}, {84, 85, 101, 148, 149, 153, 165, 166, 169, 170, 233, 234}, {85, 101, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 101, 102, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 102, 149, 150, 154, 165, 166, 170, 171, 234, 235}, {84, 85, 89, 101, 105, 148, 149, 153, 165, 169, 170, 233, 234}, {84, 85, 89, 101, 105, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 89, 101, 106, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 90, 102, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 234, 235}, {84, 85, 89, 105, 149, 153, 154, 165, 169, 170, 173, 174, 233, 234, 238}, {84, 85, 89, 105, 149, 153, 154, 165, 169, 170, 174, 234, 238}, {85, 89, 90, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 174, 234, 238}, {85, 86, 89, 90, 106, 149, 150, 153, 154, 166, 169, 170, 171, 174, 234}, {80, 81, 84, 85, 101, 149, 161, 164, 165, 166, 169, 170, 181, 186, 229, 234, 250}, {81, 85, 101, 149, 161, 165, 166, 169, 170, 182, 186, 230, 234, 250}, {81, 85, 101, 102, 149, 150, 165, 166, 169, 170, 182, 186, 230, 234, 250}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 167, 170, 171, 182, 186, 230, 234, 251}, {84, 85, 101, 149, 164, 165, 166, 169, 170, 185, 186, 233, 234, 250}, {85, 101, 149, 165, 166, 169, 170, 186, 234, 250}, {81, 85, 101, 102, 149, 150, 165, 166, 169, 170, 186, 234, 250}, {85, 86, 101, 102, 149, 150, 165, 166, 170, 171, 186, 234, 251}, {84, 85, 101, 105, 149, 153, 165, 166, 169, 170, 185, 186, 233, 234, 250}, {84, 85, 101, 105, 149, 153, 165, 166, 169, 170, 186, 234, 250}, {85, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 186, 234, 250}, {85, 86, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170, 171, 186, 234}, {84, 85, 89, 101, 105, 149, 153, 165, 169, 170, 173, 174, 185, 186, 233, 234, 254}, {85, 89, 101, 105, 149, 153, 165, 169, 170, 174, 186, 234, 254}, {85, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170, 174, 186, 234}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 174, 186, 234}};
        LatticeVertex4D[] latticeVerticesByCode = new LatticeVertex4D[256];
        for (int i4 = 0; i4 < 256; ++i4) {
            int cx = (i4 >> 0 & 3) - 1;
            int cy = (i4 >> 2 & 3) - 1;
            int cz = (i4 >> 4 & 3) - 1;
            int cw = (i4 >> 6 & 3) - 1;
            latticeVerticesByCode[i4] = new LatticeVertex4D(cx, cy, cz, cw);
        }
        int nLatticeVerticesTotal = 0;
        for (i = 0; i < 256; ++i) {
            nLatticeVerticesTotal += lookup4DVertexCodes[i].length;
        }
        LOOKUP_4D_A = new int[256];
        LOOKUP_4D_B = new LatticeVertex4D[nLatticeVerticesTotal];
        int j3 = 0;
        for (i = 0; i < 256; ++i) {
            OpenSimplex2S.LOOKUP_4D_A[i] = j3 | j3 + lookup4DVertexCodes[i].length << 16;
            for (int k = 0; k < lookup4DVertexCodes[i].length; ++k) {
                OpenSimplex2S.LOOKUP_4D_B[j3++] = latticeVerticesByCode[lookup4DVertexCodes[i][k]];
            }
        }
        OUTPUT_VEC3 = new float[]{-0.785581f, -0.5120243f, 0.34740984f, 0.0f, 0.44195008f, -0.5220253f, -0.72949964f, 0.0f, 0.6523541f, 0.15368964f, 0.7421682f, 0.0f, -0.30872318f, 0.8803599f, -0.36007833f, 0.0f, 0.6898583f, 0.5452765f, -0.47620273f, 0.0f, -0.31541684f, 0.4948706f, 0.8097007f, 0.0f, 0.39922526f, -0.87373793f, 0.2778511f, 0.0f, -0.77366674f, -0.16640916f, -0.6113491f, 0.0f, 0.7639719f, 0.4777093f, 0.43375194f, 0.0f, -0.8625241f, 0.39877898f, 0.3114924f, 0.0f, 0.028345693f, -0.9683322f, 0.24805106f, 0.0f, 0.070206486f, 0.09184391f, -0.9932954f, 0.0f, 0.17898594f, 0.27700987f, -0.94404954f, 0.0f, 0.69886434f, -0.6519002f, 0.29430386f, 0.0f, -0.901297f, -0.429545f, 0.056168288f, 0.0f, 0.02344668f, 0.8044353f, 0.5935774f, 0.0f, -0.090783685f, 0.96886706f, 0.23033662f, 0.0f, -0.82653123f, -0.3097547f, -0.469998f, 0.0f, 0.12608837f, -0.53138214f, 0.8376961f, 0.0f, 0.79122657f, -0.12773019f, -0.5980347f, 0.0f, 0.9658556f, 0.25087538f, -0.06468766f, 0.0f, -0.19584262f, -0.33726877f, 0.92081237f, 0.0f, -0.20384087f, -0.71605057f, -0.66762304f, 0.0f, -0.5661721f, 0.8024439f, -0.1885017f, 0.0f, 0.47478813f, -0.040413268f, -0.8791718f, 0.0f, 0.2062869f, -0.8235499f, 0.5284044f, 0.0f, -0.98606974f, 0.057649244f, -0.1560226f, 0.0f, 0.3049947f, 0.80631393f, 0.5067899f, 0.0f, 0.309108f, 0.71791905f, -0.62373435f, 0.0f, -0.99187034f, 0.060172707f, 0.11212694f, 0.0f, 0.44359803f, 0.11671667f, 0.88859326f, 0.0f, 0.23916434f, -0.8948084f, -0.37698588f, 0.0f, 0.76432055f, -0.3545388f, 0.5386245f, 0.0f, -0.5579286f, -0.76200825f, -0.32872343f, 0.0f, 0.35318345f, 0.5156096f, -0.78064597f, 0.0f, -0.5595753f, 0.60093737f, 0.5707449f, 0.0f, -0.37360692f, -0.55274963f, 0.7449065f, 0.0f, 0.5390642f, 0.75143117f, 0.38047472f, 0.0f, -0.7496143f, 0.3715176f, -0.54777104f, 0.0f, 0.584157f, -0.57019913f, -0.5776102f, 0.0f, 0.07181288f, 0.93358034f, -0.3510992f, 0.0f, -0.95649666f, -0.20564815f, 0.20693718f, 0.0f, 0.54712194f, -0.08600273f, 0.832623f, 0.0f, 0.33756182f, -0.64192945f, -0.688461f, 0.0f, -0.3202365f, -0.6268258f, -0.7103084f, 0.0f, 0.57307243f, 0.7075491f, -0.41347587f, 0.0f, 0.53328156f, -0.5075548f, 0.67675614f, 0.0f, -0.7861175f, 0.42683154f, 0.44702813f, 0.0f, 0.99082124f, 0.097802326f, -0.093316466f, 0.0f, -0.21471022f, -0.9198782f, 0.32821283f, 0.0f, -0.43459556f, 0.14675795f, -0.88858813f, 0.0f, -0.34151548f, 0.6753179f, 0.65369177f, 0.0f, -0.7339346f, 0.6310958f, -0.2511137f, 0.0f, 0.4917497f, 0.3592956f, 0.79315126f, 0.0f, 0.6327216f, -0.09800524f, -0.76815253f, 0.0f, -0.39053673f, -0.89238614f, 0.22611502f, 0.0f, 0.11219128f, 0.5066429f, -0.8548252f, 0.0f, 0.046733536f, -0.9815045f, -0.18564712f, 0.0f, -0.8875261f, 0.22087154f, 0.40436763f, 0.0f, 0.7286013f, 0.2539901f, 0.6361047f, 0.0f, 0.59501386f, 0.7809812f, 0.18980747f, 0.0f, -0.49524927f, -0.2515845f, 0.8315247f, 0.0f, 0.5538741f, -0.7745888f, -0.30534527f, 0.0f, -0.65363866f, 0.24519211f, -0.71598697f, 0.0f, -0.41830817f, 0.12591492f, 0.8995353f, 0.0f, -0.081837535f, 0.84589994f, -0.5270255f, 0.0f, -0.46637022f, -0.7405837f, -0.4837712f, 0.0f, 0.96651596f, -0.23123114f, 0.11126148f, 0.0f, -0.42655477f, -0.826464f, 0.3674348f, 0.0f, 0.12589025f, -0.10043331f, -0.98694724f, 0.0f, 0.8886873f, 0.13892245f, 0.43696153f, 0.0f, -0.5880228f, 0.78797483f, 0.18255086f, 0.0f, 0.23617715f, -0.76326156f, -0.6013752f, 0.0f, -0.94914985f, 0.27025643f, -0.16148072f, 0.0f, 0.60397696f, 0.77385426f, -0.19068679f, 0.0f, 0.108995736f, -0.28084907f, 0.9535427f, 0.0f, 0.79242766f, 0.5408602f, -0.28200826f, 0.0f, 0.23132144f, -0.972324f, -0.0328092f, 0.0f, -0.7647095f, 0.18175286f, -0.6182114f, 0.0f, -0.25903967f, 0.24971098f, 0.9330289f, 0.0f, 0.43976018f, -0.69979686f, 0.5629346f, 0.0f, 0.28342572f, -0.11174767f, -0.9524612f, 0.0f, 0.27011716f, 0.90668535f, 0.3239728f, 0.0f, -0.99330306f, -0.09514083f, 0.06555384f, 0.0f, 0.93493223f, -0.26454577f, -0.23646829f, 0.0f, 0.008172545f, 0.53214574f, 0.8466133f, 0.0f, -0.5565375f, -0.82095534f, 0.127665f, 0.0f, -0.38656726f, 0.55335534f, -0.73781f, 0.0f, -0.14771666f, 0.5637174f, 0.8126515f, 0.0f, -0.81932735f, 0.01999102f, -0.57297736f, 0.0f, 0.18972892f, -0.94177675f, 0.2775959f, 0.0f, 0.7773151f, 0.35806832f, -0.5172701f, 0.0f, 0.9544042f, 0.15931967f, 0.25244784f, 0.0f, -0.03845851f, -0.61957234f, -0.7839969f, 0.0f, -0.43068993f, 0.8697217f, -0.24101941f, 0.0f, -0.48525572f, -0.40946904f, 0.77256846f, 0.0f, 0.062257145f, 0.7156352f, -0.69569415f, 0.0f, -0.27099815f, -0.8608683f, -0.43065745f, 0.0f, -0.68119645f, 0.25910932f, 0.6847143f, 0.0f, 0.8899375f, -0.11387627f, 0.44163725f, 0.0f, -0.090834185f, 0.42071554f, 0.90263367f, 0.0f, 0.91705924f, -0.3868496f, -0.09669412f, 0.0f, -0.1459413f, 0.6923292f, -0.7066692f, 0.0f, -0.6802837f, -0.72619516f, -0.099270344f, 0.0f, 0.7374615f, 0.6528284f, 0.1731059f, 0.0f, -0.010589428f, -0.6904336f, 0.7233182f, 0.0f, 0.14900921f, -0.44473958f, -0.88317776f, 0.0f, -0.87588125f, 0.48234484f, -0.013246338f, 0.0f, -0.14426169f, -0.32213f, -0.93563926f, 0.0f, 0.73118335f, -0.5322102f, 0.42675897f, 0.0f, -0.84375817f, -0.11198175f, 0.5249117f, 0.0f, 0.25683644f, 0.9663219f, -0.016031396f, 0.0f, -0.5876935f, -0.3434663f, -0.7325621f, 0.0f, 0.2531634f, 0.94806194f, -0.19257954f, 0.0f, 0.82601494f, -0.5609239f, 0.05535118f, 0.0f, -0.49148482f, -0.04367175f, 0.8697905f, 0.0f, -0.2992583f, 0.88667953f, 0.3524824f, 0.0f, 0.9918158f, -0.08056652f, 0.0990474f, 0.0f, -0.24562792f, -0.074626446f, -0.96648735f, 0.0f, -0.4469296f, -0.7314866f, 0.51495755f, 0.0f, 0.16481613f, 0.3856526f, 0.9078038f, 0.0f, 0.8471119f, 0.02334587f, -0.53090155f, 0.0f, -0.7016312f, 0.5372623f, -0.46804148f, 0.0f, -0.31029677f, -0.9462608f, 0.091139235f, 0.0f, -0.7201842f, -0.65839946f, 0.21873476f, 0.0f, -0.12488519f, 0.8256613f, 0.55017f, 0.0f, -0.04757203f, 0.23585193f, -0.9706239f, 0.0f, 0.8926414f, -0.40311378f, 0.20171912f, 0.0f, 0.97492313f, 0.19705318f, 0.10341603f, 0.0f, -0.31364375f, 0.32785073f, -0.8911462f, 0.0f, -0.5120791f, 0.46185988f, 0.7241964f, 0.0f, -0.14920028f, -0.9867638f, 0.063533746f, 0.0f, -0.77554274f, -0.26363766f, 0.5736102f, 0.0f, 0.36062604f, -0.80846596f, -0.46511465f, 0.0f, 0.7152662f, 0.4028073f, 0.5710871f, 0.0f, -0.30034953f, 0.6692963f, -0.67958266f, 0.0f, -0.88113564f, -0.42403254f, 0.20927584f, 0.0f, -0.05903562f, 0.47561595f, -0.8776698f, 0.0f, 0.70618635f, -0.7062286f, -0.050418057f, 0.0f, 0.23398492f, 0.6546452f, 0.718812f, 0.0f, 0.90566903f, 0.14492719f, -0.39844665f, 0.0f, -0.037390787f, -0.90575886f, 0.42214075f, 0.0f, -0.69370157f, 0.062219433f, -0.7175701f, 0.0f, -0.17457666f, 0.6986122f, 0.693876f, 0.0f, -0.97131217f, -0.19366594f, -0.13800786f, 0.0f, 0.5137988f, -0.27715752f, -0.81190795f, 0.0f, 0.33180422f, -0.50895816f, 0.7942717f, 0.0f, 0.1257092f, 0.9797817f, 0.15564412f, 0.0f, 0.32922494f, -0.06034862f, 0.94232106f, 0.0f, -0.6831407f, 0.7270671f, -0.0684999f, 0.0f, -0.41280264f, -0.8713221f, -0.26531455f, 0.0f, 0.7667184f, 0.20460358f, -0.6085066f, 0.0f, -0.2783187f, -0.95363176f, -0.11456518f, 0.0f, 0.30026987f, 0.36764494f, -0.88015634f, 0.0f, 0.7523949f, 0.05105669f, 0.6567306f, 0.0f, -0.7743461f, 0.5349301f, 0.33799094f, 0.0f, 0.46682087f, 0.87822413f, -0.10392601f, 0.0f, -0.052445807f, -0.23687515f, 0.97012347f, 0.0f, 0.5093345f, -0.70815456f, -0.48897392f, 0.0f, -0.9237096f, 0.06680554f, -0.37722358f, 0.0f, 0.8635864f, -0.44175482f, -0.24304563f, 0.0f, -0.4576867f, 0.31688565f, -0.83072644f, 0.0f, 0.18156114f, 0.7800603f, 0.5987833f, 0.0f, -0.5874609f, -0.6551911f, 0.47498873f, 0.0f, -0.60157126f, 0.07741824f, 0.7950588f, 0.0f, 0.6255295f, 0.77989316f, -0.021898665f, 0.0f, -0.55043584f, -0.009361596f, -0.834825f, 0.0f, 0.5264776f, -0.84794974f, 0.061664883f, 0.0f, 0.8339385f, 0.41304004f, -0.36598438f, 0.0f, 0.23565327f, -0.61886406f, 0.7493162f, 0.0f, -0.46291313f, -0.5129438f, -0.7229108f, 0.0f, -0.6066786f, 0.7187678f, 0.33957896f, 0.0f, -0.18492444f, 0.9471245f, -0.26221782f, 0.0f, 0.8104996f, -0.32804182f, -0.48526177f, 0.0f, -0.78530985f, -0.5713098f, -0.23852374f, 0.0f, 0.1597347f, -0.047772843f, 0.98600334f, 0.0f, -0.5846643f, -0.4761198f, 0.65686953f, 0.0f, 0.93853784f, 0.022778787f, 0.344424f, 0.0f, -0.3319118f, 0.93496615f, -0.12519144f, 0.0f, -0.021961713f, -0.4816251f, -0.87610215f, 0.0f, 0.07881018f, -0.7431176f, -0.66450375f, 0.0f, 0.47965074f, 0.8071591f, -0.3441356f, 0.0f, 0.40674263f, -0.284561f, 0.868093f, 0.0f, -0.9652035f, 0.22051945f, 0.14054637f, 0.0f, 0.4538839f, 0.84933543f, 0.2694787f, 0.0f, -0.93353605f, -0.00729983f, 0.35840917f, 0.0f, 0.50515616f, -0.7797638f, 0.36984545f, 0.0f, -0.025503948f, -0.062271778f, -0.9977333f, 0.0f, -0.40923423f, -0.06894318f, -0.909821f, 0.0f, -0.7070425f, -0.13328275f, 0.69449735f, 0.0f, 0.4116551f, 0.9043465f, 0.11268311f, 0.0f, 0.7046216f, -0.70212054f, 0.102640495f, 0.0f, -0.04732693f, -0.4366091f, 0.8984056f, 0.0f, -0.22538538f, 0.97023135f, 0.08861443f, 0.0f, -0.6520311f, -0.4385385f, -0.6184977f, 0.0f, 0.9247434f, -0.09508381f, -0.36852232f, 0.0f, 0.7148114f, -0.64082044f, -0.27998897f, 0.0f, 0.08817855f, 0.19141711f, 0.9775398f, 0.0f, -0.8975827f, -0.4018206f, -0.18134347f, 0.0f, 0.094592795f, 0.85122395f, -0.51620734f, 0.0f, 0.3883444f, -0.9200928f, 0.051165212f, 0.0f, 0.6681588f, 0.66306126f, 0.33751073f, 0.0f, -0.82656866f, 0.04461183f, 0.561065f, 0.0f, -0.22993457f, 0.2124197f, -0.949741f, 0.0f, 0.015661446f, -0.2995014f, -0.95396733f, 0.0f, -0.7435326f, 0.6556702f, 0.1313613f, 0.0f, 0.8715521f, 0.43441075f, 0.22734162f, 0.0f, -0.14368093f, -0.7905796f, 0.5952644f, 0.0f, -0.8179541f, -0.5576167f, 0.14147314f, 0.0f, -0.23282142f, 0.7984288f, -0.55525285f, 0.0f, 0.6957021f, -0.5422551f, -0.47112423f, 0.0f, 0.35507345f, 0.301443f, 0.8849039f, 0.0f, -0.35751346f, -0.20022364f, 0.9121922f, 0.0f, 0.037791964f, -0.8435244f, -0.5357596f, 0.0f, 0.91912955f, 0.3858494f, 0.07950521f, 0.0f, -0.5994081f, 0.65789866f, -0.45593783f, 0.0f, -0.6551222f, -0.277766f, 0.7026101f, 0.0f, -0.049152214f, 0.99046654f, -0.12868606f, 0.0f, -0.2195843f, -0.45926866f, -0.86072934f, 0.0f, 0.92385876f, -0.25343186f, 0.28680533f, 0.0f, -0.015744451f, 0.9962814f, 0.08470869f, 0.0f, 0.7017726f, -0.26734227f, -0.6603358f, 0.0f, -0.8931429f, -0.32199132f, -0.31403407f, 0.0f, 0.20711474f, -0.40694776f, 0.8896612f, 0.0f, -0.8592952f, 0.1730802f, -0.4813055f, 0.0f, -0.14530677f, 0.09207305f, 0.9850931f, 0.0f, 0.68833655f, 0.66106874f, -0.29863164f, 0.0f, 0.3162654f, -0.926222f, -0.20515598f, 0.0f, 0.9231931f, 0.28944358f, -0.2528575f, 0.0f, -0.43748358f, 0.71738833f, 0.5421827f, 0.0f, 0.050146185f, -0.8410951f, 0.53855765f, 0.0f, -0.5358557f, -0.16573682f, -0.8278828f, 0.0f, 0.55816656f, -0.8217994f, -0.11443727f, 0.0f, -0.06281051f, 0.22763938f, 0.97171766f, 0.0f, -0.91668826f, -0.16641024f, -0.3633046f, 0.0f, 0.42133224f, 0.7605702f, -0.4939758f, 0.0f, -0.6892017f, 0.42687243f, 0.58547497f, 0.0f, -0.41265672f, -0.24312429f, -0.8778411f, 0.0f, 0.34967965f, -0.82505965f, 0.44384766f, 0.0f, 0.7521788f, 0.6413115f, -0.15148151f, 0.0f, -0.464028f, 0.83548176f, 0.29436076f, 0.0f, 0.5824682f, 0.20194194f, -0.7873692f, 0.0f, -0.68039966f, -0.686639f, -0.25609213f, 0.0f, 0.56195945f, -0.3507847f, 0.74910057f, 0.0f, -0.9562752f, -0.28348097f, 0.071945876f, 0.0f, 0.11484365f, 0.8968595f, 0.42714623f, 0.0f, 0.25997007f, 0.054211106f, -0.96409374f, 0.0f, 0.5814615f, -0.66758966f, 0.4650016f, 0.0f, 0.8125787f, -0.50303346f, 0.29440317f, 0.0f, 0.2784776f, 0.81644744f, -0.5058298f, 0.0f, -0.5333305f, 0.27025327f, 0.8015745f, 0.0f, -0.5577258f, -0.5836672f, -0.5901479f, 0.0f, -0.8027023f, 0.4311004f, -0.412094f, 0.0f, 0.51682884f, 0.68277705f, 0.5164334f, 0.0f, 0.5794161f, -0.38238248f, -0.7197643f, 0.0f, -0.29354265f, -0.73149496f, 0.6154249f, 0.0f};
    }

    private static class LatticeVertex4D {
        public final float dx;
        public final float dy;
        public final float dz;
        public final float dw;
        public final long xsvp;
        public final long ysvp;
        public final long zsvp;
        public final long wsvp;

        public LatticeVertex4D(int xsv, int ysv, int zsv, int wsv) {
            this.xsvp = (long)xsv * 5910200641878280303L;
            this.ysvp = (long)ysv * 6452764530575939509L;
            this.zsvp = (long)zsv * 6614699811220273867L;
            this.wsvp = (long)wsv * 6254464313819354443L;
            float ssv = (float)(xsv + ysv + zsv + wsv) * -0.1381966f;
            this.dx = (float)(-xsv) - ssv;
            this.dy = (float)(-ysv) - ssv;
            this.dz = (float)(-zsv) - ssv;
            this.dw = (float)(-wsv) - ssv;
        }
    }
}

