/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.particle;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class IceShatterParticle
extends TextureSheetParticle {
    private final float uo;
    private final float vo;

    public IceShatterParticle(ClientLevel clientLevel, double xo, double yo, double zo) {
        super(clientLevel, xo, yo, zo, 0.0, 0.0, 0.0);
        this.setSprite(Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.ICE.defaultBlockState()));
        this.gravity = 1.0f;
        this.friction = 0.9f;
        this.xd *= (double)(this.random.nextFloat() * 8.0f);
        this.zd *= (double)(this.random.nextFloat() * 8.0f);
        this.yd *= (double)(this.random.nextFloat() * 8.0f);
        this.quadSize /= 5.0f;
        this.lifetime = Mth.randomBetweenInclusive((RandomSource)this.random, (int)20, (int)40);
        this.uo = this.random.nextFloat();
        this.vo = this.random.nextFloat();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f * 16.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f * 16.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f * 16.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f * 16.0f);
    }

    public int getLightColor(float f) {
        int lightAtPos = super.getLightColor(f);
        int k = lightAtPos >> 16 & 0xFF;
        return 0xF0 | k << 16;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @ParametersAreNonnullByDefault
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double xo, double yo, double zo, double dx, double dy, double dz) {
            return new IceShatterParticle(clientLevel, xo, yo, zo);
        }
    }
}

