/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.IOneUserInteractable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.IWaxable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public interface ITextHolderProvider
extends IOneUserInteractable,
IWashable,
IWaxable {
    public TextHolder getTextHolder(int var1);

    default public TextHolder getTextHolder() {
        return this.getTextHolder(0);
    }

    default public TextHolder getTextHolderAt(Vec3 hit) {
        return this.getTextHolder();
    }

    default public int textHoldersCount() {
        return 1;
    }

    default public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        if (this.isWaxed()) {
            this.setWaxed(false);
            return true;
        }
        boolean success = false;
        TextHolder text = this.getTextHolderAt(hitVec);
        if (!text.isEmpty(null)) {
            text.clear();
            success = true;
        }
        if (success) {
            ITextHolderProvider iTextHolderProvider = this;
            if (iTextHolderProvider instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)iTextHolderProvider;
                be.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
            }
            return true;
        }
        return false;
    }

    default public boolean tryAcceptingClientText(BlockPos pos, ServerPlayer player, List<List<FilteredText>> filteredText) {
        if (!this.isWaxed() && this.canBeUsedBy(pos, (Entity)player)) {
            for (int i = 0; i < filteredText.size(); ++i) {
                TextHolder holder = this.getTextHolder(i);
                holder.acceptClientMessages((Player)player, filteredText.get(i));
            }
            this.setCurrentUser(null);
            return true;
        }
        Supplementaries.LOGGER.warn("Player {} just tried to change non-editable sign", (Object)player.getName().getString());
        return false;
    }

    @Deprecated(forRemoval=true)
    default public boolean tryOpeningTextEditGui(BlockEntity be, ServerPlayer player, ItemStack stack, Direction face) {
        return this.tryOpeningTextEditGui(be, player, stack, face, Vec3.ZERO);
    }

    default public boolean tryOpeningTextEditGui(BlockEntity be, ServerPlayer player, ItemStack stack, Direction face, Vec3 hit) {
        if (this.isWaxed()) {
            return false;
        }
        boolean filtering = player.isTextFilteringEnabled();
        for (int i = 0; i < this.textHoldersCount(); ++i) {
            if (this.getTextHolder(i).hasEditableText(filtering)) continue;
            return false;
        }
        return Utils.openGuiIfPossible((BlockEntity)be, (ServerPlayer)player, (ItemStack)stack, (Direction)face, (Vec3)hit);
    }

    @Deprecated(forRemoval=true)
    default public ItemInteractionResult textHolderInteract(BlockEntity be, int index, Player player, InteractionHand hand, ItemStack stack, Direction face) {
        return this.textHolderInteract(be, index, player, hand, stack, face, Vec3.ZERO);
    }

    default public ItemInteractionResult textHolderInteract(BlockEntity be, int index, Player player, InteractionHand hand, ItemStack stack, Direction face, Vec3 hit) {
        ServerPlayer serverPlayer;
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        BlockState state = be.getBlockState();
        ItemInteractionResult result = this.getTextHolder(index).playerInteract(level, pos, player, hand, stack);
        if (result == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            result = this.tryWaxingWithItem(level, pos, player, stack);
        }
        if (result != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            ITextHolderProvider iTextHolderProvider;
            if (!level.isClientSide && (iTextHolderProvider = this) instanceof BlockEntity) {
                BlockEntity te = (BlockEntity)iTextHolderProvider;
                te.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)level.getBlockState(pos)));
            return result;
        }
        if (player instanceof ServerPlayer && this.tryOpeningTextEditGui(be, serverPlayer = (ServerPlayer)player, stack, face, hit)) {
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.SUCCESS;
    }
}

