/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl;

import net.darkhax.bookshelf.common.api.entity.villager.MerchantTier;
import net.darkhax.bookshelf.common.api.entity.villager.trades.VillagerBuys;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.bookshelf.common.impl.data.ingredient.AllOfIngredient;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CreativeModeTabAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.IngredientTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.VillagerTradeAdapter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class DebugContentProvider
implements ContentProvider {
    @Override
    public void defineBlocks(BlockRegistryAdapter registry) {
        registry.add("test_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE)));
        registry.addPlaceable("test_placeable", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK)));
    }

    @Override
    public void defineItems(GameRegistryAdapter<Item> registry) {
        registry.add("test_item", () -> new Item(new Item.Properties()));
    }

    @Override
    public void defineCreativeTabs(CreativeModeTabAdapter registry) {
        registry.add("test_tab", () -> ((Item)Items.BOOKSHELF).getDefaultInstance(), (params, output) -> {
            output.accept((ItemLike)Items.BOOKSHELF);
            BuiltInRegistries.ITEM.keySet().stream().filter(id -> id.getNamespace().equalsIgnoreCase("bookshelf")).forEach(id -> output.accept((ItemLike)BuiltInRegistries.ITEM.get(id)));
        });
    }

    @Override
    public void defineTrades(VillagerTradeAdapter registry) {
        registry.addTrade(VillagerProfession.ARMORER, MerchantTier.NOVICE, (VillagerTrades.ItemListing)new VillagerBuys(() -> new ItemCost((ItemLike)Items.BEDROCK, 1), 1, 1, 0, 0.0f));
        registry.addCommonWanderingTrade(new VillagerBuys(() -> new ItemCost((ItemLike)Items.BARRIER, 1), 1, 1, 0, 0.0f));
        registry.addRareWanderingTrade(new VillagerBuys(() -> new ItemCost((ItemLike)Items.STRUCTURE_VOID, 1), 1, 1, 0, 0.0f));
    }

    @Override
    public void defineIngredientTypes(IngredientTypeAdapter registry) {
        registry.add("test_all", AllOfIngredient.CODEC, AllOfIngredient.STREAM);
    }

    @Override
    public String namespace() {
        return "bookshelf";
    }

    @Override
    public boolean canLoad() {
        boolean canLoad = Services.PLATFORM.isDevelopmentEnvironment();
        if (canLoad) {
            Constants.LOG.warn("Developer mode is enabled! Bookshelf will load its debug content!");
            Constants.LOG.warn("Bookshelf's debug content will affect the gameplay experience!");
            Constants.LOG.warn("If you are not in a development environment you really should disable developer mode!");
            Constants.LOG.warn("If you are a developer you can ignore this message.");
        }
        return canLoad;
    }
}

