/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.menu;

import com.leclowndu93150.potion_blending.block.ModMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class PotionBlendingStandMenu
extends AbstractContainerMenu {
    private static final int SLOT_INPUT_1 = 0;
    private static final int SLOT_INPUT_2 = 1;
    private static final int SLOT_INPUT_3 = 2;
    private static final int SLOT_FUEL = 3;
    private static final int SLOT_OUTPUT = 4;
    private final Container container;
    private final ContainerData data;

    public PotionBlendingStandMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(2));
    }

    public PotionBlendingStandMenu(int containerId, Inventory playerInventory, Container container, ContainerData data) {
        super(ModMenuTypes.POTION_BLENDING_STAND.get(), containerId);
        PotionBlendingStandMenu.checkContainerSize((Container)container, (int)5);
        PotionBlendingStandMenu.checkContainerDataCount((ContainerData)data, (int)2);
        this.container = container;
        this.data = data;
        container.startOpen(playerInventory.player);
        this.addSlot(new PotionSlot(container, 0, 56, 17));
        this.addSlot(new PotionSlot(container, 1, 79, 10));
        this.addSlot(new PotionSlot(container, 2, 102, 17));
        this.addSlot(new FuelSlot(container, 3, 17, 37));
        this.addSlot(new OutputSlot(container, 4, 79, 58));
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 8 + l * 18, 142));
        }
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index == 4) {
                if (!this.moveItemStackTo(slotStack, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (index >= 5 && index < 41 ? (this.isPotion(slotStack) ? !this.moveItemStackTo(slotStack, 0, 3, false) : (slotStack.is(Items.BLAZE_POWDER) ? !this.moveItemStackTo(slotStack, 3, 4, false) : (index >= 5 && index < 32 ? !this.moveItemStackTo(slotStack, 32, 41, false) : index >= 32 && index < 41 && !this.moveItemStackTo(slotStack, 5, 32, false)))) : !this.moveItemStackTo(slotStack, 5, 41, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public int getBrewTime() {
        return this.data.get(0);
    }

    public int getFuel() {
        return this.data.get(1);
    }

    private boolean isPotion(ItemStack stack) {
        return stack.is(Items.POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.LINGERING_POTION);
    }

    static class PotionSlot
    extends Slot {
        public PotionSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is(Items.POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.LINGERING_POTION);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }

    static class FuelSlot
    extends Slot {
        public FuelSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is(Items.BLAZE_POWDER);
        }

        public int getMaxStackSize() {
            return 64;
        }
    }

    static class OutputSlot
    extends Slot {
        public OutputSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }
    }
}

