/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.client.screen;

import com.leclowndu93150.potion_blending.menu.PotionBlendingStandMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PotionBlendingStandScreen
extends AbstractContainerScreen<PotionBlendingStandMenu> {
    private static final ResourceLocation FUEL_LENGTH_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/brewing_stand/fuel_length");
    private static final ResourceLocation BREW_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/brewing_stand/brew_progress");
    private static final ResourceLocation BUBBLES_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/brewing_stand/bubbles");
    private static final ResourceLocation BREWING_STAND_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"potion_blending", (String)"texture/gui/potion_blending_stand.png");
    private static final int[] BUBBLELENGTHS = new int[]{29, 24, 20, 16, 11, 6, 0};

    public PotionBlendingStandScreen(PotionBlendingStandMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String leftPart = "Potion";
        String rightPart = "Combiner";
        int slotX = 79;
        int slotWidth = 16;
        int spacing = 4;
        int leftWidth = this.font.width(leftPart);
        int rightX = slotX + slotWidth + spacing;
        int leftX = slotX - spacing - leftWidth;
        guiGraphics.drawString(this.font, leftPart, leftX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, rightPart, rightX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int brewTime;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BREWING_STAND_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int fuel = ((PotionBlendingStandMenu)this.menu).getFuel();
        int fuelHeight = Mth.clamp((int)((18 * fuel + 20 - 1) / 20), (int)0, (int)18);
        if (fuelHeight > 0) {
            guiGraphics.blitSprite(FUEL_LENGTH_SPRITE, 18, 4, 0, 0, i + 55, j + 64, fuelHeight, 4);
        }
        if ((brewTime = ((PotionBlendingStandMenu)this.menu).getBrewTime()) > 0) {
            int brewProgress = (int)(28.0f * (1.0f - (float)brewTime / 400.0f));
            if (brewProgress > 0) {
                guiGraphics.blitSprite(BREW_PROGRESS_SPRITE, 9, 28, 0, 0, i + 97, j + 35, 9, brewProgress);
            }
            if ((brewProgress = BUBBLELENGTHS[brewTime / 2 % 7]) > 0) {
                guiGraphics.blitSprite(BUBBLES_SPRITE, 12, 29, 0, 29 - brewProgress, i + 58, j + 34 + 29 - brewProgress, 12, brewProgress);
            }
        }
    }
}

