/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.block.entity;

import com.leclowndu93150.potion_blending.block.ModBlockEntities;
import com.leclowndu93150.potion_blending.menu.PotionBlendingStandMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PotionBlendingStandBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    private static final int SLOT_INPUT_1 = 0;
    private static final int SLOT_INPUT_2 = 1;
    private static final int SLOT_INPUT_3 = 2;
    private static final int SLOT_FUEL = 3;
    private static final int SLOT_OUTPUT = 4;
    private static final int NUM_SLOTS = 5;
    private static final int BREW_TIME = 400;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private int brewTime;
    private int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> PotionBlendingStandBlockEntity.this.brewTime;
                case 1 -> PotionBlendingStandBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    PotionBlendingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    PotionBlendingStandBlockEntity.this.fuel = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public PotionBlendingStandBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.POTION_BLENDING_STAND.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt("BrewTime", this.brewTime);
        tag.putInt("Fuel", this.fuel);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.brewTime = tag.getInt("BrewTime");
        this.fuel = tag.getInt("Fuel");
        if (this.level != null && this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PotionBlendingStandBlockEntity blockEntity) {
        boolean isBrewing;
        ItemStack fuelStack = (ItemStack)blockEntity.items.get(3);
        if (blockEntity.fuel <= 0 && !fuelStack.isEmpty() && fuelStack.is(Items.BLAZE_POWDER)) {
            blockEntity.fuel = 20;
            fuelStack.shrink(1);
            PotionBlendingStandBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            blockEntity.syncToClient(level, pos);
        }
        boolean canBrew = blockEntity.canBrew();
        boolean bl = isBrewing = blockEntity.brewTime > 0;
        if (isBrewing) {
            boolean justFinished;
            --blockEntity.brewTime;
            boolean bl2 = justFinished = blockEntity.brewTime == 0;
            if (justFinished && canBrew) {
                blockEntity.brew();
                PotionBlendingStandBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                blockEntity.syncToClient(level, pos);
            } else if (!canBrew) {
                blockEntity.brewTime = 0;
                PotionBlendingStandBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                blockEntity.syncToClient(level, pos);
            } else if (blockEntity.brewTime % 20 == 0) {
                blockEntity.syncToClient(level, pos);
            }
        } else if (canBrew && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = 400;
            PotionBlendingStandBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            blockEntity.syncToClient(level, pos);
        }
    }

    private boolean canBrew() {
        ItemStack input1 = (ItemStack)this.items.get(0);
        ItemStack input2 = (ItemStack)this.items.get(1);
        ItemStack input3 = (ItemStack)this.items.get(2);
        ItemStack output = (ItemStack)this.items.get(4);
        if (input1.isEmpty() && input2.isEmpty() && input3.isEmpty()) {
            return false;
        }
        int potionCount = 0;
        if (this.isPotion(input1)) {
            ++potionCount;
        }
        if (this.isPotion(input2)) {
            ++potionCount;
        }
        if (this.isPotion(input3)) {
            ++potionCount;
        }
        if (potionCount < 2) {
            return false;
        }
        if (!this.areSamePotionType(input1, input2, input3)) {
            return false;
        }
        if (!output.isEmpty() && output.getCount() >= output.getMaxStackSize()) {
            return false;
        }
        ItemStack result = this.createBlendedPotion();
        if (result.isEmpty()) {
            return false;
        }
        if (output.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result);
    }

    private void brew() {
        ItemStack result = this.createBlendedPotion();
        ItemStack output = (ItemStack)this.items.get(4);
        if (output.isEmpty()) {
            this.items.set(4, (Object)result);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
            output.grow(1);
        }
        if (this.isPotion((ItemStack)this.items.get(0))) {
            ((ItemStack)this.items.get(0)).shrink(1);
        }
        if (this.isPotion((ItemStack)this.items.get(1))) {
            ((ItemStack)this.items.get(1)).shrink(1);
        }
        if (this.isPotion((ItemStack)this.items.get(2))) {
            ((ItemStack)this.items.get(2)).shrink(1);
        }
    }

    private ItemStack createBlendedPotion() {
        int color;
        PotionContents contents;
        ItemStack input1 = (ItemStack)this.items.get(0);
        ItemStack input2 = (ItemStack)this.items.get(1);
        ItemStack input3 = (ItemStack)this.items.get(2);
        ItemStack potionType = null;
        if (this.isPotion(input1)) {
            potionType = input1;
        } else if (this.isPotion(input2)) {
            potionType = input2;
        } else if (this.isPotion(input3)) {
            potionType = input3;
        }
        if (potionType == null) {
            return ItemStack.EMPTY;
        }
        HashMap effectMap = new HashMap();
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int colorCount = 0;
        if (this.isPotion(input1) && (contents = (PotionContents)input1.get(DataComponents.POTION_CONTENTS)) != null) {
            contents.getAllEffects().forEach(effect -> this.mergeEffect(effectMap, (MobEffectInstance)effect));
            color = contents.getColor();
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        if (this.isPotion(input2) && (contents = (PotionContents)input2.get(DataComponents.POTION_CONTENTS)) != null) {
            contents.getAllEffects().forEach(effect -> this.mergeEffect(effectMap, (MobEffectInstance)effect));
            color = contents.getColor();
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        if (this.isPotion(input3) && (contents = (PotionContents)input3.get(DataComponents.POTION_CONTENTS)) != null) {
            contents.getAllEffects().forEach(effect -> this.mergeEffect(effectMap, (MobEffectInstance)effect));
            color = contents.getColor();
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        int blendedColor = -1;
        if (colorCount > 0) {
            int avgRed = totalRed / colorCount;
            int avgGreen = totalGreen / colorCount;
            int avgBlue = totalBlue / colorCount;
            blendedColor = avgRed << 16 | avgGreen << 8 | avgBlue;
        }
        ArrayList allEffects = new ArrayList(effectMap.values());
        PotionContents blendedContents = new PotionContents(Optional.empty(), blendedColor == -1 ? Optional.empty() : Optional.of(blendedColor), allEffects);
        ItemStack result = new ItemStack((ItemLike)potionType.getItem());
        result.set(DataComponents.POTION_CONTENTS, (Object)blendedContents);
        result.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.potion_blending.blended_potion"));
        return result;
    }

    private void mergeEffect(Map<Holder<MobEffect>, MobEffectInstance> effectMap, MobEffectInstance newEffect) {
        Holder effectType = newEffect.getEffect();
        if (effectMap.containsKey(effectType)) {
            MobEffectInstance existing = effectMap.get(effectType);
            int newDuration = existing.getDuration() + newEffect.getDuration();
            int maxAmplifier = Math.max(existing.getAmplifier(), newEffect.getAmplifier());
            effectMap.put((Holder<MobEffect>)effectType, new MobEffectInstance(effectType, newDuration, maxAmplifier, existing.isAmbient(), existing.isVisible(), existing.showIcon()));
        } else {
            effectMap.put((Holder<MobEffect>)effectType, new MobEffectInstance(newEffect));
        }
    }

    private boolean isPotion(ItemStack stack) {
        return stack.has(DataComponents.POTION_CONTENTS);
    }

    private boolean areSamePotionType(ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        ItemStack firstPotion = null;
        if (this.isPotion(stack1)) {
            firstPotion = stack1;
        } else if (this.isPotion(stack2)) {
            firstPotion = stack2;
        } else if (this.isPotion(stack3)) {
            firstPotion = stack3;
        }
        if (firstPotion == null) {
            return false;
        }
        if (this.isPotion(stack1) && !stack1.is(firstPotion.getItem())) {
            return false;
        }
        if (this.isPotion(stack2) && !stack2.is(firstPotion.getItem())) {
            return false;
        }
        return !this.isPotion(stack3) || stack3.is(firstPotion.getItem());
    }

    public void dropContents(Level level, BlockPos pos) {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
    }

    public int getContainerSize() {
        return 5;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
            this.setChanged();
            if (this.level != null) {
                if (!this.level.isClientSide) {
                    this.syncToClient(this.level, this.worldPosition);
                } else {
                    this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
                }
            }
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.items.clear();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.potion_blending.potion_blending_stand");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new PotionBlendingStandMenu(containerId, playerInventory, this, this.dataAccess);
    }

    public boolean isBrewing() {
        return this.brewTime > 0;
    }

    public int getPotionCount() {
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.isPotion((ItemStack)this.items.get(i))) continue;
            ++count;
        }
        return count;
    }

    public int getMixedColor() {
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int colorCount = 0;
        for (int i = 0; i < 3; ++i) {
            PotionContents contents;
            ItemStack stack = (ItemStack)this.items.get(i);
            if (!this.isPotion(stack) || (contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS)) == null) continue;
            int color = contents.getColor();
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        if (colorCount == 0) {
            return -1;
        }
        int avgRed = totalRed / colorCount;
        int avgGreen = totalGreen / colorCount;
        int avgBlue = totalBlue / colorCount;
        return avgRed << 16 | avgGreen << 8 | avgBlue;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void syncToClient(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            level.sendBlockUpdated(pos, this.getBlockState(), this.getBlockState(), 11);
        }
    }
}

