/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SpawnerRandomizingProcessor
extends StructureProcessor {
    public static final MapCodec<SpawnerRandomizingProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.mapPair((MapCodec)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("resourcelocation"), (MapCodec)ExtraCodecs.POSITIVE_INT.fieldOf("weight")).codec().listOf().fieldOf("spawner_mob_entries").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.mainSpawnerData), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE, (Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec()).optionalFieldOf("override_mobs_to_pick_from").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.overrideMobsToPickFrom), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_to_override_with_tagged_mobs").orElse((Object)Float.valueOf(0.0f)).forGetter(spawnerRandomizingProcessor -> Float.valueOf(spawnerRandomizingProcessor.chanceToOverrideWithTaggedMobs))).apply((Applicative)instance, instance.stable(SpawnerRandomizingProcessor::new)));
    public final List<Pair<EntityType<?>, Integer>> mainSpawnerData;
    public final Optional<HolderSet<EntityType<?>>> overrideMobsToPickFrom;
    public final float chanceToOverrideWithTaggedMobs;

    private SpawnerRandomizingProcessor(List<Pair<EntityType<?>, Integer>> mainSpawnerData, Optional<HolderSet<EntityType<?>>> overrideMobsToPickFrom, float chanceToOverrideWithTaggedMobs) {
        this.mainSpawnerData = mainSpawnerData;
        this.overrideMobsToPickFrom = overrideMobsToPickFrom;
        this.chanceToOverrideWithTaggedMobs = chanceToOverrideWithTaggedMobs;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (structureBlockInfoWorld.state().getBlock() instanceof SpawnerBlock) {
            CompoundTag newSpawnerData;
            if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.pos())) {
                return structureBlockInfoWorld;
            }
            BlockPos worldPos = structureBlockInfoWorld.pos();
            BlockPos randomSeeding = BlockPos.of((long)(worldPos.asLong() * (long)worldPos.getY() + (long)worldPos.getX() * (long)worldPos.getZ()));
            RandomSource randomSource = settings.getRandom(randomSeeding);
            if (this.overrideMobsToPickFrom.isPresent() && this.overrideMobsToPickFrom.get().size() > 0 && randomSource.nextFloat() < this.chanceToOverrideWithTaggedMobs) {
                newSpawnerData = this.SetMobSpawnerEntity((EntityType)this.overrideMobsToPickFrom.get().get(randomSource.nextInt(this.overrideMobsToPickFrom.get().size())).value(), structureBlockInfoWorld.nbt());
            } else if (!this.mainSpawnerData.isEmpty()) {
                newSpawnerData = this.SetMobSpawnerEntity((EntityType)GeneralUtils.getRandomEntry(this.mainSpawnerData, randomSource), structureBlockInfoWorld.nbt());
            } else {
                return structureBlockInfoWorld;
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, structureBlockInfoWorld.state(), newSpawnerData);
        }
        return structureBlockInfoWorld;
    }

    private CompoundTag SetMobSpawnerEntity(EntityType<?> entity, CompoundTag nbt) {
        if (entity != null) {
            if (nbt != null) {
                CompoundTag entityTag;
                CompoundTag spawnDataTag = nbt.getCompound("SpawnData");
                if (spawnDataTag.isEmpty()) {
                    spawnDataTag = new CompoundTag();
                    nbt.put("SpawnData", (Tag)spawnDataTag);
                }
                if ((entityTag = nbt.getCompound("entity")).isEmpty()) {
                    entityTag = new CompoundTag();
                    spawnDataTag.put("entity", (Tag)entityTag);
                }
                entityTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entity).toString());
                CompoundTag spawnEntityDataTag = new CompoundTag();
                spawnEntityDataTag.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entity).toString());
                CompoundTag spawnPotentialDataEntryTag = new CompoundTag();
                spawnPotentialDataEntryTag.put("entity", (Tag)spawnEntityDataTag);
                CompoundTag spawnPotentialEntryTag = new CompoundTag();
                spawnPotentialEntryTag.put("data", (Tag)spawnPotentialDataEntryTag);
                spawnPotentialEntryTag.put("weight", (Tag)IntTag.valueOf((int)1));
                nbt.put("SpawnPotentials", (Tag)new ListTag());
                return nbt;
            }
            CompoundTag compound = new CompoundTag();
            compound.putShort("Delay", (short)20);
            compound.putShort("MinSpawnDelay", (short)200);
            compound.putShort("MaxSpawnDelay", (short)800);
            compound.putShort("SpawnCount", (short)4);
            compound.putShort("MaxNearbyEntities", (short)6);
            compound.putShort("RequiredPlayerRange", (short)16);
            compound.putShort("SpawnRange", (short)4);
            CompoundTag spawnDataEntity = new CompoundTag();
            spawnDataEntity.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entity).toString());
            CompoundTag spawnData = new CompoundTag();
            spawnData.put("entity", (Tag)spawnDataEntity);
            compound.put("SpawnData", (Tag)spawnData);
            CompoundTag entityData = new CompoundTag();
            entityData.putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(entity).toString());
            CompoundTag spawnPotentialData = new CompoundTag();
            spawnPotentialData.put("entity", (Tag)entityData);
            CompoundTag listEntry = new CompoundTag();
            listEntry.put("data", (Tag)spawnPotentialData);
            listEntry.putInt("weight", 1);
            compound.put("SpawnPotentials", (Tag)new ListTag());
            return compound;
        }
        return nbt;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.SPAWNER_RANDOMIZING_PROCESSOR.get();
    }
}

