/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminState;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class RootminCuriosityGoal
extends Goal {
    protected final RootminEntity mob;
    protected final TargetingConditions targetConditions;
    protected boolean isCuriousNow = false;
    protected LivingEntity inspect = null;
    protected int exposingTiming = 0;
    protected int curiosityWaiting = 0;

    public RootminCuriosityGoal(RootminEntity pathfinderMob) {
        this.mob = pathfinderMob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.targetConditions = TargetingConditions.forCombat().range(this.mob.getAttributeValue(Attributes.FOLLOW_RANGE)).selector(null);
    }

    protected AABB getTargetSearchArea(double d) {
        return this.mob.getBoundingBox().inflate(d, 4.0, d);
    }

    public boolean canUse() {
        if (this.mob.getRootminPose() != RootminState.ENTITY_TO_BLOCK || this.mob.animationTimeBetweenHiding != 0) {
            return false;
        }
        if (this.mob.getTarget() != null) {
            return false;
        }
        if (this.mob.curiosityCooldown > 0) {
            return false;
        }
        if (this.mob.getUUID().getLeastSignificantBits() + (long)(this.mob.tickCount % 20) != 0L) {
            return false;
        }
        double seeRange = this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
        this.inspect = this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(LivingEntity.class, this.getTargetSearchArea(seeRange), livingEntity -> BeeArmor.getBeeThemedWearablesCount((Entity)livingEntity) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear(livingEntity).isEmpty()), this.targetConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        if (this.inspect == null) {
            return false;
        }
        return this.inspect.distanceToSqr((Entity)this.mob) <= 1024.0;
    }

    public boolean canContinueToUse() {
        return !(this.mob.isDeadOrDying() || this.inspect == null || this.inspect.isDeadOrDying() || this.isCuriousNow && this.curiosityWaiting <= 0 && this.mob.getRootminPose() != RootminState.CURIOUS || BeeArmor.getBeeThemedWearablesCount((Entity)this.inspect) <= 0 && FlowerHeadwearHelmet.getFlowerHeadwear(this.inspect).isEmpty() || this.mob.blockPosition().distManhattan((Vec3i)this.inspect.blockPosition()) >= 32);
    }

    public void start() {
        if (this.mob.getRootminPose() == RootminState.ENTITY_TO_BLOCK) {
            this.mob.exposeFromBlock();
            this.exposingTiming = 20;
        }
        this.curiosityWaiting = 0;
        this.isCuriousNow = false;
    }

    public void stop() {
        this.mob.curiosityCooldown = 600;
        this.mob.exposedTimer = 0;
        this.exposingTiming = 0;
        this.curiosityWaiting = 0;
        this.mob.setRootminPose(RootminState.NONE);
    }

    public void tick() {
        if (this.exposingTiming > 0) {
            --this.exposingTiming;
        } else if (this.curiosityWaiting > 0) {
            --this.curiosityWaiting;
            this.mob.lookAt((Entity)this.inspect, 60.0f, 30.0f);
        } else if (!this.isCuriousNow) {
            if (this.mob.distanceToSqr((Entity)this.inspect) < 25.0) {
                this.mob.getNavigation().stop();
                this.isCuriousNow = true;
                this.mob.runCurious();
                this.curiosityWaiting = 60;
            } else {
                this.mob.getNavigation().moveTo((Entity)this.inspect, 1.0);
            }
        }
    }
}

