/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.enchantments.datacomponents.ParalyzeMarker;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.mixin.entities.AbstractArrowAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.MobAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modules.LivingEntityDataModule;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.services.PlatformService;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class NeurotoxinsEnchantmentApplication {
    public static Pair<ParalyzeMarker, Integer> getNeurotoxinEnchantLevel(ItemStack stack) {
        Pair pair = EnchantmentHelper.getHighestLevel((ItemStack)stack, (DataComponentType)((DataComponentType)BzEnchantments.PARALYZE_MARKER.get()));
        return pair != null ? Pair.of((Object)((ParalyzeMarker)pair.getFirst()), (Object)Math.min((Integer)pair.getSecond(), BzGeneralConfigs.neurotoxinMaxLevel)) : null;
    }

    public static void entityHurtEvent(BzEntityAttackedEvent event) {
        Entity projectile;
        if (event.entity() == null || event.entity().level().isClientSide() || event.entity().getType().is(EntityTypeTags.UNDEAD)) {
            return;
        }
        ItemStack attackingItem = null;
        LivingEntity attacker = null;
        Entity entity = event.source().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            attacker = livingEntity = (LivingEntity)entity;
            attackingItem = attacker.getMainHandItem();
        }
        if (event.source().is(DamageTypeTags.IS_PROJECTILE) && (projectile = event.source().getDirectEntity()) instanceof AbstractArrow) {
            AbstractArrow abstractArrow = (AbstractArrow)projectile;
            attackingItem = ((AbstractArrowAccessor)abstractArrow).bumblezone$callGetPickupItem();
        }
        if (attackingItem != null && !attackingItem.isEmpty()) {
            NeurotoxinsEnchantmentApplication.applyNeurotoxins((Entity)attacker, event.entity(), attackingItem);
        }
    }

    public static boolean applyNeurotoxins(Entity attacker, LivingEntity victim, ItemStack itemStack) {
        Pair<ParalyzeMarker, Integer> enchantmentAndLevel = NeurotoxinsEnchantmentApplication.getNeurotoxinEnchantLevel(itemStack);
        if (enchantmentAndLevel == null || (Integer)enchantmentAndLevel.getSecond() <= 0) {
            return false;
        }
        if ((Integer)enchantmentAndLevel.getSecond() > 0) {
            Optional<LivingEntityDataModule> capOptional;
            if (victim.hasEffect(BzEffects.PARALYZED.holder())) {
                return false;
            }
            float applyChance = 1.0f;
            LivingEntityDataModule capability = null;
            if (attacker != null && (capOptional = PlatformService.INSTANCE.getModule(attacker, ModuleRegistry.LIVING_ENTITY_DATA)).isPresent()) {
                capability = capOptional.orElseThrow(RuntimeException::new);
                float healthModifier = Math.max(100.0f - victim.getHealth(), 10.0f) / 100.0f;
                applyChance = healthModifier * (float)((Integer)enchantmentAndLevel.getSecond()).intValue() * (float)(capability.getMissedParalysis() + 1);
            }
            if (victim.getRandom().nextFloat() < applyChance) {
                victim.addEffect(new MobEffectInstance(BzEffects.PARALYZED.holder(), Math.min(((ParalyzeMarker)enchantmentAndLevel.getFirst()).durationPerLevel() * (Integer)enchantmentAndLevel.getSecond(), BzGeneralConfigs.paralyzedMaxTickDuration), ((Integer)enchantmentAndLevel.getSecond()).intValue(), false, true, true));
                if (attacker instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)attacker;
                    if (victim instanceof Mob) {
                        Mob mob = (Mob)victim;
                        mob.setLastHurtByMob(livingAttacker);
                        ((MobAccessor)mob).bumblezone$getTargetSelector().tick();
                    }
                }
                if (itemStack.is((Item)BzItems.STINGER_SPEAR.get()) && attacker instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)attacker;
                    ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_PARALYZING_TRIGGER.get())).trigger(serverPlayer);
                    if (victim.getHealth() > 70.0f) {
                        ((GenericTrigger)((Object)BzCriterias.STINGER_SPEAR_PARALYZE_BOSS_TRIGGER.get())).trigger(serverPlayer);
                    }
                }
                if (capability != null) {
                    capability.setMissedParalysis(0);
                }
                return true;
            }
            if (capability != null) {
                capability.setMissedParalysis(capability.getMissedParalysis() + 1);
            }
        }
        return false;
    }
}

