/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.telepathicgrunt.the_bumblezone.client.rendering.honeycrystalshard.HoneyCrystalShardModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.HoneyCrystalShardEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class HoneyCrystalShardRenderer
extends EntityRenderer<HoneyCrystalShardEntity> {
    public static final ResourceLocation HONEY_CRYSTAL_SHARD_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/honey_crystal_shard.png");
    private final HoneyCrystalShardModel model;

    public HoneyCrystalShardRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new HoneyCrystalShardModel(context.bakeLayer(HoneyCrystalShardModel.LAYER_LOCATION));
    }

    public void render(HoneyCrystalShardEntity honeyCrystalShardEntity, float float1, float float2, PoseStack poseStack, MultiBufferSource multiBufferSource, int int1) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)float2, (float)honeyCrystalShardEntity.yRotO, (float)honeyCrystalShardEntity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)float2, (float)honeyCrystalShardEntity.xRotO, (float)honeyCrystalShardEntity.getXRot()) + 90.0f));
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)this.model.renderType(this.getTextureLocation(honeyCrystalShardEntity)), (boolean)false, (boolean)false);
        this.model.renderToBuffer(poseStack, vertexconsumer, int1, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)honeyCrystalShardEntity, float1, float2, poseStack, multiBufferSource, int1);
    }

    public ResourceLocation getTextureLocation(HoneyCrystalShardEntity honeyCrystalShardEntity) {
        return HONEY_CRYSTAL_SHARD_LOCATION;
    }
}

