/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class FlowerHeadwearModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation FLOWER_HEADWEAR_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"flower_headwear"), "flower_headwear");
    protected final EquipmentSlot slot;
    public LivingEntity entityLiving;

    public FlowerHeadwearModel(ModelPart part, EquipmentSlot slot, LivingEntity livingEntity) {
        super(part);
        this.slot = slot;
        this.entityLiving = livingEntity;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int light, int overlay, int packedColor) {
        this.setAllVisible(false);
        if (this.slot == EquipmentSlot.HEAD && this.entityLiving != null) {
            int blue;
            int green;
            int red;
            this.head.visible = true;
            this.hat.visible = true;
            ItemStack stack = this.entityLiving.getItemBySlot(this.slot);
            if (stack.getItem() instanceof FlowerHeadwearHelmet) {
                int color = DyedItemColor.getOrDefault((ItemStack)stack, (int)-1682375);
                red = GeneralUtils.getRed(color);
                green = GeneralUtils.getGreen(color);
                blue = GeneralUtils.getBlue(color);
            } else {
                red = GeneralUtils.getRed(-1682375);
                green = GeneralUtils.getGreen(-1682375);
                blue = GeneralUtils.getBlue(-1682375);
            }
            this.head.render(poseStack, buffer, light, overlay, FastColor.ARGB32.color((int)255, (int)red, (int)green, (int)blue));
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition armorHead = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -11.75f, -3.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(3.0f, -9.25f, -3.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(3.0f, -3.75f, -3.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.5f, -1.75f, -3.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-8.0f, -9.25f, -3.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-8.0f, -3.75f, -3.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition armorBody = partdefinition.addOrReplaceChild("armorBody", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.25f, (float)0.0f));
        PartDefinition armorRightArm = partdefinition.addOrReplaceChild("armorRightArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorLeftArm = partdefinition.addOrReplaceChild("armorLeftArm", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_boot = partdefinition.addOrReplaceChild("right_boot", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_boot = partdefinition.addOrReplaceChild("left_boot", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }
}

