/*
 * Decompiled with CFR 0.152.
 */
package com.memorysettings;

import com.memorysettings.MemorysettingsMod;
import com.memorysettings.config.CommonConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.common.NeoForge;

public class MemoryErrorScreen
extends Screen {
    private final Component message;
    private Button button_proceed = null;
    private Button button_howto = null;
    private Button button_noremind = null;

    public MemoryErrorScreen(Component message) {
        super((Component)Component.empty());
        this.message = message;
        MemorysettingsMod.didDisplay = true;
    }

    protected void init() {
        super.init();
        this.button_proceed = Button.builder((Component)CommonComponents.GUI_PROCEED, button -> {
            NeoForge.EVENT_BUS.start();
            this.minecraft.setScreen((Screen)null);
        }).bounds(this.width / 2 - 100, 140, 200, 20).build();
        this.button_howto = Button.builder((Component)Component.translatable((String)"button.howto"), button -> {
            this.minecraft.keyboardHandler.setClipboard(((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).howtolink);
            try {
                Util.getPlatform().openUri(new URI(((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).howtolink));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }).bounds(this.width / 2 - 100, 120, 200, 20).build();
        this.button_noremind = Button.builder((Component)Component.translatable((String)"button.stopremind"), button -> {
            NeoForge.EVENT_BUS.start();
            this.minecraft.setScreen((Screen)null);
            ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).disableWarnings = true;
            CommonConfiguration.config.save();
        }).bounds(this.width / 2 - 100, 160, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_howto);
        this.addRenderableWidget((GuiEventListener)this.button_proceed);
        this.addRenderableWidget((GuiEventListener)this.button_noremind);
    }

    public void render(GuiGraphics graphics, int x, int y, float z) {
        int yOffset = 20;
        for (FormattedCharSequence component : this.font.split((FormattedText)this.message, 220)) {
            graphics.drawCenteredString(this.font, component, this.width / 2, yOffset, 0xFFFFFF);
            yOffset += 10;
        }
        graphics.fillGradient(0, 0, this.width, this.height, -12574688, -11530224);
        this.button_proceed.setY(20 + yOffset);
        this.button_howto.setY(40 + yOffset);
        this.button_noremind.setY(60 + yOffset);
        super.render(graphics, x, y, z);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }
}

