/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.level.block.entity;

import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.inventory.DuctMenu;
import fuzs.hoppergadgetry.world.level.block.DuctBlock;
import fuzs.hoppergadgetry.world.level.block.entity.NonHopperBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class DuctBlockEntity
extends NonHopperBlockEntity
implements TickingBlockEntity {
    public static final Component COMPONENT_DUCT = Component.translatable((String)"container.duct");

    public DuctBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        this.setItems(NonNullList.withSize((int)1, (Object)ItemStack.EMPTY));
    }

    @Override
    protected EnumProperty<Direction> getFacingProperty() {
        return DuctBlock.FACING;
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.DUCT_BLOCK_ENTITY_TYPE.value();
    }

    protected Component getDefaultName() {
        return COMPONENT_DUCT;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new DuctMenu(containerId, inventory, (Container)this);
    }

    public void serverTick() {
        DuctBlockEntity.pushItemsTick(this.getLevel(), this.getBlockPos(), this.getBlockState(), this);
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, HopperBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.getGameTime();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            DuctBlockEntity.tryMoveItems(level, pos, state, blockEntity);
        }
    }

    public static boolean tryMoveItems(Level level, BlockPos pos, BlockState state, HopperBlockEntity blockEntity) {
        if (!blockEntity.isOnCooldown() && ((Boolean)state.getValue((Property)HopperBlock.ENABLED)).booleanValue()) {
            boolean bl = false;
            if (!blockEntity.isEmpty()) {
                bl = DuctBlockEntity.ejectItems(level, pos, state, (Container)blockEntity);
            }
            if (bl) {
                blockEntity.setCooldown(8);
                DuctBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    private static boolean ejectItems(Level level, BlockPos pos, BlockState state, Container sourceContainer) {
        Container container = DuctBlockEntity.getAttachedContainer(level, pos, state);
        if (container == null) {
            return false;
        }
        Direction direction = ((Direction)state.getValue((Property)DuctBlock.FACING)).getOpposite();
        if (DuctBlockEntity.isFullContainer((Container)container, (Direction)direction)) {
            return false;
        }
        for (int i = 0; i < sourceContainer.getContainerSize(); ++i) {
            if (sourceContainer.getItem(i).isEmpty()) continue;
            ItemStack itemStack = sourceContainer.getItem(i).copy();
            ItemStack itemStack2 = DuctBlockEntity.addItem((Container)sourceContainer, (Container)container, (ItemStack)sourceContainer.removeItem(i, 1), (Direction)direction);
            if (itemStack2.isEmpty()) {
                container.setChanged();
                return true;
            }
            sourceContainer.setItem(i, itemStack);
        }
        return false;
    }

    @Nullable
    private static Container getAttachedContainer(Level level, BlockPos blockPos, BlockState blockState) {
        Direction direction = (Direction)blockState.getValue((Property)DuctBlock.FACING);
        return DuctBlockEntity.getContainerAt((Level)level, (BlockPos)blockPos.relative(direction));
    }
}

