/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hoppergadgetry.world.entity.vehicle;

import fuzs.hoppergadgetry.init.ModRegistry;
import fuzs.hoppergadgetry.world.inventory.GratedHopperMenu;
import fuzs.hoppergadgetry.world.level.block.entity.GratedHopperBlockEntity;
import fuzs.puzzleslib.api.container.v1.ContainerMenuHelper;
import fuzs.puzzleslib.api.container.v1.ContainerSerializationHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MinecartGratedHopper
extends MinecartHopper {
    private final NonNullList<ItemStack> filterItems = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);

    public MinecartGratedHopper(Level level, double x, double y, double z) {
        this((EntityType<? extends MinecartHopper>)((EntityType)ModRegistry.GRATED_HOPPER_MINECART_ENTITY_TYPE.value()), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public MinecartGratedHopper(EntityType<? extends MinecartHopper> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractMinecart.Type getMinecartType() {
        return ModRegistry.GRATED_HOPPER_MINECART_TYPE;
    }

    public BlockState getDefaultDisplayBlockState() {
        return ((Block)ModRegistry.GRATED_HOPPER_BLOCK.value()).defaultBlockState();
    }

    public boolean suckInItems() {
        if (GratedHopperBlockEntity.suckInItems(this.level(), (Hopper)this)) {
            return true;
        }
        for (ItemEntity itemEntity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(0.25, 0.0, 0.25), EntitySelector.ENTITY_STILL_ALIVE)) {
            ItemStack itemStack = itemEntity.getItem();
            if (!this.canPlaceItem(0, itemStack) || !HopperBlockEntity.addItem((Container)this, (ItemEntity)itemEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        return GratedHopperBlockEntity.canPlaceItem(itemStack, this.filterItems);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ContainerSerializationHelper.saveAllItems((String)GratedHopperBlockEntity.TAG_FILTER, (CompoundTag)compound, this.filterItems, (HolderLookup.Provider)this.registryAccess());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.filterItems.clear();
        ContainerSerializationHelper.loadAllItems((String)GratedHopperBlockEntity.TAG_FILTER, (CompoundTag)compound, this.filterItems, (HolderLookup.Provider)this.registryAccess());
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory) {
        return new GratedHopperMenu(containerId, playerInventory, (Container)this, (Container)ContainerMenuHelper.createListBackedContainer(this.filterItems, (Container)this));
    }

    protected Item getDropItem() {
        return (Item)ModRegistry.GRATED_HOPPER_MINECART_ITEM.value();
    }

    public ItemStack getPickResult() {
        return ((Item)ModRegistry.GRATED_HOPPER_MINECART_ITEM.value()).getDefaultInstance();
    }
}

