/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import plus.dragons.visuality.data.VisualityCodecs;

public record ParticleWithVelocity(ParticleOptions options, Vec3 velocity) {
    public static final Codec<ParticleWithVelocity> CODEC = Codec.of(ParticleWithVelocity::encode, ParticleWithVelocity::decode);

    public static ParticleWithVelocity ofZeroVelocity(ParticleOptions particle) {
        return new ParticleWithVelocity(particle, Vec3.ZERO);
    }

    public boolean isZeroVelocity() {
        return Mth.equal((double)this.velocity.x, (double)0.0) && Mth.equal((double)this.velocity.y, (double)0.0) && Mth.equal((double)this.velocity.z, (double)0.0);
    }

    public void spawn(Level level, double x, double y, double z) {
        level.addParticle(this.options, x, y, z, this.velocity.x, this.velocity.y, this.velocity.z);
    }

    public static <T> DataResult<Pair<ParticleWithVelocity, T>> decode(DynamicOps<T> ops, T input) {
        Dynamic dynamic = new Dynamic(ops, input);
        DataResult result = dynamic.getElement("particle").flatMap(t -> VisualityCodecs.PARTICLE_OPTIONS.parse(ops, t)).apply2(ParticleWithVelocity::new, dynamic.getElement("velocity").flatMap(t -> Vec3.CODEC.parse(ops, t)));
        if (result.error().isEmpty()) {
            return result.map(pwv -> Pair.of((Object)pwv, (Object)input));
        }
        return VisualityCodecs.PARTICLE_OPTIONS.parse(dynamic).map(ParticleWithVelocity::ofZeroVelocity).map(pwv -> Pair.of((Object)pwv, (Object)input));
    }

    public static <T> DataResult<T> encode(ParticleWithVelocity input, DynamicOps<T> ops, T prefix) {
        return input.isZeroVelocity() ? VisualityCodecs.PARTICLE_OPTIONS.encode((Object)input.options, ops, prefix) : ops.mapBuilder().add("particle", VisualityCodecs.PARTICLE_OPTIONS.encodeStart(ops, (Object)input.options)).add("velocity", Vec3.CODEC.encodeStart(ops, (Object)input.velocity)).build(prefix);
    }
}

