/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking;

import einstein.subtle_effects.data.SparkProviderData;
import einstein.subtle_effects.data.SparkProviderReloadListener;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SparkProviderManager {
    public static void tick(Level level, RandomSource random, Block block, BlockState state, BlockPos pos) {
        List<SparkProviderReloadListener.SparkProvider> providers = SparkProviderReloadListener.PROVIDERS.get(block);
        if (providers != null && !providers.isEmpty()) {
            providers.forEach(provider -> {
                SparkProviderReloadListener.BlockStateHolder stateHolder = provider.stateHolder();
                if (!stateHolder.matches(state)) {
                    return;
                }
                SparkProviderData.Options options = provider.options();
                SparkProviderData.PresetType preset = options.preset();
                List<Integer> colors = options.colors().orElse(SparkParticle.DEFAULT_COLORS);
                switch (preset) {
                    case CAMPFIRE: {
                        if (!ModConfigs.BLOCKS.sparks.campfireSparks) break;
                        ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.LONG_LIFE, new Box(0.3, 0.4, 0.3, 0.6, 0.4, 0.6), new Vec3(0.03, 0.05, 0.03), 10, colors);
                        break;
                    }
                    case TORCH: {
                        if (!ModConfigs.BLOCKS.sparks.torchSparks) break;
                        ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.SHORT_LIFE, new Box(0.3, 0.5, 0.3, 0.6, 0.5, 0.6), new Vec3(0.01, 0.01, 0.01), 2, colors);
                        break;
                    }
                    case WALL_TORCH: {
                        if (!ModConfigs.BLOCKS.sparks.torchSparks || !state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                            return;
                        }
                        Direction direction = ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
                        Vec3 offset2 = new Vec3(0.5 + 0.27 * (double)direction.getStepX(), 0.7, 0.5 + 0.27 * (double)direction.getStepZ());
                        ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.SHORT_LIFE, new Box(offset2.subtract(0.05, 0.0, 0.05), offset2.add(0.05, 0.0, 0.05)), new Vec3(0.01, 0.01, 0.01), 2, colors);
                        break;
                    }
                    case CANDLE: {
                        if (!ModConfigs.BLOCKS.sparks.candleSparks || !(block instanceof AbstractCandleBlock)) break;
                        AbstractCandleBlock candleBlock = (AbstractCandleBlock)block;
                        candleBlock.getParticleOffsets(state).forEach(offset -> ParticleSpawnUtil.spawnSparks(level, random, pos, SparkType.SHORT_LIFE, new Box(offset.subtract(0.05, 0.0, 0.05), offset.add(0.05, 0.0, 0.05)), new Vec3(0.01, 0.01, 0.01), 2, colors));
                        break;
                    }
                    case LANTERN: {
                        for (int i = 0; i < (Integer)ModConfigs.BLOCKS.sparks.lanternSparksDensity.get(); ++i) {
                            int xSign = MathUtil.nextSign(random);
                            int zSign = MathUtil.nextSign(random);
                            level.addParticle((ParticleOptions)SparkParticle.create(SparkType.FLOATING, random, colors), (double)pos.getX() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, (double)pos.getY() + (double)random.nextInt(5) / 10.0, (double)pos.getZ() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)zSign, MathUtil.nextDouble(random, 0.03) * (double)xSign, 0.0, MathUtil.nextDouble(random, 0.03) * (double)zSign);
                        }
                        break;
                    }
                    case FIRE: {
                        if (!ModConfigs.BLOCKS.sparks.fireSparks || !(block instanceof BaseFireBlock)) break;
                        BaseFireBlock fireBlock = (BaseFireBlock)block;
                        BlockPos belowPos = pos.below();
                        BlockState belowState = level.getBlockState(belowPos);
                        if (!fireBlock.canBurn(belowState) && !belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP)) {
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                if (!fireBlock.canBurn(level.getBlockState(pos.relative(direction)))) continue;
                                Direction.Axis axis = direction.getAxis();
                                boolean i = direction.getAxisDirection() != Direction.AxisDirection.NEGATIVE;
                                SparkProviderManager.spawnFireSparks(level, random, pos, colors, axis == Direction.Axis.X ? (double)i : random.nextDouble(), axis == Direction.Axis.Z ? random.nextDouble() : (double)i);
                            }
                            return;
                        }
                        SparkProviderManager.spawnFireSparks(level, random, pos, colors, random.nextDouble(), random.nextDouble());
                        break;
                    }
                    case FURNACE: {
                        if (!ModConfigs.BLOCKS.sparks.furnaceSparks || !state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                            return;
                        }
                        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                        Direction.Axis axis = direction.getAxis();
                        for (int i = 0; i < 3; ++i) {
                            level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random, colors), (double)pos.getX() + 0.5 + 0.6 * (double)direction.getStepX() + random.nextDouble() / (double)(axis == Direction.Axis.X ? 10 : 3) * (double)MathUtil.nextSign(random), (double)pos.getY() + random.nextDouble() * 6.0 / 16.0, (double)pos.getZ() + 0.5 + 0.6 * (double)direction.getStepZ() + random.nextDouble() / (double)(axis == Direction.Axis.Z ? 10 : 3) * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                        }
                        break;
                    }
                    case CUSTOM: {
                        Box box = options.box().orElse(new Box());
                        SparkType sparkType = options.sparkType().orElse(SparkType.SHORT_LIFE);
                        Vec3 velocity = options.velocity().orElse(new Vec3(0.03, 0.05, 0.03));
                        IntProvider count = options.count().orElse((IntProvider)ConstantInt.of((int)10));
                        float chance = options.chance().orElse(Float.valueOf(1.0f)).floatValue();
                        if (!(random.nextFloat() <= chance)) break;
                        ParticleSpawnUtil.spawnSparks(level, random, pos, sparkType, box, velocity, count.sample(random), colors);
                    }
                }
            });
        }
    }

    private static void spawnFireSparks(Level level, RandomSource random, BlockPos pos, List<Integer> colors, double xOffset, double zOffset) {
        for (int i = 0; i < 5; ++i) {
            level.addParticle((ParticleOptions)SparkParticle.create(SparkType.LONG_LIFE, random, colors), (double)pos.getX() + xOffset + random.nextDouble() / 10.0 * (double)MathUtil.nextSign(random), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + zOffset + random.nextDouble() / 10.0 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.03), MathUtil.nextNonAbsDouble(random, 0.05), MathUtil.nextNonAbsDouble(random, 0.03));
        }
    }
}

