/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.client.model.particle.SplashParticleModel;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.particle.ModelParticle;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class SplashParticle
extends ModelParticle {
    private final boolean glowing;
    private final TagKey<Fluid> fluidTag;
    private final SpriteSet sprites;
    @Nullable
    private final SpriteSet overlaySprites;
    private final boolean hasOverlay;
    private final BlockPos.MutableBlockPos pos;
    private float xScale;
    private final float yScale;
    private ResourceLocation texture;
    private ResourceLocation overlayTexture;
    private float overlayRCol = 1.0f;
    private float overlayGCol = 1.0f;
    private float overlayBCol = 1.0f;
    private final SplashParticleModel model = this.bakeModel(SplashParticleModel::new, SplashParticleModel.MODEL_LAYER);

    protected SplashParticle(ClientLevel level, double x, double y, double z, boolean glowing, TagKey<Fluid> fluidTag, SpriteSet sprites, @Nullable SpriteSet overlaySprites, SplashParticleOptions options) {
        super(level, x, y, z);
        this.glowing = glowing;
        this.fluidTag = fluidTag;
        this.sprites = sprites;
        this.overlaySprites = overlaySprites;
        this.pos = BlockPos.containing((double)x, (double)y, (double)z).mutable();
        this.hasOverlay = overlaySprites != null && ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() > 0.0f;
        this.lifetime = 15;
        this.xScale = options.xScale();
        this.yScale = options.yScale();
        this.setSize(this.xScale, this.yScale);
        this.setSpriteFromAge();
    }

    protected int getLightColor(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.getLightColor(partialTick);
    }

    public void tick() {
        this.pos.set(this.x, this.y, this.z);
        if (!this.level.getFluidState((BlockPos)this.pos).is(this.fluidTag) && !Util.getCauldronFluid(this.level.getBlockState((BlockPos)this.pos)).is(this.fluidTag)) {
            this.remove();
            return;
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.xScale += 0.01333f;
        this.setSpriteFromAge();
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer consumer, MultiBufferSource.BufferSource bufferSource, Camera camera, float partialTicks) {
        int lightColor = this.getLightColor(partialTicks);
        int color = FastColor.ARGB32.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol);
        poseStack.translate(0.0f, -(6.0f * (this.yScale / 4.0f)), 0.0f);
        poseStack.scale(this.xScale, this.yScale, this.xScale);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(this.model.renderType(this.texture)), lightColor, OverlayTexture.NO_OVERLAY, color);
        if (this.hasOverlay) {
            int overlayColor = FastColor.ARGB32.colorFromFloat((float)((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue(), (float)this.overlayRCol, (float)this.overlayGCol, (float)this.overlayBCol);
            this.model.renderToBuffer(poseStack, bufferSource.getBuffer(this.model.renderType(this.overlayTexture)), lightColor, OverlayTexture.NO_OVERLAY, overlayColor);
        }
        bufferSource.endBatch();
    }

    private void setSpriteFromAge() {
        this.texture = this.getSpriteId(this.sprites.get(this.age, this.lifetime));
        if (this.hasOverlay) {
            this.overlayTexture = this.getSpriteId(this.overlaySprites.get(this.age, this.lifetime));
        }
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashParticle(level, x, y, z, true, (TagKey<Fluid>)FluidTags.LAVA, this.sprites, null, options);
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashParticle particle = new SplashParticle(level, x, y, z, false, (TagKey<Fluid>)FluidTags.WATER, this.sprites, (SpriteSet)ModSpriteSets.WATER_SPLASH_OVERLAY, options);
            int waterColor = ((Biome)level.getBiome(BlockPos.containing((double)x, (double)y, (double)z)).value()).getWaterColor();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.overlayRCol = whiteIntensity + colorIntensity * red;
                particle.overlayGCol = whiteIntensity + colorIntensity * green;
                particle.overlayBCol = whiteIntensity + colorIntensity * blue;
            }
            particle.setColor(red, green, blue);
            return particle;
        }
    }
}

