/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.block;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateBaseMixin {
    @WrapOperation(method={"useWithoutItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;useWithoutItem(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult use(Block block, BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult, Operation<InteractionResult> original) {
        if (level.isClientSide && (ModConfigs.BLOCKS.cakeEatParticles || ModConfigs.BLOCKS.cakeEatSounds)) {
            Pair<IntegerProperty, Integer> bitesData = BlockStateBaseMixin.subtleEffects$getBitesData(state);
            boolean hadBites = bitesData != null;
            int oldBites = hadBites ? (Integer)state.getValue((Property)bitesData.getFirst()) : 0;
            InteractionResult result = (InteractionResult)original.call(new Object[]{block, state, level, pos, player, hitResult});
            if (result == InteractionResult.SUCCESS) {
                BlockState newState = level.getBlockState(pos);
                int maxBites = 0;
                int bites = 0;
                if (hadBites) {
                    maxBites = (Integer)bitesData.getSecond();
                    bites = newState.hasProperty((Property)bitesData.getFirst()) ? (Integer)newState.getValue((Property)bitesData.getFirst()) : oldBites + 1;
                } else {
                    bitesData = BlockStateBaseMixin.subtleEffects$getBitesData(newState);
                    if (bitesData != null) {
                        bites = (Integer)newState.getValue((Property)bitesData.getFirst());
                        maxBites = (Integer)bitesData.getSecond();
                    }
                }
                if (bites > oldBites) {
                    ItemStack stack = block.getCloneItemStack((LevelReader)level, pos, state);
                    RandomSource random = player.getRandom();
                    if (!stack.isEmpty() && ModConfigs.BLOCKS.cakeEatParticles) {
                        float partialTick = Util.getPartialTicks();
                        ItemParticleOption options = new ItemParticleOption(ParticleTypes.ITEM, stack);
                        for (int i = 0; i < 16; ++i) {
                            ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)options, (LivingEntity)player, level, random, Vec3.ZERO, partialTick);
                        }
                    }
                    if (ModConfigs.BLOCKS.cakeEatSounds) {
                        SoundSource soundSource = player.getSoundSource();
                        if (bites == maxBites) {
                            Util.playClientSound((Entity)player, SoundEvents.PLAYER_BURP, soundSource, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                        }
                        if (!((IntegerProperty)bitesData.getFirst()).equals((Object)CompatHelper.FD_PIE_BITES)) {
                            Util.playClientSound((Entity)player, player.getEatingSound(stack), soundSource, 0.5f + 0.5f * (float)random.nextInt(2), (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                        }
                    }
                }
            }
            return result;
        }
        return (InteractionResult)original.call(new Object[]{block, state, level, pos, player, hitResult});
    }

    @Unique
    @Nullable
    private static Pair<IntegerProperty, Integer> subtleEffects$getBitesData(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.BITES)) {
            return Pair.of((Object)BlockStateProperties.BITES, (Object)7);
        }
        IntegerProperty pieProperty = BlockStateBaseMixin.subtleEffects$findProperty(state, CompatHelper.FD_PIE_BITES);
        if (pieProperty != null) {
            return Pair.of((Object)pieProperty, (Object)4);
        }
        IntegerProperty twoTieredCakeProperty = BlockStateBaseMixin.subtleEffects$findProperty(state, CompatHelper.JMC_TWO_TIERED_CAKE_BITES);
        if (twoTieredCakeProperty != null) {
            return Pair.of((Object)twoTieredCakeProperty, (Object)11);
        }
        IntegerProperty threeTieredCakeProperty = BlockStateBaseMixin.subtleEffects$findProperty(state, CompatHelper.JMC_THREE_TIERED_CAKE_BITES);
        if (threeTieredCakeProperty != null) {
            return Pair.of((Object)threeTieredCakeProperty, (Object)16);
        }
        return null;
    }

    @Unique
    private static IntegerProperty subtleEffects$findProperty(BlockState state, IntegerProperty property1) {
        return state.getProperties().stream().filter(property2 -> property2.equals((Object)property1)).findFirst().orElse(null);
    }
}

