/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import sereneseasons.api.SSItems;
import sereneseasons.item.CalendarType;

public class SSItemModelProvider
extends ItemModelProvider {
    public SSItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "sereneseasons", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem(SSItems.SS_ICON);
        this.registerCalendarModels();
    }

    private void registerCalendarModels() {
        int i;
        ItemModelBuilder calendar = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(SSItemModelProvider.location("calendar").toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        ItemModelBuilder calendarNull = this.basicItem(SSItemModelProvider.location("calendar_null"));
        ModelFile[] calendarStandard = new ModelFile[12];
        ModelFile[] calendarTropical = new ModelFile[6];
        for (i = 0; i < 12; ++i) {
            String pathIndex = String.format("%02d", i);
            calendarStandard[i] = this.basicItem(SSItemModelProvider.location("calendar_" + pathIndex));
            if (i >= 6) continue;
            calendarTropical[i] = this.basicItem(SSItemModelProvider.location("tropical_calendar_" + pathIndex));
        }
        for (i = 0; i < 12; ++i) {
            calendar.override().predicate(SSItemModelProvider.location("seasontype"), (float)CalendarType.STANDARD.ordinal()).predicate(SSItemModelProvider.location("time"), (float)i / 12.0f).model(calendarStandard[i]);
        }
        for (i = 0; i < 12; ++i) {
            calendar.override().predicate(SSItemModelProvider.location("seasontype"), (float)CalendarType.TROPICAL.ordinal()).predicate(SSItemModelProvider.location("time"), (float)i / 12.0f).model(calendarTropical[(i + 3) / 2 % 6]);
        }
        calendar.override().predicate(SSItemModelProvider.location("seasontype"), (float)CalendarType.NONE.ordinal()).predicate(SSItemModelProvider.location("time"), 0.0f).model((ModelFile)calendarNull);
    }

    private static ResourceLocation location(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)name);
    }
}

