/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.resource;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class LanguageUtils {
    public static final MutableComponent VALUE_INFINITE = LanguageUtils.of("value", "infinite").get(new Object[0]);
    public static final MutableComponent VALUE_HIDDEN = LanguageUtils.of("value", "hidden").get(new Object[0]);
    public static final MutableComponent NEWLINE = Component.literal((String)"\n");
    public static final LanguageUtils UNIT_SECONDS = LanguageUtils.of("unit", "seconds");
    public static final LanguageUtils UNIT_METERS = LanguageUtils.of("unit", "meters");
    public static final LanguageUtils UNIT_PERCENT = LanguageUtils.of("unit", "percent");
    private String key;

    public static LanguageUtils settings(String key) {
        return LanguageUtils.of("settings", key);
    }

    public static LanguageUtils command(String key) {
        return LanguageUtils.of("command", key);
    }

    public static String keyOf(String category, String ... path) {
        return LanguageUtils.of(category, path).getKey();
    }

    public static LanguageUtils of(String category, String ... path) {
        return new LanguageUtils(String.join((CharSequence)".", category, "pingwheel", String.join((CharSequence)".", path)));
    }

    private LanguageUtils(String key) {
        this.key = key;
    }

    public LanguageUtils path(String ... path) {
        return new LanguageUtils(String.join((CharSequence)".", this.key, String.join((CharSequence)".", path)));
    }

    public MutableComponent get(Object ... args) {
        return Component.translatable((String)this.key, (Object[])args);
    }

    public MutableComponent wrapped() {
        return Component.empty().append((Component)Component.literal((String)"(")).append((Component)this.get(new Object[0])).append((Component)Component.literal((String)")"));
    }

    public static MutableComponent join(MutableComponent ... components) {
        MutableComponent output = Component.empty();
        for (int i = 0; i < components.length; ++i) {
            MutableComponent component = components[i];
            if (i > 0) {
                output.append((Component)NEWLINE);
            }
            output.append((Component)component);
        }
        return output;
    }

    public static MutableComponent withModPrefix(MutableComponent component) {
        return Component.empty().append((Component)Component.literal((String)"[Ping-Wheel] ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)component);
    }

    public static MutableComponent from(Object any) {
        return Component.literal((String)String.format("%s", any));
    }

    public String getKey() {
        return this.key;
    }
}

