/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.phys.Vec2;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.core.PingView;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.render.DrawContext;

public class DirectionIndicatorRenderer {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static final int WHITE = -1;
    private static Vec2 screenSize;
    private static Vec2 safeZoneTopLeft;
    private static Vec2 safeZoneBottomRight;
    private static Vec2 safeScreenCenter;

    private DirectionIndicatorRenderer() {
    }

    public static void prepareSafeZone() {
        Window wnd = CommonClient.Game.getWindow();
        screenSize = new Vec2((float)wnd.getGuiScaledWidth(), (float)wnd.getGuiScaledHeight());
        safeZoneTopLeft = new Vec2((float)CLIENT_CONFIG.getSafeZoneLeft(), (float)CLIENT_CONFIG.getSafeZoneTop());
        safeZoneBottomRight = new Vec2(DirectionIndicatorRenderer.screenSize.x - (float)CLIENT_CONFIG.getSafeZoneRight(), DirectionIndicatorRenderer.screenSize.y - (float)CLIENT_CONFIG.getSafeZoneBottom());
        safeScreenCenter = new Vec2((DirectionIndicatorRenderer.safeZoneBottomRight.x - DirectionIndicatorRenderer.safeZoneTopLeft.x) * 0.5f, (DirectionIndicatorRenderer.safeZoneBottomRight.y - DirectionIndicatorRenderer.safeZoneTopLeft.y) * 0.5f);
    }

    public static void draw(DrawContext ctx, PingView ping) {
        boolean isOffScreen;
        ScreenPos screenPos = ping.getScreenPos();
        if (screenPos == null) {
            return;
        }
        boolean behindCamera = screenPos.isBehindCamera();
        boolean bl = isOffScreen = behindCamera || !screenPos.isInBounds(Vec2.ZERO, screenSize);
        if (!isOffScreen) {
            return;
        }
        Vec2 pingDirectionVec = new Vec2(screenPos.x - DirectionIndicatorRenderer.safeZoneTopLeft.x - DirectionIndicatorRenderer.safeScreenCenter.x, screenPos.y - DirectionIndicatorRenderer.safeZoneTopLeft.y - DirectionIndicatorRenderer.safeScreenCenter.y);
        if (behindCamera) {
            pingDirectionVec = pingDirectionVec.scale(-1.0f);
        }
        PoseStack m = ctx.getMatrices();
        float pingScale = ping.getScale();
        float pingSize = (float)CLIENT_CONFIG.getPingSize() / 100.0f;
        float pingAngle = (float)Math.atan2(pingDirectionVec.y, pingDirectionVec.x);
        Vec2 edgePosition = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
        double indicatorOffsetX = Math.cos((double)pingAngle + Math.PI) * 12.0;
        double indicatorOffsetY = Math.sin((double)pingAngle + Math.PI) * 12.0;
        m.pushPose();
        m.translate(edgePosition.x, edgePosition.y, 0.0f);
        boolean useTeamColor = CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.FULL || CLIENT_CONFIG.getTeamColorMode() == TeamColorMode.PING_ONLY;
        int pingColor = useTeamColor ? ping.getTeamColor() : -1;
        m.pushPose();
        m.scale(pingScale, pingScale, 1.0f);
        m.translate(indicatorOffsetX, indicatorOffsetY, 0.0);
        ctx.renderPing(ping.getItemStack(), CLIENT_CONFIG.isItemIconVisible(), pingColor);
        m.popPose();
        m.pushPose();
        MathUtils.rotateZ(m, pingAngle);
        m.scale(pingSize, pingSize, 1.0f);
        m.scale(0.25f, 0.25f, 1.0f);
        m.translate(-5.0f, 0.0f, 0.0f);
        ctx.renderArrowIcon(pingColor);
        m.popPose();
        m.popPose();
    }
}

