/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.tool;

import com.iafenvoy.iceandfire.registry.IafToolMaterials;
import com.iafenvoy.uranus.object.RegistryHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class HippogryphSwordItem
extends SwordItem {
    public HippogryphSwordItem() {
        super((Tier)IafToolMaterials.HIPPOGRYPH_SWORD_TOOL_MATERIAL, new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)HippogryphSwordItem.createAttributes((Tier)IafToolMaterials.HIPPOGRYPH_SWORD_TOOL_MATERIAL, (int)3, (float)-2.4f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity targetEntity, LivingEntity attacker) {
        float f = (float)attacker.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
        float f3 = 1.0f + HippogryphSwordItem.getMultiplier(EnchantmentHelper.getEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)attacker.registryAccess(), (ResourceKey)Enchantments.SWEEPING_EDGE), (LivingEntity)attacker)) * f;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            for (LivingEntity LivingEntity2 : attacker.level().getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                if (LivingEntity2 == player || LivingEntity2 == targetEntity || attacker.isAlliedTo((Entity)LivingEntity2) || !(attacker.distanceToSqr((Entity)LivingEntity2) < 9.0)) continue;
                LivingEntity2.knockback((double)0.4f, (double)Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)))));
                LivingEntity2.hurt(attacker.level().damageSources().playerAttack(player), f3);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
            player.sweepAttack();
        }
        return super.hurtEnemy(stack, targetEntity, attacker);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.hippogryph_sword.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.hippogryph_sword.desc_1").withStyle(ChatFormatting.GRAY));
    }

    public static float getMultiplier(int level) {
        return 1.0f - 1.0f / (float)(level + 1);
    }
}

