/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.iafenvoy.iceandfire.data.TrollType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class TrollArmorItem
extends ArmorItem {
    private final TrollType trollType;

    public TrollArmorItem(TrollType trollType, ArmorItem.Type type) {
        Holder<ArmorMaterial> holder = trollType.getMaterial();
        Item.Properties properties = new Item.Properties();
        super(holder, type, properties.durability(switch (type) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> 220;
            case ArmorItem.Type.CHESTPLATE -> 320;
            case ArmorItem.Type.LEGGINGS -> 300;
            case ArmorItem.Type.BOOTS -> 260;
            case ArmorItem.Type.BODY -> 0;
        }));
        this.trollType = trollType;
    }

    public static String getName(TrollType trollType, ArmorItem.Type type) {
        return "%s_troll_leather_%s".formatted(trollType.getName(), type.getName());
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.trollType.getMaterial();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.%s.troll_leather_armor_%s.desc".formatted("iceandfire", this.type.getName())).withStyle(ChatFormatting.GREEN));
    }
}

