/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.entity.GorgonEntity;
import com.iafenvoy.iceandfire.entity.MultipartPartEntity;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IafEntityUtil {
    public static void updatePart(MultipartPartEntity part, LivingEntity parent) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                Level level;
                if (part == null || !((level = parent.level()) instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (!parent.isRemoved()) break block7;
            }
            return;
        }
        if (!part.shouldContinuePersisting()) {
            UUID uuid = part.getUUID();
            Entity existing = serverLevel.getEntity(uuid);
            if (existing != null && existing != part) {
                while (serverLevel.getEntity(uuid) != null) {
                    uuid = Mth.createInsecureUUID((RandomSource)parent.getRandom());
                }
                IceAndFire.LOGGER.debug("Updated the UUID of [{}] due to a clash with [{}]", (Object)part, (Object)existing);
            }
            part.setUUID(uuid);
            serverLevel.addFreshEntity((Entity)part);
        }
        part.setParent((Entity)parent);
    }

    public static boolean isEntityLookingAt(LivingEntity looker, LivingEntity seen, double degree) {
        Vec3 Vector3d = looker.getViewVector(1.0f).normalize();
        Vec3 Vector3d1 = new Vec3(seen.getX() - looker.getX(), seen.getBoundingBox().minY + (double)seen.getEyeHeight() - (looker.getY() + (double)looker.getEyeHeight()), seen.getZ() - looker.getZ());
        double d0 = Vector3d1.length();
        double d1 = Vector3d.dot(Vector3d1 = Vector3d1.normalize());
        return d1 > 1.0 - (degree *= 1.0 + (double)looker.distanceTo((Entity)seen) * 0.1) / d0 && looker.hasLineOfSight((Entity)seen) && !GorgonEntity.isStoneMob(seen);
    }
}

