/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.StymphalianBirdEntity;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class StymphalianBirdAIAirTargetGoal
extends Goal {
    private final StymphalianBirdEntity bird;

    public StymphalianBirdAIAirTargetGoal(StymphalianBirdEntity bird) {
        this.bird = bird;
    }

    public static BlockPos getNearbyAirTarget(StymphalianBirdEntity bird) {
        if (bird.getTarget() == null) {
            BlockPos pos = DragonUtils.getBlockInViewStymphalian(bird);
            if (pos != null && bird.level().getBlockState(pos).isAir()) {
                return pos;
            }
            if (bird.flock != null && bird.flock.isLeader(bird)) {
                bird.flock.setTarget(bird.airTarget);
            }
        } else {
            return BlockPos.containing((double)bird.getTarget().getBlockX(), (double)(bird.getTarget().getY() + (double)bird.getTarget().getEyeHeight()), (double)bird.getTarget().getBlockZ());
        }
        return bird.blockPosition();
    }

    public boolean canUse() {
        if (this.bird != null) {
            if (!this.bird.isFlying()) {
                return false;
            }
            if (this.bird.isBaby() || this.bird.doesWantToLand()) {
                return false;
            }
            if (this.bird.airTarget != null && this.bird.isTargetBlocked(Vec3.atCenterOf((Vec3i)this.bird.airTarget))) {
                this.bird.airTarget = null;
            }
            if (this.bird.airTarget != null) {
                return false;
            }
            Vec3 vec = this.findAirTarget();
            if (vec == null) {
                return false;
            }
            this.bird.airTarget = BlockPos.containing((Position)vec);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (!this.bird.isFlying()) {
            return false;
        }
        if (this.bird.isBaby()) {
            return false;
        }
        return this.bird.airTarget != null;
    }

    public Vec3 findAirTarget() {
        return Vec3.atCenterOf((Vec3i)StymphalianBirdAIAirTargetGoal.getNearbyAirTarget(this.bird));
    }
}

