/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.SeaSerpentEntity;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.phys.Vec3;

public class SeaSerpentAIRandomSwimmingGoal
extends RandomStrollGoal {
    public SeaSerpentAIRandomSwimmingGoal(PathfinderMob creature, double speed, int chance) {
        super(creature, speed, chance, false);
    }

    public boolean canUse() {
        if (this.mob.isVehicle() || this.mob.getTarget() != null) {
            return false;
        }
        if (!this.forceTrigger && this.mob.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        Vec3 vector3d = this.getPosition();
        if (vector3d == null) {
            return false;
        }
        this.wantedX = vector3d.x;
        this.wantedY = vector3d.y;
        this.wantedZ = vector3d.z;
        this.forceTrigger = false;
        return true;
    }

    protected Vec3 getPosition() {
        if (((SeaSerpentEntity)this.mob).jumpCooldown <= 0) {
            Vec3 vector3d = this.findSurfaceTarget(this.mob);
            if (vector3d != null) {
                return vector3d.add(0.0, 1.0, 0.0);
            }
        } else {
            BlockPos blockpos = null;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int range = 16;
            for (int i = 0; i < 15; ++i) {
                BlockPos blockpos1 = this.mob.blockPosition().offset(((Random)random).nextInt(16) - 8, ((Random)random).nextInt(16) - 8, ((Random)random).nextInt(16) - 8);
                while (this.mob.level().isEmptyBlock(blockpos1) && this.mob.level().getFluidState(blockpos1).isEmpty() && blockpos1.getY() > 1) {
                    blockpos1 = blockpos1.below();
                }
                if (!this.mob.level().getFluidState(blockpos1).is(FluidTags.WATER)) continue;
                blockpos = blockpos1;
            }
            return blockpos == null ? null : new Vec3((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
        }
        return null;
    }

    private boolean canJumpTo(BlockPos pos) {
        BlockPos blockpos = pos.offset(0, 0, 0);
        return this.mob.level().getFluidState(blockpos).is(FluidTags.WATER) && !this.mob.level().getBlockState(blockpos).blocksMotion();
    }

    private boolean isAirAbove(BlockPos pos) {
        return this.mob.level().getBlockState(pos.offset(0, 1, 0)).isAir() && this.mob.level().getBlockState(pos.offset(0, 2, 0)).isAir();
    }

    private Vec3 findSurfaceTarget(PathfinderMob creature) {
        BlockPos upPos = creature.blockPosition();
        while (creature.level().getFluidState(upPos).is(FluidTags.WATER)) {
            upPos = upPos.above();
        }
        if (this.isAirAbove(upPos.below()) && this.canJumpTo(upPos.below())) {
            return new Vec3((double)((float)upPos.getX() + 0.5f), (double)((float)upPos.getY() + 3.5f), (double)((float)upPos.getZ() + 0.5f));
        }
        return null;
    }
}

