/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.PixieEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;

public class PixieAIFollowOwnerGoal
extends Goal {
    final Level world;
    final float maxDist;
    final float minDist;
    private final PixieEntity tameable;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public PixieAIFollowOwnerGoal(PixieEntity tameableIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.tameable = tameableIn;
        this.world = tameableIn.level();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity LivingEntity2 = this.tameable.getOwner();
        if (LivingEntity2 == null) {
            return false;
        }
        if (LivingEntity2 instanceof Player && LivingEntity2.isSpectator()) {
            return false;
        }
        if (this.tameable.isPixieSitting()) {
            return false;
        }
        if (this.tameable.distanceToSqr((Entity)LivingEntity2) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = LivingEntity2;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.tameable.isPixieSitting() && this.tameable.distanceToSqr((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tameable.getPathfindingMalus(PathType.WATER);
        this.tameable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.tameable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        this.tameable.slowSpeed = false;
    }

    private boolean isEmptyBlock(BlockPos pos) {
        BlockState BlockState2 = this.world.getBlockState(pos);
        return BlockState2.isAir() || !BlockState2.canOcclude();
    }

    public void tick() {
        this.tameable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tameable.getMaxHeadXRot());
        if (!this.tameable.isPixieSitting() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.tameable.getMoveControl().setWantedPosition(this.owner.getX(), this.owner.getY() + (double)this.owner.getEyeHeight(), this.owner.getZ(), 0.25);
            this.tameable.slowSpeed = true;
            if (!this.tameable.isLeashed() && this.tameable.distanceToSqr((Entity)this.owner) >= 50.0) {
                int i = Mth.floor((double)this.owner.getX()) - 2;
                int j = Mth.floor((double)this.owner.getZ()) - 2;
                int k = Mth.floor((double)this.owner.getBoundingBox().minY);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isEmptyBlock(new BlockPos(i + l, k, j + i1)) || !this.isEmptyBlock(new BlockPos(i + l, k + 1, j + i1))) continue;
                        this.tameable.moveTo((float)(i + l) + 0.5f, (double)k + 1.5, (float)(j + i1) + 0.5f, this.tameable.getYRot(), this.tameable.getXRot());
                        return;
                    }
                }
            }
        }
    }
}

