/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class DragonAIEscortGoal
extends Goal {
    private final DragonBaseEntity dragon;
    private BlockPos previousPosition;

    public DragonAIEscortGoal(DragonBaseEntity entityIn, double movementSpeedIn) {
        this.dragon = entityIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.dragon.canMove() && this.dragon.getTarget() == null && this.dragon.getOwner() != null && this.dragon.getCommand() == 2;
    }

    public void tick() {
        if (this.dragon.getOwner() != null) {
            float maxRange;
            float dist = this.dragon.distanceTo((Entity)this.dragon.getOwner());
            if (dist > (maxRange = 2000.0f)) {
                return;
            }
            if (!(!((double)dist > this.dragon.getBoundingBox().getSize()) || (this.dragon.isFlying() || this.dragon.isHovering()) && this.dragon.isAllowedToTriggerFlight() || this.previousPosition != null && !(this.previousPosition.distSqr((Vec3i)this.dragon.getOwner().blockPosition()) > 9.0))) {
                this.dragon.getNavigation().moveTo((Entity)this.dragon.getOwner(), 1.0);
                this.previousPosition = this.dragon.getOwner().blockPosition();
            }
            if ((dist > 30.0f || this.dragon.getOwner().getY() - this.dragon.getY() > 8.0) && !this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.isAllowedToTriggerFlight()) {
                this.dragon.setHovering(true);
                this.dragon.setInSittingPose(false);
                this.dragon.setOrderedToSit(false);
                this.dragon.flyTicks = 0;
            }
        }
    }

    public boolean canContinueToUse() {
        return this.dragon.getCommand() == 2 && this.dragon.canMove() && this.dragon.getTarget() == null && this.dragon.getOwner() != null && this.dragon.getOwner().isAlive() && (this.dragon.distanceTo((Entity)this.dragon.getOwner()) > 15.0f || !this.dragon.getNavigation().isDone());
    }
}

