/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.object.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class TideTridentEntity
extends ThrownTrident {
    private static final int ADDITIONALPIERCING = 2;
    private int entitiesHit = 0;

    public TideTridentEntity(EntityType<? extends ThrownTrident> type, Level worldIn) {
        super(type, worldIn);
        this.pickupItemStack = new ItemStack((ItemLike)IafItems.TIDE_TRIDENT.get());
    }

    public TideTridentEntity(Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        this((EntityType<? extends ThrownTrident>)((EntityType)IafEntities.TIDE_TRIDENT.get()), worldIn);
        this.setPos(thrower.getX(), thrower.getEyeY() - (double)0.1f, thrower.getZ());
        this.setOwner((Entity)thrower);
        this.pickupItemStack = thrownStackIn;
        this.entityData.set(ID_LOYALTY, (Object)((byte)EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)worldIn.registryAccess(), (ResourceKey)Enchantments.LOYALTY), (ItemStack)thrownStackIn)));
        this.entityData.set(ID_FOIL, (Object)thrownStackIn.hasFoil());
        int piercingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)worldIn.registryAccess(), (ResourceKey)Enchantments.PIERCING), (ItemStack)thrownStackIn);
        this.setPierceLevel((byte)piercingLevel);
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level;
        Entity entity = result.getEntity();
        float f = 12.0f;
        Entity entity2 = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(entity2 == null ? this : entity2));
        if (entity instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)this.getPickupItemStackOrigin(), (Entity)entity, (DamageSource)damageSource, (float)f);
        }
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.level().damageSources().trident((Entity)this, (Entity)(entity1 == null ? this : entity1));
        ++this.entitiesHit;
        if (this.entitiesHit >= this.getMaxPiercing()) {
            this.dealtDamage = true;
        }
        SoundEvent soundevent = SoundEvents.TRIDENT_HIT;
        if (entity.hurt(damagesource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Level level2;
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity && (level2 = this.level()) instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)entity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity1);
            }
        }
        float f1 = 1.0f;
        if (this.level() instanceof ServerLevel && this.level().isThundering() && EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)this.level().registryAccess(), (ResourceKey)Enchantments.CHANNELING), (ItemStack)this.getPickupItemStackOrigin()) > 0) {
            BlockPos blockpos = entity.blockPosition();
            if (this.level().canSeeSky(blockpos)) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                assert (lightningboltentity != null);
                lightningboltentity.moveTo(Vec3.atCenterOf((Vec3i)blockpos));
                lightningboltentity.setCause(entity1 instanceof ServerPlayer ? (ServerPlayer)entity1 : null);
                this.level().addFreshEntity((Entity)lightningboltentity);
                soundevent = (SoundEvent)SoundEvents.TRIDENT_THUNDER.value();
                f1 = 5.0f;
            }
        }
        this.playSound(soundevent, f1, 1.0f);
    }

    private int getMaxPiercing() {
        return 2 + this.getPierceLevel();
    }
}

