/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.base.Predicate;
import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.component.ChainData;
import com.iafenvoy.iceandfire.entity.DragonEggEntity;
import com.iafenvoy.iceandfire.entity.DragonPartEntity;
import com.iafenvoy.iceandfire.entity.DreadQueenEntity;
import com.iafenvoy.iceandfire.entity.GorgonEntity;
import com.iafenvoy.iceandfire.entity.ai.DragonAIAttackMeleeGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAIEscortGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAILookIdleGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAIMateGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAIReturnToRoostGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItemsGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetNonTamedGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAIWanderGoal;
import com.iafenvoy.iceandfire.entity.ai.DragonAIWatchClosestGoal;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.entity.util.IFlyingMount;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IMultipartEntity;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.IafEntityUtil;
import com.iafenvoy.iceandfire.entity.util.ReversedBuffer;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonSize;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IDragonFlute;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonFlightManager;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonLogic;
import com.iafenvoy.iceandfire.event.IafEvents;
import com.iafenvoy.iceandfire.item.DragonArmorItem;
import com.iafenvoy.iceandfire.item.SummoningCrystalItem;
import com.iafenvoy.iceandfire.item.block.entity.DragonForgeInputBlockEntity;
import com.iafenvoy.iceandfire.item.block.util.DragonProof;
import com.iafenvoy.iceandfire.item.component.DragonSkullComponent;
import com.iafenvoy.iceandfire.network.payload.DragonSetBurnBlockS2CPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobC2SPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobS2CPayload;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafDragonColors;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.render.model.IFChainBuffer;
import com.iafenvoy.iceandfire.render.model.util.LegSolverQuadruped;
import com.iafenvoy.iceandfire.screen.handler.DragonScreenHandler;
import com.iafenvoy.iceandfire.world.DragonPosWorldData;
import com.iafenvoy.integration.IntegrationExecutor;
import com.iafenvoy.uranus.ServerHelper;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.object.EntityUtil;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IPassabilityNavigator;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathingStuckHandler;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.iafenvoy.uranus.object.item.FoodUtils;
import com.iafenvoy.uranus.util.RandomHelper;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DragonBaseEntity
extends TamableAnimal
implements ExtendedMenuProvider,
IPassabilityNavigator,
ISyncMount,
IFlyingMount,
IMultipartEntity,
IAnimatedEntity,
IDragonFlute,
IDeadMob,
IVillagerFear,
IAnimalFear,
IHasCustomizableAttributes,
ICustomSizeNavigator,
ICustomMoveController,
ContainerListener {
    public static final int FLIGHT_CHANCE_PER_TICK = 1500;
    private static final ResourceLocation ARMOR_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"armor_modifier");
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> AGE_TICKS = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FIREBREATHING = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MODEL_DEAD = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DEATH_STAGE = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> TACKLE = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> AGINGDISABLED = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DRAGON_PITCH = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> CRYSTAL_BOUND = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> CUSTOM_POSE = SynchedEntityData.defineId(DragonBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static Animation ANIMATION_FIRECHARGE;
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public static Animation ANIMATION_WINGBLAST;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_EPIC_ROAR;
    public static Animation ANIMATION_TAILWHACK;
    public final DragonType dragonType;
    public final double minimumDamage;
    public final double maximumDamage;
    public final double minimumHealth;
    public final double maximumHealth;
    public final double minimumSpeed;
    public final double maximumSpeed;
    public final double minimumArmor;
    public final double maximumArmor;
    public final float[] prevAnimationProgresses = new float[10];
    public final LegSolverQuadruped legSolver;
    public final IafDragonLogic logic;
    public final IafDragonFlightManager flightManager;
    public final boolean allowLocalMotionControl = true;
    public final boolean allowMousePitchControl = true;
    public float sitProgress;
    public float sleepProgress;
    public float hoverProgress;
    public float flyProgress;
    public float fireBreathProgress;
    public float diveProgress;
    public float prevDiveProgress;
    public float prevFireBreathProgress;
    public int fireStopTicks;
    public int flyTicks;
    public float modelDeadProgress;
    public float prevModelDeadProgress;
    public float ridingProgress;
    public float tackleProgress;
    public boolean isSwimming;
    public float prevSwimProgress;
    public float swimProgress;
    public int ticksSwiming;
    public int swimCycle;
    public boolean isDaytime;
    public int flightCycle;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    public IFChainBuffer roll_buffer;
    public IFChainBuffer pitch_buffer;
    public IFChainBuffer pitch_buffer_body;
    public ReversedBuffer turn_buffer;
    public ChainBuffer tail_buffer;
    public int spacebarTicks;
    public int walkCycle;
    public BlockPos burningTarget;
    public int burnProgress;
    public double burnParticleX;
    public double burnParticleY;
    public double burnParticleZ;
    public float prevDragonPitch;
    public IafDragonAttacks.Air airAttack;
    public IafDragonAttacks.Ground groundAttack;
    public boolean usingGroundAttack = true;
    public int hoverTicks;
    public int tacklingTicks;
    public int ticksStill;
    public int navigatorType;
    public SimpleContainer dragonInventory;
    public boolean lookingForRoostAIFlag = false;
    public int flyHovering;
    public boolean hasHadHornUse = false;
    public int blockBreakCounter;
    public int fireBreathTicks;
    protected boolean gliding = false;
    protected float glidingSpeedBonus = 0.0f;
    protected float riderWalkingExtraY = 0.0f;
    private int prevFlightCycle;
    private boolean isModelDead;
    private int animationTick;
    private Animation currentAnimation;
    private float lastScale;
    private DragonPartEntity headPart;
    private DragonPartEntity neckPart;
    private DragonPartEntity rightWingUpperPart;
    private DragonPartEntity rightWingLowerPart;
    private DragonPartEntity leftWingUpperPart;
    private DragonPartEntity leftWingLowerPart;
    private DragonPartEntity tail1Part;
    private DragonPartEntity tail2Part;
    private DragonPartEntity tail3Part;
    private DragonPartEntity tail4Part;
    private boolean isOverAir;
    private int brushedTime;

    public DragonBaseEntity(EntityType<? extends DragonBaseEntity> t, Level world, DragonType type, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(t, world);
        this.dragonType = type;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.minimumArmor = 1.0;
        this.maximumArmor = 20.0;
        ANIMATION_EAT = Animation.create((int)20);
        this.createInventory();
        if (world.isClientSide) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.pitch_buffer_body = new IFChainBuffer();
            this.turn_buffer = new ReversedBuffer();
            this.tail_buffer = new ChainBuffer();
        }
        this.legSolver = new LegSolverQuadruped(0.3f, 0.35f, 0.2f, 1.45f, 1.0f);
        this.flightManager = new IafDragonFlightManager(this);
        this.logic = this.createDragonLogic();
        this.noCulling = true;
        this.switchNavigator(0);
        this.randomizeAttacks();
        this.lastScale = 0.0f;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, (double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue())).add(Attributes.ARMOR, 4.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
    }

    public BlockPos getRestrictCenter() {
        return this.homePos == null ? super.getRestrictCenter() : this.homePos.getPosition();
    }

    public float getRestrictRadius() {
        return ((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue();
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean hasRestriction() {
        return this.hasHomePosition && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.level())) || super.hasRestriction();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new DragonAIMateGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new DragonAIReturnToRoostGoal(this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new DragonAIEscortGoal(this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new DragonAIAttackMeleeGoal(this, 1.5, false));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (java.util.function.Predicate)Ingredient.of(IafItemTags.TEMPT_DRAGON), false));
        this.goalSelector.addGoal(7, (Goal)new DragonAIWanderGoal(this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new DragonAIWatchClosestGoal((PathfinderMob)this, LivingEntity.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new DragonAILookIdleGoal(this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new DragonAITargetItemsGoal(this, 60, false, false, true));
        this.targetSelector.addGoal(5, new DragonAITargetNonTamedGoal<LivingEntity>(this, LivingEntity.class, false, (java.util.function.Predicate<LivingEntity>)((Predicate)entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.isCreative() && (Boolean)IafCommonConfig.INSTANCE.dragon.neutralToPlayer.getValue() == false;
            }
            if (this.getRandom().nextInt(100) > this.getHunger()) {
                return entity.getType() != this.getType() && DragonUtils.canHostilesTarget((Entity)entity) && DragonUtils.isAlive(entity) && this.shouldTarget((Entity)entity);
            }
            return false;
        })));
        this.targetSelector.addGoal(6, new DragonAITargetGoal<LivingEntity>(this, LivingEntity.class, true, (java.util.function.Predicate<LivingEntity>)((Predicate)entity -> entity instanceof Player ? !((Boolean)IafCommonConfig.INSTANCE.dragon.neutralToPlayer.getValue()).booleanValue() : DragonUtils.canHostilesTarget((Entity)entity) && entity.getType() != this.getType() && this.shouldTarget((Entity)entity) && DragonUtils.isAlive(entity))));
        this.targetSelector.addGoal(7, (Goal)new DragonAITargetItemsGoal(this, false));
    }

    protected abstract boolean shouldTarget(Entity var1);

    public void updateScale(float scale) {
        if (this.headPart == null || this.headPart.isRemoved()) {
            this.headPart = new DragonPartEntity(this, 1.55f, 0.0f, 0.6f, 0.5f, 0.35f, 1.5f);
            this.level().addFreshEntity((Entity)this.headPart);
        }
        this.headPart.updateScale(scale);
        if (this.neckPart == null || this.neckPart.isRemoved()) {
            this.neckPart = new DragonPartEntity(this, 0.85f, 0.0f, 0.7f, 0.5f, 0.2f, 1.0f);
            this.level().addFreshEntity((Entity)this.neckPart);
        }
        this.neckPart.updateScale(scale);
        if (this.rightWingUpperPart == null || this.rightWingUpperPart.isRemoved()) {
            this.rightWingUpperPart = new DragonPartEntity(this, 1.0f, 90.0f, 0.5f, 0.85f, 0.3f, 0.5f);
            this.level().addFreshEntity((Entity)this.rightWingUpperPart);
        }
        this.rightWingUpperPart.updateScale(scale);
        if (this.rightWingLowerPart == null || this.rightWingLowerPart.isRemoved()) {
            this.rightWingLowerPart = new DragonPartEntity(this, 1.4f, 100.0f, 0.3f, 0.85f, 0.2f, 0.5f);
            this.level().addFreshEntity((Entity)this.rightWingLowerPart);
        }
        this.rightWingLowerPart.updateScale(scale);
        if (this.leftWingUpperPart == null || this.leftWingUpperPart.isRemoved()) {
            this.leftWingUpperPart = new DragonPartEntity(this, 1.0f, -90.0f, 0.5f, 0.85f, 0.3f, 0.5f);
            this.level().addFreshEntity((Entity)this.leftWingUpperPart);
        }
        this.leftWingUpperPart.updateScale(scale);
        if (this.leftWingLowerPart == null || this.leftWingLowerPart.isRemoved()) {
            this.leftWingLowerPart = new DragonPartEntity(this, 1.4f, -100.0f, 0.3f, 0.85f, 0.2f, 0.5f);
            this.level().addFreshEntity((Entity)this.leftWingLowerPart);
        }
        this.leftWingLowerPart.updateScale(scale);
        if (this.tail1Part == null || this.tail1Part.isRemoved()) {
            this.tail1Part = new DragonPartEntity(this, -0.75f, 0.0f, 0.6f, 0.35f, 0.35f, 1.0f);
            this.level().addFreshEntity((Entity)this.tail1Part);
        }
        this.tail1Part.updateScale(scale);
        if (this.tail2Part == null || this.tail2Part.isRemoved()) {
            this.tail2Part = new DragonPartEntity(this, -1.15f, 0.0f, 0.45f, 0.35f, 0.35f, 1.0f);
            this.level().addFreshEntity((Entity)this.tail2Part);
        }
        this.tail2Part.updateScale(scale);
        if (this.tail3Part == null || this.tail3Part.isRemoved()) {
            this.tail3Part = new DragonPartEntity(this, -1.5f, 0.0f, 0.35f, 0.35f, 0.35f, 1.0f);
            this.level().addFreshEntity((Entity)this.tail3Part);
        }
        this.tail3Part.updateScale(scale);
        if (this.tail4Part == null || this.tail4Part.isRemoved()) {
            this.tail4Part = new DragonPartEntity(this, -1.95f, 0.0f, 0.25f, 0.45f, 0.3f, 1.5f);
            this.level().addFreshEntity((Entity)this.tail4Part);
        }
        this.tail4Part.updateScale(scale);
    }

    public void removeParts() {
        if (this.headPart != null) {
            this.headPart.remove(Entity.RemovalReason.DISCARDED);
            this.headPart = null;
        }
        if (this.neckPart != null) {
            this.neckPart.remove(Entity.RemovalReason.DISCARDED);
            this.neckPart = null;
        }
        if (this.rightWingUpperPart != null) {
            this.rightWingUpperPart.remove(Entity.RemovalReason.DISCARDED);
            this.rightWingUpperPart = null;
        }
        if (this.rightWingLowerPart != null) {
            this.rightWingLowerPart.remove(Entity.RemovalReason.DISCARDED);
            this.rightWingLowerPart = null;
        }
        if (this.leftWingUpperPart != null) {
            this.leftWingUpperPart.remove(Entity.RemovalReason.DISCARDED);
            this.leftWingUpperPart = null;
        }
        if (this.leftWingLowerPart != null) {
            this.leftWingLowerPart.remove(Entity.RemovalReason.DISCARDED);
            this.leftWingLowerPart = null;
        }
        if (this.tail1Part != null) {
            this.tail1Part.remove(Entity.RemovalReason.DISCARDED);
            this.tail1Part = null;
        }
        if (this.tail2Part != null) {
            this.tail2Part.remove(Entity.RemovalReason.DISCARDED);
            this.tail2Part = null;
        }
        if (this.tail3Part != null) {
            this.tail3Part.remove(Entity.RemovalReason.DISCARDED);
            this.tail3Part = null;
        }
        if (this.tail4Part != null) {
            this.tail4Part.remove(Entity.RemovalReason.DISCARDED);
            this.tail4Part = null;
        }
    }

    public void updateParts() {
        if (this.isRemoved()) {
            return;
        }
        this.headPart.copyPosition((Entity)this);
        this.neckPart.copyPosition((Entity)this);
        this.rightWingUpperPart.copyPosition((Entity)this);
        this.rightWingLowerPart.copyPosition((Entity)this);
        this.leftWingUpperPart.copyPosition((Entity)this);
        this.leftWingLowerPart.copyPosition((Entity)this);
        this.tail1Part.copyPosition((Entity)this);
        this.tail2Part.copyPosition((Entity)this);
        this.tail3Part.copyPosition((Entity)this);
        this.tail4Part.copyPosition((Entity)this);
        IafEntityUtil.updatePart(this.headPart, (LivingEntity)this);
        IafEntityUtil.updatePart(this.neckPart, (LivingEntity)this);
        IafEntityUtil.updatePart(this.rightWingUpperPart, (LivingEntity)this);
        IafEntityUtil.updatePart(this.rightWingLowerPart, (LivingEntity)this);
        IafEntityUtil.updatePart(this.leftWingUpperPart, (LivingEntity)this);
        IafEntityUtil.updatePart(this.leftWingLowerPart, (LivingEntity)this);
        IafEntityUtil.updatePart(this.tail1Part, (LivingEntity)this);
        IafEntityUtil.updatePart(this.tail2Part, (LivingEntity)this);
        IafEntityUtil.updatePart(this.tail3Part, (LivingEntity)this);
        IafEntityUtil.updatePart(this.tail4Part, (LivingEntity)this);
    }

    public void updateBurnTarget() {
        if (!(this.burningTarget == null || this.isSleeping() || this.isModelDead() || this.isBaby())) {
            DragonForgeInputBlockEntity forge;
            float maxDist = 115 * this.getDragonStage();
            BlockEntity blockEntity = this.level().getBlockEntity(this.burningTarget);
            if (blockEntity instanceof DragonForgeInputBlockEntity && (forge = (DragonForgeInputBlockEntity)blockEntity).isAssembled() && this.distanceToSqr((double)this.burningTarget.getX() + 0.5, (double)this.burningTarget.getY() + 0.5, (double)this.burningTarget.getZ() + 0.5) < (double)maxDist && this.canPositionBeSeen((double)this.burningTarget.getX() + 0.5, (double)this.burningTarget.getY() + 0.5, (double)this.burningTarget.getZ() + 0.5)) {
                this.getLookControl().setLookAt((double)this.burningTarget.getX() + 0.5, (double)this.burningTarget.getY() + 0.5, (double)this.burningTarget.getZ() + 0.5, 180.0f, 180.0f);
                this.breathFireAtPos(this.burningTarget);
                this.setBreathingFire(true);
            } else {
                if (!this.level().isClientSide) {
                    ServerHelper.sendToAll((CustomPacketPayload)new DragonSetBurnBlockS2CPayload(this.getId(), true, this.burningTarget));
                }
                this.burningTarget = null;
            }
        }
    }

    protected abstract void breathFireAtPos(BlockPos var1);

    protected PathingStuckHandler createStuckHandler() {
        return PathingStuckHandler.createStuckHandler();
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.WALKING);
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type) {
        return this.createNavigator(worldIn, type, this.createStuckHandler());
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler) {
        return this.createNavigator(worldIn, type, stuckHandler, 4.0f);
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler, float width) {
        AdvancedPathNavigate newNavigator = new AdvancedPathNavigate((Mob)this, this.level(), type, width, 4.0f);
        this.navigation = newNavigator;
        newNavigator.setCanFloat(true);
        newNavigator.getNodeEvaluator().setCanOpenDoors(true);
        return newNavigator;
    }

    public void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.moveControl = new IafDragonFlightManager.GroundMoveHelper((Mob)this);
            this.navigation = this.createNavigator(this.level(), AdvancedPathNavigate.MovementType.WALKING, this.createStuckHandler().withTeleportSteps(5));
            this.navigatorType = 0;
            this.setFlying(false);
            this.setHovering(false);
        } else if (navigatorType == 1) {
            this.moveControl = new IafDragonFlightManager.FlightMoveHelper(this);
            this.navigation = this.createNavigator(this.level(), AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 1;
        } else {
            this.moveControl = new IafDragonFlightManager.PlayerFlightMoveHelper<DragonBaseEntity>(this);
            this.navigation = this.createNavigator(this.level(), AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 2;
        }
    }

    public boolean canRide(Entity rider) {
        return true;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.breakBlocks(false);
    }

    public void checkDespawn() {
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.canDespawn.getValue()).booleanValue()) {
            super.checkDespawn();
        }
    }

    public boolean canDestroyBlock(BlockPos pos, BlockState state) {
        return state.getBlock().defaultDestroyTime() <= 100.0f;
    }

    @Override
    public boolean isMobDead() {
        return this.isModelDead();
    }

    public int getMaxHeadYRot() {
        return 30 * this.getDragonStage() / 5;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new DragonScreenHandler(syncId, (Container)this.dragonInventory, player.getInventory(), this);
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.writeInt(this.getId());
    }

    public int getAmbientSoundInterval() {
        return 90;
    }

    protected void tickDeath() {
        this.deathTime = 0;
        this.setModelDead(true);
        this.ejectPassengers();
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            this.remove(Entity.RemovalReason.KILLED);
            for (int k = 0; k < 40; ++k) {
                double d2 = this.random.nextGaussian() * 0.02;
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                if (!this.level().isClientSide) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d2, d0, d1);
            }
            this.spawnDeathParticles();
        }
    }

    protected void spawnDeathParticles() {
    }

    public void spawnBabyParticles() {
    }

    public void remove(Entity.RemovalReason reason) {
        this.removeParts();
        super.remove(reason);
    }

    public int getBaseExperienceReward() {
        return switch (this.getDragonStage()) {
            case 2 -> 20;
            case 3 -> 150;
            case 4 -> 300;
            case 5 -> 650;
            default -> 5;
        };
    }

    public boolean isNoAi() {
        return this.isModelDead() || super.isNoAi();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HUNGER, (Object)0);
        builder.define(AGE_TICKS, (Object)0);
        builder.define(GENDER, (Object)false);
        builder.define(VARIANT, (Object)IafDragonColors.RED.getName());
        builder.define(SLEEPING, (Object)false);
        builder.define(FIREBREATHING, (Object)false);
        builder.define(HOVERING, (Object)false);
        builder.define(FLYING, (Object)false);
        builder.define(DEATH_STAGE, (Object)0);
        builder.define(MODEL_DEAD, (Object)false);
        builder.define(CONTROL_STATE, (Object)0);
        builder.define(TACKLE, (Object)false);
        builder.define(AGINGDISABLED, (Object)false);
        builder.define(COMMAND, (Object)0);
        builder.define(DRAGON_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(CRYSTAL_BOUND, (Object)false);
        builder.define(CUSTOM_POSE, (Object)"");
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.entityData.get(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.entityData.get(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean isAggressive() {
        return ((Byte)this.entityData.get(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean isStriking() {
        return ((Byte)this.entityData.get(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean isDismounting() {
        return ((Byte)this.entityData.get(CONTROL_STATE) >> 4 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
        this.setStateField(1, down);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.entityData.get(CONTROL_STATE);
        if (newState) {
            this.entityData.set(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.entityData.set(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.entityData.get(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.entityData.set(CONTROL_STATE, (Object)state);
    }

    public int getCommand() {
        return (Integer)this.entityData.get(COMMAND);
    }

    public void setCommand(int command) {
        this.entityData.set(COMMAND, (Object)command);
        this.setOrderedToSit(command == 1);
    }

    public float getDragonPitch() {
        return ((Float)this.entityData.get(DRAGON_PITCH)).floatValue();
    }

    public void setDragonPitch(float pitch) {
        this.entityData.set(DRAGON_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementDragonPitch(float pitch) {
        this.entityData.set(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() + pitch));
    }

    public void decrementDragonPitch(float pitch) {
        this.entityData.set(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() - pitch));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Hunger", this.getHunger());
        compound.putInt("AgeTicks", this.getAgeInTicks());
        compound.putBoolean("Gender", this.isMale());
        compound.putString("Variant", this.getVariant());
        compound.putBoolean("Sleeping", this.isSleeping());
        compound.putBoolean("TamedDragon", this.isTame());
        compound.putBoolean("FireBreathing", this.isBreathingFire());
        compound.putBoolean("AttackDecision", this.usingGroundAttack);
        compound.putBoolean("Hovering", this.isHovering());
        compound.putBoolean("Flying", this.isFlying());
        compound.putInt("DeathStage", this.getDeathStage());
        compound.putBoolean("ModelDead", this.isModelDead());
        compound.putFloat("DeadProg", this.modelDeadProgress);
        compound.putBoolean("Tackle", this.isTackling());
        compound.putBoolean("HasHomePosition", this.hasHomePosition);
        compound.putString("CustomPose", this.getCustomPose());
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(compound);
        }
        compound.putBoolean("AgingDisabled", this.isAgingDisabled());
        compound.putInt("Command", this.getCommand());
        if (this.dragonInventory != null) {
            compound.put("Items", (Tag)ItemStack.OPTIONAL_CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.dragonInventory.getItems()).resultOrPartial(arg_0 -> ((Logger)IceAndFire.LOGGER).error(arg_0)).orElse(new ListTag()));
        }
        compound.putBoolean("CrystalBound", this.isBoundToCrystal());
        if (this.hasCustomName()) {
            compound.put("CustomName", (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getCustomName()).resultOrPartial(arg_0 -> ((Logger)IceAndFire.LOGGER).error(arg_0)).orElse(new CompoundTag()));
        }
        this.removeParts();
        this.lastScale = 0.0f;
        compound.putInt("BrushedTime", this.brushedTime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHunger(compound.getInt("Hunger"));
        this.setAgeInTicks(compound.getInt("AgeTicks"));
        this.setGender(compound.getBoolean("Gender"));
        this.setVariant(compound.getString("Variant"));
        this.setInSittingPose(compound.getBoolean("Sleeping"));
        this.setTame(compound.getBoolean("TamedDragon"), true);
        this.setBreathingFire(compound.getBoolean("FireBreathing"));
        this.usingGroundAttack = compound.getBoolean("AttackDecision");
        this.setHovering(compound.getBoolean("Hovering"));
        this.setFlying(compound.getBoolean("Flying"));
        this.setDeathStage(compound.getInt("DeathStage"));
        this.setModelDead(compound.getBoolean("ModelDead"));
        this.modelDeadProgress = compound.getFloat("DeadProg");
        this.setCustomPose(compound.getString("CustomPose"));
        this.hasHomePosition = compound.getBoolean("HasHomePosition");
        if (this.hasHomePosition && compound.getInt("HomeAreaX") != 0 && compound.getInt("HomeAreaY") != 0 && compound.getInt("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(compound, this.level());
        }
        this.setTackling(compound.getBoolean("Tackle"));
        this.setAgingDisabled(compound.getBoolean("AgingDisabled"));
        this.setCommand(compound.getInt("Command"));
        this.createInventory();
        List stacks = ItemStack.OPTIONAL_CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("Items")).resultOrPartial(arg_0 -> ((Logger)IceAndFire.LOGGER).error(arg_0)).orElse(List.of());
        for (int i = 0; i < stacks.size() && i < this.dragonInventory.getContainerSize(); ++i) {
            this.dragonInventory.setItem(i, (ItemStack)stacks.get(i));
        }
        this.setCrystalBound(compound.getBoolean("CrystalBound"));
        if (compound.contains("CustomName", 8) && !compound.getString("CustomName").startsWith("TextComponent")) {
            this.setCustomName((Component)ComponentSerialization.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("CustomName")).resultOrPartial(arg_0 -> ((Logger)IceAndFire.LOGGER).error(arg_0)).orElse(Component.empty()));
        }
        this.setConfigurableAttributes();
        this.updateAttributes();
        this.brushedTime = compound.getInt("BrushedTime");
    }

    public int getContainerSize() {
        return 5;
    }

    protected void createInventory() {
        SimpleContainer tempInventory = this.dragonInventory;
        this.dragonInventory = new SimpleContainer(this.getContainerSize());
        if (tempInventory != null) {
            tempInventory.removeListener((ContainerListener)this);
            int i = Math.min(tempInventory.getContainerSize(), this.dragonInventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = tempInventory.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.dragonInventory.setItem(j, itemstack.copy());
            }
        }
        this.dragonInventory.addListener((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.level().isClientSide) {
            this.updateAttributes();
        }
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.dragonInventory != pInventory;
    }

    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)passenger;
            if (this.getTarget() == living || !this.isTame() || this.getOwnerUUID() == null || !this.getOwnerUUID().equals(living.getUUID())) continue;
            return living;
        }
        return null;
    }

    @Override
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    public void updateAttributes() {
        double age = Math.min(this.getAgeInDays(), 125);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
        double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)Math.round(this.minimumHealth + healthStep * age));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)Math.round(this.minimumDamage + attackStep * age));
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.minimumSpeed + speedStep * age);
        double baseValue = this.minimumArmor + armorStep * (double)this.getAgeInDays();
        this.getAttribute(Attributes.ARMOR).setBaseValue(baseValue);
        if (!this.level().isClientSide) {
            this.getAttribute(Attributes.ARMOR).removeModifier(ARMOR_MODIFIER);
            this.getAttribute(Attributes.ARMOR).addPermanentModifier(new AttributeModifier(ARMOR_MODIFIER, this.calculateArmorModifier(), AttributeModifier.Operation.ADD_VALUE));
        }
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
    }

    public int getHunger() {
        return (Integer)this.entityData.get(HUNGER);
    }

    public void setHunger(int hunger) {
        this.entityData.set(HUNGER, (Object)Mth.clamp((int)hunger, (int)0, (int)100));
    }

    public String getVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    public void setVariant(String variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return Mth.clamp((int)((Integer)this.entityData.get(AGE_TICKS) / 24000), (int)0, (int)(this.isTame() ? (Integer)IafCommonConfig.INSTANCE.dragon.maxTamedDragonAge.getValue() : 128));
    }

    public void setAgeInDays(int age) {
        this.entityData.set(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.entityData.get(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.entityData.set(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.entityData.get(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.entityData.set(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.entityData.get(GENDER);
    }

    public boolean isModelDead() {
        if (this.level().isClientSide) {
            this.isModelDead = (Boolean)this.entityData.get(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public void setModelDead(boolean modeldead) {
        this.entityData.set(MODEL_DEAD, (Object)modeldead);
        if (!this.level().isClientSide) {
            this.isModelDead = modeldead;
        }
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.entityData.get(HOVERING);
    }

    public void setHovering(boolean hovering) {
        this.entityData.set(HOVERING, (Object)hovering);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
    }

    public boolean useFlyingPathFinder() {
        return this.isFlying() && this.getControllingPassenger() == null;
    }

    public void setGender(boolean male) {
        this.entityData.set(GENDER, (Object)male);
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public boolean isBlinking() {
        return this.tickCount % 50 > 43;
    }

    public boolean isBreathingFire() {
        return (Boolean)this.entityData.get(FIREBREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        this.entityData.set(FIREBREATHING, (Object)breathing);
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < 2;
    }

    public boolean isOrderedToSit() {
        return ((Byte)this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setOrderedToSit(boolean sitting) {
        byte b0 = (Byte)this.entityData.get(DATA_FLAGS_ID);
        if (sitting) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
            this.getNavigation().stop();
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void setInSittingPose(boolean sleeping) {
        this.entityData.set(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.getNavigation().stop();
        }
    }

    public String getCustomPose() {
        return (String)this.entityData.get(CUSTOM_POSE);
    }

    public void setCustomPose(String customPose) {
        this.entityData.set(CUSTOM_POSE, (Object)customPose);
        this.modelDeadProgress = 20.0f;
    }

    public void riderShootFire(Entity controller) {
    }

    private double calculateArmorModifier() {
        EquipmentSlot[] slots;
        double val = 1.0;
        for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            Item item = this.getItemBySlot(slot).getItem();
            if (!(item instanceof DragonArmorItem)) continue;
            DragonArmorItem dragonArmor = (DragonArmorItem)item;
            val += dragonArmor.type.protection();
        }
        return val;
    }

    public boolean canMove() {
        return !this.isOrderedToSit() && !this.isSleeping() && this.getControllingPassenger() == null && !this.isPassenger() && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    public boolean isFuelingForge() {
        return this.burningTarget != null && this.level().getBlockEntity(this.burningTarget) instanceof DragonForgeInputBlockEntity;
    }

    public boolean isAlive() {
        if (this.isModelDead()) {
            return !this.isRemoved();
        }
        return super.isAlive();
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == IafItems.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, vec, hand);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        int lastDeathStage = Math.min(this.getAgeInDays() / 5, 25);
        if (stack == ItemStack.EMPTY) {
            stack = player.getItemInHand(hand);
        }
        if (stack.getItem() == IafItems.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return InteractionResult.SUCCESS;
        }
        if (!this.isModelDead()) {
            if (stack.getItem() == IafItems.CREATIVE_DRAGON_MEAL.get()) {
                this.setTame(true, true);
                this.tame(player);
                this.setHunger(this.getHunger() + 20);
                this.heal(Math.min(this.getHealth(), (float)((int)(this.getMaxHealth() / 2.0f))));
                this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                this.spawnItemCrackParticles(stack.getItem());
                this.spawnItemCrackParticles(Items.BONE);
                this.spawnItemCrackParticles(Items.BONE_MEAL);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                this.brushedTime = 0;
                return InteractionResult.SUCCESS;
            }
            if (this.isFood(stack) && this.isMature()) {
                this.setAge(0);
                this.usePlayerItem(player, InteractionHand.MAIN_HAND, stack);
                this.setInLove(player);
                return InteractionResult.SUCCESS;
            }
            if (this.isOwnedBy((LivingEntity)player)) {
                if (stack.is(Items.BRUSH) && ((Boolean)IafCommonConfig.INSTANCE.dragon.enableBrushDragonScales.getValue()).booleanValue() && this.getDragonStage() >= 3 && (double)this.brushedTime < (double)this.getDragonStage() * (Double)IafCommonConfig.INSTANCE.dragon.brushTimesMul.getValue()) {
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        DragonColor color = DragonColor.getById(this.getVariant());
                        Vec3 pos = this.position();
                        EntityUtil.item((ServerLevel)serverWorld, (double)pos.x, (double)pos.y, (double)pos.z, (ItemStack)new ItemStack((ItemLike)color.getScaleItem(), new Random().nextInt((Integer)IafCommonConfig.INSTANCE.dragon.maxBrushScalesDropPerTime.getValue()) + 1), (int)0);
                    }
                    ++this.brushedTime;
                    return InteractionResult.SUCCESS;
                }
                if (stack.getItem() == this.dragonType.getCrystalItem() && !SummoningCrystalItem.hasDragon(stack)) {
                    this.setCrystalBound(true);
                    CompoundTag compound = new CompoundTag();
                    CompoundTag dragonTag = new CompoundTag();
                    dragonTag.putUUID("DragonUUID", this.getUUID());
                    if (this.getCustomName() != null) {
                        dragonTag.putString("CustomName", this.getCustomName().getString());
                    }
                    compound.put("Dragon", (Tag)dragonTag);
                    stack.set((DataComponentType)IafDataComponents.CRYSTAL_DRAGON_DATA.get(), (Object)compound);
                    this.playSound(SoundEvents.BOTTLE_FILL_DRAGONBREATH, 1.0f, 1.0f);
                    player.swing(hand);
                    return InteractionResult.SUCCESS;
                }
                this.tame(player);
                if (stack.getItem() == IafItems.DRAGON_HORN.get()) {
                    return super.mobInteract(player, hand);
                }
                if (stack.isEmpty() && !player.isShiftKeyDown()) {
                    if (!this.level().isClientSide && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        int dragonStage = this.getDragonStage();
                        if (dragonStage < 2) {
                            if (player.getPassengers().size() >= 3) {
                                return InteractionResult.FAIL;
                            }
                            this.startRiding((Entity)player, true);
                            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new StartRidingMobS2CPayload(this.getId(), true, true));
                        } else if (dragonStage > 2 && !player.isPassenger()) {
                            player.setShiftKeyDown(false);
                            player.startRiding((Entity)this, true);
                            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new StartRidingMobS2CPayload(this.getId(), true, false));
                            this.setInSittingPose(false);
                        }
                        this.getNavigation().stop();
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stack.isEmpty() && player.isShiftKeyDown()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)this);
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
                int itemFoodAmount = FoodUtils.getFoodPoints((ItemStack)stack, (boolean)true, (boolean)this.dragonType.piscivore());
                if (itemFoodAmount > 0 && (this.getHunger() < 100 || this.getHealth() < this.getMaxHealth())) {
                    this.setHunger(this.getHunger() + itemFoodAmount);
                    this.setHealth(Math.min(this.getMaxHealth(), (float)((int)(this.getHealth() + (float)itemFoodAmount / 10.0f))));
                    this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                    this.spawnItemCrackParticles(stack.getItem());
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                Item stackItem = stack.getItem();
                if (stackItem == IafItems.DRAGON_MEAL.get() && this.getAgeInDays() < (this.isTame() ? (Integer)IafCommonConfig.INSTANCE.dragon.maxTamedDragonAge.getValue() : 128)) {
                    this.setAgingDisabled(false);
                    this.growDragon(1);
                    this.setHunger(this.getHunger() + 20);
                    this.heal(Math.min(this.getHealth(), (float)((int)(this.getMaxHealth() / 2.0f))));
                    this.playSound(SoundEvents.GENERIC_EAT, this.getSoundVolume(), this.getVoicePitch());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.BONE);
                    this.spawnItemCrackParticles(Items.BONE_MEAL);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    if (this.brushedTime > 0) {
                        --this.brushedTime;
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stackItem == IafItems.SICKLY_DRAGON_MEAL.get() && !this.isAgingDisabled()) {
                    this.setHunger(this.getHunger() + 20);
                    this.heal(this.getMaxHealth());
                    this.playSound(SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundVolume(), this.getVoicePitch());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.BONE);
                    this.spawnItemCrackParticles(Items.BONE_MEAL);
                    this.spawnItemCrackParticles(Items.POISONOUS_POTATO);
                    this.spawnItemCrackParticles(Items.POISONOUS_POTATO);
                    this.setAgingDisabled(true);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stackItem == IafItems.DRAGON_STAFF.get()) {
                    if (player.isShiftKeyDown()) {
                        if (this.hasHomePosition) {
                            this.hasHomePosition = false;
                            player.displayClientMessage((Component)Component.translatable((String)"dragon.command.remove_home"), true);
                        } else {
                            BlockPos pos = this.blockPosition();
                            this.homePos = new HomePosition(pos, this.level());
                            this.hasHomePosition = true;
                            player.displayClientMessage((Component)Component.translatable((String)"dragon.command.new_home", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), this.homePos.getDimension()}), true);
                        }
                    } else {
                        this.playSound(SoundEvents.ZOMBIE_INFECT, this.getSoundVolume(), this.getVoicePitch());
                        if (!this.level().isClientSide) {
                            this.setCommand(this.getCommand() + 1);
                            if (this.getCommand() > 2) {
                                this.setCommand(0);
                            }
                        }
                        String commandText = "stand";
                        if (this.getCommand() == 1) {
                            commandText = "sit";
                        } else if (this.getCommand() == 2) {
                            commandText = "escort";
                        }
                        player.displayClientMessage((Component)Component.translatable((String)("dragon.command." + commandText)), true);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            if (!this.level().isClientSide && this.getDeathStage() < lastDeathStage && player.mayBuild()) {
                if (!stack.isEmpty() && stack.getItem() != null && stack.getItem() == Items.GLASS_BOTTLE && this.getDeathStage() < lastDeathStage / 2 && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootBlood.getValue()).booleanValue()) {
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    this.setDeathStage(this.getDeathStage() + 1);
                    player.getInventory().add(new ItemStack((ItemLike)this.getBloodItem(), 1));
                    return InteractionResult.SUCCESS;
                }
                if (stack.isEmpty()) {
                    if (this.getDeathStage() >= lastDeathStage - 1 && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootSkull.getValue()).booleanValue()) {
                        ItemStack skull = new ItemStack((ItemLike)this.getSkull());
                        skull.set((DataComponentType)IafDataComponents.DRAGON_SKULL.get(), (Object)new DragonSkullComponent(this.getDragonStage(), this.getAgeInDays()));
                        this.spawnAtLocation(skull, 1.0f);
                        this.remove(Entity.RemovalReason.DISCARDED);
                    } else if (this.getDeathStage() == lastDeathStage / 2 - 1 && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootHeart.getValue()).booleanValue()) {
                        ItemStack heart = new ItemStack(this.getHeartItem(), 1);
                        ItemStack egg = new ItemStack((ItemLike)((DragonColor)RandomHelper.randomOne(this.dragonType.colors())).getEggItem(), 1);
                        this.spawnAtLocation(heart, 1.0f);
                        if (!this.isMale() && this.getDragonStage() > 3) {
                            this.spawnAtLocation(egg, 1.0f);
                        }
                    } else {
                        ItemStack drop = this.getRandomDrop();
                        if (!drop.isEmpty()) {
                            this.spawnAtLocation(drop, 1.0f);
                        }
                    }
                } else {
                    return InteractionResult.PASS;
                }
                this.setDeathStage(this.getDeathStage() + 1);
                return InteractionResult.SUCCESS;
            }
            return super.mobInteract(player, hand);
        }
        return InteractionResult.PASS;
    }

    public boolean canFallInLove() {
        return this.isMature() && super.canFallInLove();
    }

    public abstract ItemLike getHeartItem();

    public abstract Item getBloodItem();

    public abstract Item getFleshItem();

    public abstract Item getSkull();

    private ItemStack getRandomDrop() {
        ItemStack stack = this.getItemFromLootTable();
        if (stack.getItem() == IafItems.DRAGON_BONE.get()) {
            this.playSound(SoundEvents.SKELETON_AMBIENT, 1.0f, 1.0f);
        } else {
            this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 1.0f, 1.0f);
        }
        return stack;
    }

    public boolean canPositionBeSeen(double x, double y, double z) {
        BlockHitResult result = this.level().clip(new ClipContext(new Vec3(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ()), new Vec3(x, y, z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double dist = result.getLocation().distanceToSqr(x, y, z);
        return dist <= 1.0 || result.getType() == HitResult.Type.MISS;
    }

    public abstract ResourceLocation getDeadLootTable();

    public ItemStack getItemFromLootTable() {
        ObjectListIterator objectListIterator;
        assert (this.getServer() != null);
        LootTable lootTable = this.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getDeadLootTable()));
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.level().damageSources().generic());
        if (lootTable != null && (objectListIterator = lootTable.getRandomItems(lootparams$builder.create(LootContextParamSets.ENTITY)).iterator()).hasNext()) {
            ItemStack itemstack = (ItemStack)objectListIterator.next();
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public void growDragon(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.setBoundingBox(this.getBoundingBox());
        if (this.level().isClientSide && this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                float f = (float)((double)this.getRandom().nextFloat() * (this.getBoundingBox().maxX - this.getBoundingBox().minX) + this.getBoundingBox().minX);
                float f1 = (float)((double)this.getRandom().nextFloat() * (this.getBoundingBox().maxY - this.getBoundingBox().minY) + this.getBoundingBox().minY);
                float f2 = (float)((double)this.getRandom().nextFloat() * (this.getBoundingBox().maxZ - this.getBoundingBox().minZ) + this.getBoundingBox().minZ);
                double motionX = this.getRandom().nextGaussian() * 0.07;
                double motionY = this.getRandom().nextGaussian() * 0.07;
                double motionZ = this.getRandom().nextGaussian() * 0.07;
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ);
                ++i;
            }
        }
        if (this.getDragonStage() >= 2) {
            this.removeVehicle();
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.getRandom().nextGaussian() * 0.07;
            double motionY = this.getRandom().nextGaussian() * 0.07;
            double motionZ = this.getRandom().nextGaussian() * 0.07;
            Vec3 headVec = this.getHeadPosition();
            if (!this.level().isClientSide) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)item)), headVec.x, headVec.y, headVec.z, 1, motionX, motionY, motionZ, 0.1);
                continue;
            }
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)item)), headVec.x, headVec.y, headVec.z, motionX, motionY, motionZ);
        }
    }

    public boolean isTimeToWake() {
        return this.level().isDay() || this.getCommand() == 2;
    }

    private boolean isStuck() {
        boolean checkNavigation;
        boolean skip;
        boolean bl = skip = this.isChained() || this.isTame();
        if (skip) {
            return false;
        }
        boolean bl2 = checkNavigation = this.ticksStill > 80 && this.canMove() && !this.isHovering();
        if (checkNavigation) {
            PathNavigation navigation = this.getNavigation();
            Path path = navigation.getPath();
            return !navigation.isDone() && (path == null || path.getEndNode() != null || this.blockPosition().distSqr((Vec3i)path.getEndNode().asBlockPos()) > 15.0);
        }
        return false;
    }

    public boolean isOverAir() {
        return this.isOverAir;
    }

    private boolean isOverAirLogic() {
        return this.level().isEmptyBlock(BlockPos.containing((double)this.getBlockX(), (double)(this.getBoundingBox().minY - 1.0), (double)this.getBlockZ()));
    }

    public boolean isDiving() {
        return false;
    }

    public boolean isBeyondHeight() {
        if (this.getY() > (double)this.level().getMaxBuildHeight()) {
            return true;
        }
        return this.getY() > (double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue();
    }

    private int calculateDownY() {
        if (this.getNavigation().getPath() != null) {
            Path path = this.getNavigation().getPath();
            Vec3 p = path.getEntityPosAtNode((Entity)this, Math.min(path.getNodeCount() - 1, path.getNextNodeIndex() + 1));
            if (p.y < this.getY() - 1.0) {
                return -1;
            }
        }
        return 1;
    }

    public void breakBlock(BlockPos position) {
        float hardness;
        if (((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this, position.getX(), position.getY(), position.getZ())) {
            return;
        }
        BlockState state = this.level().getBlockState(position);
        float f = hardness = (Boolean)IafCommonConfig.INSTANCE.dragon.griefing.getValue() != false || this.getDragonStage() <= 3 ? 2.0f : 5.0f;
        if (this.isBreakable(position, state, hardness, this)) {
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.6f, 1.0, (double)0.6f));
            if (!this.level().isClientSide()) {
                this.level().destroyBlock(position, !state.is(IafBlockTags.DRAGON_BLOCK_BREAK_NO_DROPS) && (double)this.random.nextFloat() <= (Double)IafCommonConfig.INSTANCE.dragon.blockBreakingDropChance.getValue());
            }
        }
    }

    public void breakBlocks(boolean force) {
        boolean doBreak = force;
        if (this.blockBreakCounter > 0 || (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue() == 0) {
            --this.blockBreakCounter;
            if (this.blockBreakCounter == 0 || (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue() == 0) {
                doBreak = true;
            }
        }
        if (doBreak && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && DragonUtils.canGrief(this) && !this.isModelDead() && this.getDragonStage() >= 3 && (this.canMove() || this.getControllingPassenger() != null)) {
            boolean bounds = true;
            int flightModifier = this.isFlying() && this.getTarget() != null ? -1 : 1;
            int yMinus = this.calculateDownY();
            BlockPos.betweenClosedStream((int)((int)Math.floor(this.getBoundingBox().minX) - 1), (int)((int)Math.floor(this.getBoundingBox().minY) + yMinus), (int)((int)Math.floor(this.getBoundingBox().minZ) - 1), (int)((int)Math.floor(this.getBoundingBox().maxX) + 1), (int)((int)Math.floor(this.getBoundingBox().maxY) + 1 + flightModifier), (int)((int)Math.floor(this.getBoundingBox().maxZ) + 1)).forEach(this::breakBlock);
        }
    }

    protected boolean isBreakable(BlockPos pos, BlockState state, float hardness, DragonBaseEntity entity) {
        return state.blocksMotion() && !state.isAir() && state.getFluidState().isEmpty() && !state.getShape((BlockGetter)this.level(), pos).isEmpty() && state.getDestroySpeed((BlockGetter)this.level(), pos) >= 0.0f && state.getDestroySpeed((BlockGetter)this.level(), pos) <= hardness && DragonUtils.canDragonBreak(state, (Entity)entity) && this.canDestroyBlock(pos, state);
    }

    public void spawnGroundEffects() {
        if (this.level().isClientSide) {
            int i = 0;
            while ((float)i < this.getRenderSize()) {
                for (int i1 = 0; i1 < 20; ++i1) {
                    float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                    float angle = (float)Math.PI / 180 * this.yBodyRot + (float)i1 * 1.0f;
                    double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
                    double extraY = 0.8f;
                    double extraZ = radius * Mth.cos((float)angle);
                    BlockPos ground = this.getGround(BlockPos.containing((double)(this.getX() + extraX), (double)(this.getY() + (double)0.8f - 1.0), (double)(this.getZ() + extraZ)));
                    BlockState BlockState2 = this.level().getBlockState(ground);
                    if (!BlockState2.isAir()) continue;
                    double motionX = this.getRandom().nextGaussian() * 0.07;
                    double motionY = this.getRandom().nextGaussian() * 0.07;
                    double motionZ = this.getRandom().nextGaussian() * 0.07;
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, BlockState2), true, this.getX() + extraX, (double)ground.getY() + (double)0.8f, this.getZ() + extraZ, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }

    private BlockPos getGround(BlockPos blockPos) {
        while (this.level().isEmptyBlock(blockPos) && blockPos.getY() > 1) {
            blockPos = blockPos.below();
        }
        return blockPos;
    }

    public boolean isActuallyBreathingFire() {
        return this.fireBreathTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 6000 || this.isGoingDown() || this.flyTicks > 40 && this.flyProgress == 0.0f || this.isChained() && this.flyTicks > 100;
    }

    public abstract String getVariantName(int var1);

    public void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (this.hasPassenger(passenger)) {
            if (this.getControllingPassenger() == null || !this.getControllingPassenger().getUUID().equals(passenger.getUUID())) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.stopRiding();
                }
                this.setYRot(passenger.getYRot());
                this.setYHeadRot(passenger.getYHeadRot());
                this.setXRot(passenger.getXRot());
                Vec3 riderPos = this.getRiderPosition();
                passenger.setPos(riderPos.x, riderPos.y + (double)passenger.getBbHeight(), riderPos.z);
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        double a = Mth.sin((float)(f * speed)) * f1 * degree;
        float bob = (float)(a - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(a));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    protected void updatePreyInMouth(Entity prey) {
        if (this.getAnimation() != ANIMATION_SHAKEPREY) {
            this.setAnimation(ANIMATION_SHAKEPREY);
        }
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null) {
            float baseDamage = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            float damage = baseDamage * 2.0f;
            boolean didDamage = prey.hurt(this.level().damageSources().mobAttack((LivingEntity)this), damage);
            if (didDamage && ((Boolean)IafCommonConfig.INSTANCE.dragon.canHealFromBiting.getValue()).booleanValue()) {
                this.heal(damage * 0.5f);
            }
            if (!(prey instanceof Player)) {
                this.setHunger(this.getHunger() + 1);
            }
            prey.stopRiding();
        } else {
            double extraY;
            this.yBodyRot = this.getYRot();
            float modTick_0 = this.getAnimationTick() - 25;
            float modTick_1 = this.getAnimationTick() > 25 && this.getAnimationTick() < 55 ? 8.0f * Mth.clamp((float)Mth.sin((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
            float modTick_2 = this.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, this.getAnimationTick() - 20);
            float radius = 0.75f * (0.6f * this.getRenderSize() / 3.0f) * -3.0f;
            float angle = (float)Math.PI / 180 * this.yBodyRot + 3.15f + modTick_1 * 2.0f * 0.015f;
            double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.cos((float)angle);
            double d = extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(this.getRenderSize() / 3.0f));
            assert (prey != null);
            prey.setPos(this.getX() + extraX, this.getY() + extraY, this.getZ() + extraZ);
        }
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() == 3;
    }

    public boolean isMature() {
        return this.getDragonStage() >= 4;
    }

    public boolean shouldDropLoot() {
        return this.isMature();
    }

    public boolean isBaby() {
        return this.getDragonStage() < 2;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setGender(this.getRandom().nextBoolean());
        int age = this.getRandom().nextInt(80) + 1;
        this.growDragon(age);
        this.setVariant(((DragonColor)RandomHelper.randomOne(this.dragonType.colors())).getName());
        this.setInSittingPose(false);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.heal(Math.round(this.minimumHealth + healthStep * (double)age));
        this.usingGroundAttack = true;
        this.setHunger(50);
        return spawnDataIn;
    }

    public boolean hurt(DamageSource dmg, float i) {
        if (this.isModelDead() && dmg != this.level().damageSources().fellOutOfWorld()) {
            return false;
        }
        if (this.isVehicle() && dmg.getEntity() != null && this.getControllingPassenger() != null && dmg.getEntity() == this.getControllingPassenger()) {
            return false;
        }
        if ((dmg.type().msgId().contains("arrow") || this.getVehicle() != null && dmg.getEntity() != null && dmg.getEntity().is(this.getVehicle())) && this.isPassenger()) {
            return false;
        }
        if (dmg.is(DamageTypes.IN_WALL) || dmg.is(DamageTypes.FALLING_BLOCK) || dmg.is(DamageTypes.CRAMMING)) {
            return false;
        }
        if (!this.level().isClientSide && dmg.getEntity() != null && this.getRandom().nextInt(4) == 0) {
            this.roar();
        }
        if (i > 0.0f && this.isSleeping()) {
            this.setInSittingPose(false);
            if (!this.isTame() && dmg.getEntity() instanceof Player) {
                this.setTarget((LivingEntity)((Player)dmg.getEntity()));
            }
        }
        return super.hurt(dmg, i);
    }

    public void refreshDimensions() {
        super.refreshDimensions();
        float scale = Math.min(this.getRenderSize() * 0.35f, 7.0f);
        if (scale != this.lastScale) {
            this.updateScale(this.getRenderSize() / 3.0f);
        }
        this.lastScale = scale;
    }

    public float maxUpStep() {
        return Math.max(1.2f, 1.2f + (float)(Math.min(this.getAgeInDays(), 125) - 25) * 1.8f / 100.0f);
    }

    public void tick() {
        super.tick();
        if (!((Boolean)IntegrationExecutor.getWhenLoad((String)"ponder", () -> () -> this.level() instanceof SchematicLevel, () -> false)).booleanValue()) {
            this.refreshDimensions();
            this.updateParts();
        }
        this.prevDragonPitch = this.getDragonPitch();
        this.level().getProfiler().push("dragonLogic");
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue((double)this.maxUpStep());
        this.isOverAir = this.isOverAirLogic();
        this.logic.updateDragonCommon();
        if (this.isModelDead()) {
            if (!this.level().isClientSide && this.level().isEmptyBlock(BlockPos.containing((double)this.getBlockX(), (double)this.getBoundingBox().minY, (double)this.getBlockZ())) && this.getY() > -1.0) {
                this.move(MoverType.SELF, new Vec3(0.0, (double)-0.2f, 0.0));
            }
            this.setBreathingFire(false);
            float dragonPitch = this.getDragonPitch();
            if (dragonPitch > 0.0f) {
                dragonPitch = Math.min(0.0f, dragonPitch - 5.0f);
                this.setDragonPitch(dragonPitch);
            }
            if (dragonPitch < 0.0f) {
                this.setDragonPitch(Math.max(0.0f, dragonPitch + 5.0f));
            }
        } else if (this.level().isClientSide) {
            this.logic.updateDragonClient();
        } else {
            this.logic.updateDragonServer();
            this.logic.updateDragonAttack();
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("dragonFlight");
        if (this.useFlyingPathFinder() && !this.level().isClientSide) {
            this.flightManager.update();
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().pop();
        if (!this.level().isClientSide() && ((Boolean)IafCommonConfig.INSTANCE.dragon.digWhenStuck.getValue()).booleanValue() && this.isStuck()) {
            this.breakBlocks(true);
            this.resetStuck();
        }
    }

    private void resetStuck() {
        this.ticksStill = 0;
    }

    public void aiStep() {
        super.aiStep();
        this.prevModelDeadProgress = this.modelDeadProgress;
        this.prevDiveProgress = this.diveProgress;
        this.prevAnimationProgresses[0] = this.sitProgress;
        this.prevAnimationProgresses[1] = this.sleepProgress;
        this.prevAnimationProgresses[2] = this.hoverProgress;
        this.prevAnimationProgresses[3] = this.flyProgress;
        this.prevAnimationProgresses[4] = this.fireBreathProgress;
        this.prevAnimationProgresses[5] = this.ridingProgress;
        this.prevAnimationProgresses[6] = this.tackleProgress;
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.getTarget() instanceof Player) {
            this.setTarget(null);
        }
        if (this.isModelDead()) {
            if (this.isVehicle()) {
                this.ejectPassengers();
            }
            this.setHovering(false);
            this.setFlying(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.animationTick > this.getAnimation().getDuration() && !this.level().isClientSide) {
            this.animationTick = 0;
        }
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public float getAgeScale() {
        return Math.min(this.getRenderSize() * 0.35f, 7.0f);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getRenderSize() {
        DragonSize size = DragonSize.getSize(this.getDragonStage());
        float step = size.step() / 25.0f;
        if (this.getAgeInDays() > 125) {
            return size.x0() + step * 25.0f;
        }
        return size.x0() + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean doHurtTarget(Entity entityIn) {
        this.getLookControl().setLookAt(entityIn, 30.0f, 30.0f);
        if (this.isTackling() || this.isModelDead()) {
            return false;
        }
        return entityIn.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
    }

    public void rideTick() {
        Entity entity = this.getVehicle();
        if (this.isPassenger() && !entity.isAlive()) {
            this.stopRiding();
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            if (this.isPassenger()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.hasPassenger((Entity)this) && riding instanceof Player) {
            Player player = (Player)riding;
            int i = riding.getPassengers().indexOf(this);
            float radius = (i == 2 ? -0.2f : 0.5f) + (float)(player.isFallFlying() ? 2 : 0);
            float angle = (float)Math.PI / 180 * player.yBodyRot + (float)(i == 1 ? 90 : (i == 0 ? -90 : 0));
            double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.cos((float)angle);
            double extraY = (riding.isShiftKeyDown() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.yHeadRot = player.yHeadRot;
            this.setYRot(this.yHeadRot);
            this.setPos(riding.getX() + extraX, riding.getY() + extraY, riding.getZ() + extraZ);
            if ((this.getControlState() == 16 || player.isFallFlying()) && !riding.isPassenger()) {
                this.stopRiding();
                if (this.level().isClientSide) {
                    NetworkManager.sendToServer((CustomPacketPayload)new StartRidingMobC2SPayload(this.getId(), false, true));
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void playAmbientSound() {
        if (!(this.isSleeping() || this.isModelDead() || this.level().isClientSide)) {
            if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.playAmbientSound();
        }
    }

    protected void playHurtSound(DamageSource source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION && !this.level().isClientSide) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.playHurtSound(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMate(Animal otherAnimal) {
        if (!(otherAnimal instanceof DragonBaseEntity)) return false;
        DragonBaseEntity dragon = (DragonBaseEntity)otherAnimal;
        if (otherAnimal == this) return false;
        if (otherAnimal.getClass() != this.getClass()) return false;
        if (this.isMale()) {
            if (!dragon.isMale()) return true;
        }
        if (this.isMale()) return false;
        if (!dragon.isMale()) return false;
        return true;
    }

    public DragonEggEntity createEgg() {
        DragonEggEntity dragon = new DragonEggEntity((EntityType<DragonEggEntity>)((EntityType)IafEntities.DRAGON_EGG.get()), this.level());
        dragon.setEggType((DragonColor)IafRegistries.DRAGON_COLOR.byId(new Random().nextInt(4) + this.getStartMetaForType()));
        dragon.setPos((double)Mth.floor((double)this.getX()) + 0.5, Mth.floor((double)this.getY()) + 1, (double)Mth.floor((double)this.getZ()) + 0.5);
        return dragon;
    }

    public int getStartMetaForType() {
        return 0;
    }

    public boolean isTargetBlocked(Vec3 target) {
        if (target != null) {
            BlockHitResult rayTrace = this.level().clip(new ClipContext(this.position().add(0.0, (double)this.getEyeHeight(), 0.0), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            BlockPos sidePos = rayTrace.getBlockPos();
            if (!this.level().isEmptyBlock(sidePos)) {
                return true;
            }
            return rayTrace.getType() == HitResult.Type.BLOCK;
        }
        return false;
    }

    private double getFlySpeed() {
        return (2.0 + (double)this.getAgeInDays() / 125.0 * 2.0) * (double)(this.isTackling() ? 2 : 1);
    }

    public boolean isTackling() {
        return (Boolean)this.entityData.get(TACKLE);
    }

    public void setTackling(boolean tackling) {
        this.entityData.set(TACKLE, (Object)tackling);
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.entityData.get(AGINGDISABLED);
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.entityData.set(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public boolean isBoundToCrystal() {
        return (Boolean)this.entityData.get(CRYSTAL_BOUND);
    }

    public void setCrystalBound(boolean crystalBound) {
        this.entityData.set(CRYSTAL_BOUND, (Object)crystalBound);
    }

    public float getDistanceSquared(Vec3 Vector3d) {
        float f = (float)(this.getX() - Vector3d.x);
        float f1 = (float)(this.getY() - Vector3d.y);
        float f2 = (float)(this.getZ() - Vector3d.z);
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean isImmobile() {
        return this.getHealth() <= 0.0f || this.isOrderedToSit() && !this.isVehicle() || this.isModelDead() || this.isPassenger();
    }

    public boolean isInWater() {
        return super.isInWater() && this.getFluidHeight(FluidTags.WATER) > (double)Mth.floor((float)((float)this.getDragonStage() / 2.0f));
    }

    public void travel(Vec3 pTravelVector) {
        if (this.getAnimation() == ANIMATION_SHAKEPREY || !this.canMove() && !this.isVehicle() || this.isOrderedToSit()) {
            if (this.getNavigation().getPath() != null) {
                this.getNavigation().stop();
            }
            pTravelVector = new Vec3(0.0, 0.0, 0.0);
        }
        Objects.requireNonNull(this);
        if (this.getControllingPassenger() != null) {
            LivingEntity rider = this.getControllingPassenger();
            if (rider == null) {
                super.travel(pTravelVector);
                return;
            }
            if (this.isHovering() || this.isFlying()) {
                double forward = rider.zza;
                double strafing = rider.xxa;
                double vertical = 0.0;
                float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
                float airSpeedModifier = (float)((double)5.2f + 1.0 * Mth.map((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                speed *= airSpeedModifier;
                if (forward > 0.0) {
                    this.setFlying(true);
                    this.setHovering(false);
                }
                this.setTackling(this.isAggressive() && this.getXRot() > -5.0f && this.getDeltaMovement().length() > 1.0);
                Objects.requireNonNull(this);
                boolean bl = this.gliding = rider.isSprinting();
                if (!this.gliding) {
                    speed += this.glidingSpeedBonus;
                    forward *= rider.zza > 0.0f ? 1.0 : 0.5;
                    strafing *= (double)0.4f;
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = 1.0;
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = -1.0;
                    } else {
                        this.isControlledByLocalInstance();
                    }
                } else {
                    speed *= 1.5f;
                    strafing *= (double)0.1f;
                    this.glidingSpeedBonus = (float)Mth.clamp((double)((double)this.glidingSpeedBonus + this.getDeltaMovement().y * -0.05), (double)-0.8, (double)1.5);
                    speed += this.glidingSpeedBonus;
                    forward = Mth.abs((float)Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))));
                    vertical = Mth.abs((float)Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))));
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = Math.max(vertical, 0.5);
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = Math.min(vertical, -0.5);
                    } else if (this.isGoingUp() && this.isGoingDown()) {
                        vertical = 0.0;
                    } else if (this.getXRot() < 0.0f) {
                        vertical *= 1.0;
                    } else if (this.getXRot() > 0.0f) {
                        vertical *= -1.0;
                    } else {
                        this.isControlledByLocalInstance();
                    }
                }
                this.glidingSpeedBonus -= (float)((double)this.glidingSpeedBonus * 0.01);
                if (this.isControlledByLocalInstance()) {
                    float flyingSpeed = speed * 0.1f;
                    this.setSpeed(flyingSpeed);
                    this.moveRelative(flyingSpeed, new Vec3(strafing, vertical, forward));
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    this.setDeltaMovement(this.getDeltaMovement().multiply(new Vec3(0.9, 0.9, 0.9)));
                    Vec3 currentMotion = this.getDeltaMovement();
                    if (this.horizontalCollision) {
                        currentMotion = new Vec3(currentMotion.x, 0.1, currentMotion.z);
                    }
                    this.setDeltaMovement(currentMotion);
                    this.calculateEntityAnimation(false);
                } else {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                this.tryCheckInsideBlocks();
                this.updatePitch(this.yOld - this.getY());
            } else if (this.isInWater() || this.isInLava()) {
                double forward = rider.zza;
                double strafing = rider.xxa;
                double vertical = 0.0;
                float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
                if (this.isGoingUp() && !this.isGoingDown()) {
                    vertical = 0.5;
                } else if (this.isGoingDown() && !this.isGoingUp()) {
                    vertical = -0.5;
                }
                float flyingSpeed = speed;
                this.setSpeed(flyingSpeed);
                this.setZza((float)forward);
                super.travel(pTravelVector.add(strafing, vertical, forward));
            } else {
                double forward = rider.zza;
                double strafing = rider.xxa * 0.5f;
                double vertical = pTravelVector.y;
                float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
                float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
                forward *= (double)(speed *= groundSpeedModifier);
                forward *= rider.isSprinting() ? (double)1.2f : 1.0;
                forward *= rider.zza > 0.0f ? 1.0 : (double)0.2f;
                if (this.isControlledByLocalInstance()) {
                    this.setSpeed(speed);
                    super.travel(new Vec3(strafing, vertical, forward));
                } else {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                this.tryCheckInsideBlocks();
                this.updatePitch(this.yOld - this.getY());
            }
        } else {
            super.travel(pTravelVector);
        }
    }

    public void updatePitch(double verticalDelta) {
        if (this.isOverAir() && !this.isPassenger()) {
            if (!this.isHovering()) {
                this.incrementDragonPitch((float)verticalDelta * 10.0f);
            }
            this.setDragonPitch(Mth.clamp((float)this.getDragonPitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            float planeDist = (float)((Math.abs(this.getDeltaMovement().x) + Math.abs(this.getDeltaMovement().z)) * 6.0);
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(1.0f);
            } else if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(1.0f);
            }
            if (this.getControllingPassenger() == null && this.getDragonPitch() < -45.0f && planeDist < 3.0f && this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
        } else if (Mth.abs((float)this.getDragonPitch()) < 1.0f) {
            this.setDragonPitch(0.0f);
        } else {
            this.setDragonPitch(this.getDragonPitch() / 1.5f);
        }
    }

    public void updateRider() {
        LivingEntity controllingPassenger = this.getControllingPassenger();
        if (controllingPassenger instanceof Player) {
            Player rider = (Player)controllingPassenger;
            this.ticksStill = 0;
            this.hoverTicks = 0;
            this.flyTicks = 0;
            if (this.isGoingUp()) {
                if (!this.isFlying() && !this.isHovering()) {
                    this.spacebarTicks += 2;
                }
            } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.setCommand(2);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.getOwner() != null && this.getPassengers().contains(this.getOwner()) && !this.isFlying() && !this.isHovering() && !this.isInWater()) {
                this.setHovering(true);
                this.spacebarTicks = 0;
                this.glidingSpeedBonus = 0.0f;
            }
            if (this.isFlying() || this.isHovering()) {
                if (rider.zza > 0.0f) {
                    this.setFlying(true);
                    this.setHovering(false);
                } else {
                    this.setFlying(false);
                    this.setHovering(true);
                }
                if (!this.isOverAir() && this.isFlying() && rider.getXRot() > 10.0f && !this.isInWater()) {
                    this.setHovering(false);
                    this.setFlying(false);
                }
                if (!this.isOverAir() && this.isGoingDown() && !this.isInWater()) {
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (this.isTackling()) {
                ++this.tacklingTicks;
                if (this.tacklingTicks == 40) {
                    this.tacklingTicks = 0;
                }
                if (!this.isFlying() && this.onGround()) {
                    this.tacklingTicks = 0;
                    this.setTackling(false);
                }
                List victims = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(2.0, 2.0, 2.0), potentialVictim -> potentialVictim != rider && potentialVictim instanceof LivingEntity);
                victims.forEach(victim -> this.logic.attackTarget((Entity)victim, rider, this.getDragonStage() * 3));
            }
            if (this.isStriking() && this.getControllingPassenger() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire((Entity)this.getControllingPassenger());
                this.fireStopTicks = 10;
            }
            if (this.isAggressive() && this.getControllingPassenger() != null && this.getControllingPassenger() instanceof Player) {
                int damage;
                boolean didDamage;
                LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, this.getControllingPassenger(), (double)this.getDragonStage() + (this.getBoundingBox().maxX - this.getBoundingBox().minX));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (Entity)target) && (didDamage = this.logic.attackTarget((Entity)target, rider, damage = (int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue())) && ((Boolean)IafCommonConfig.INSTANCE.dragon.canHealFromBiting.getValue()).booleanValue()) {
                    this.heal((float)damage * 0.1f);
                }
            }
            if (this.getTarget() != null && !this.getPassengers().isEmpty() && this.getOwner() != null && this.getPassengers().contains(this.getOwner())) {
                this.setTarget(null);
            }
            if (this.getInBlockState().getFluidState().isSource() && this.isInWater() && !this.isGoingUp()) {
                this.setFlying(false);
                this.setHovering(false);
            }
        } else if (controllingPassenger instanceof DreadQueenEntity) {
            Player ridingPlayer = this.getRidingPlayer();
            if (ridingPlayer != null) {
                if (this.isGoingUp()) {
                    if (!this.isFlying() && !this.isHovering()) {
                        this.spacebarTicks += 2;
                    }
                } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (!this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
            }
            if (this.isStriking() && this.getControllingPassenger() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire((Entity)this.getControllingPassenger());
                this.fireStopTicks = 10;
            }
            if (this.isAggressive() && this.getControllingPassenger() != null && this.getControllingPassenger() instanceof Player) {
                LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, this.getControllingPassenger(), (double)this.getDragonStage() + (this.getBoundingBox().maxX - this.getBoundingBox().minX));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (Entity)target)) {
                    this.logic.attackTarget((Entity)target, ridingPlayer, (int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
                }
            }
            if (this.isFlying()) {
                if (!this.isHovering() && this.getControllingPassenger() != null && !this.onGround() && Math.max(Math.abs(this.getDeltaMovement().x()), Math.abs(this.getDeltaMovement().z())) < (double)0.1f) {
                    this.setHovering(true);
                    this.setFlying(false);
                }
            } else if (this.isHovering() && this.getControllingPassenger() != null && !this.onGround() && Math.max(Math.abs(this.getDeltaMovement().x()), Math.abs(this.getDeltaMovement().z())) > (double)0.1f) {
                this.setFlying(true);
                this.usingGroundAttack = false;
                this.setHovering(false);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.getOwner() != null && this.getPassengers().contains(this.getOwner()) && !this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
            if (this.isVehicle() && !this.isOverAir() && this.isFlying() && !this.isHovering() && this.flyTicks > 40) {
                this.setFlying(false);
            }
        }
    }

    public void move(MoverType pType, Vec3 pPos) {
        if (this.isOrderedToSit() && !this.isVehicle()) {
            pPos = new Vec3(0.0, pPos.y(), 0.0);
        }
        if (this.isVehicle()) {
            if (this.isControlledByLocalInstance()) {
                if (this.horizontalCollision) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply((double)0.6f, 1.0, (double)0.6f));
                }
                super.move(pType, pPos);
            } else {
                super.move(pType, pPos);
            }
            this.setNoGravity(this.isHovering() || this.isFlying());
        } else {
            this.setNoGravity(false);
            super.move(pType, pPos);
        }
    }

    public void updateCheckPlayer() {
        double checkLength = this.getBoundingBox().getSize() * 3.0;
        Player player = this.level().getNearestPlayer((Entity)this, checkLength);
        if (this.isSleeping() && player != null && !this.isOwnedBy((LivingEntity)player) && !player.isCreative()) {
            this.setInSittingPose(false);
            this.setOrderedToSit(false);
            this.setTarget((LivingEntity)player);
        }
    }

    public boolean isDirectPathBetweenPoints(Vec3 vec1, Vec3 vec2) {
        BlockHitResult rayTrace = this.level().clip(new ClipContext(vec1, new Vec3(vec2.x, vec2.y + (double)this.getBbHeight() * 0.5, vec2.z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return rayTrace.getType() != HitResult.Type.BLOCK;
    }

    public void die(DamageSource cause) {
        super.die(cause);
        this.setHunger(this.getHunger() + FoodUtils.getFoodPoints((Entity)this));
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            this.onHearFlute(player);
        }
    }

    @Override
    public void onHearFlute(Player player) {
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (this.isFlying() || this.isHovering()) {
                this.setFlying(false);
                this.setHovering(false);
            }
            this.navigation.stop();
        }
    }

    public abstract SoundEvent getRoarSound();

    public void roar() {
        block9: {
            block8: {
                if (GorgonEntity.isStoneMob((LivingEntity)this) || this.isModelDead()) {
                    return;
                }
                if (!this.random.nextBoolean()) break block8;
                if (this.getAnimation() != ANIMATION_EPIC_ROAR) {
                    this.setAnimation(ANIMATION_EPIC_ROAR);
                    this.playSound(this.getRoarSound(), this.getSoundVolume() + 3.0f + (float)Math.max(0, this.getDragonStage() - 2), this.getVoicePitch() * 0.7f);
                }
                if (this.getDragonStage() <= 3) break block9;
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof DragonBaseEntity && ((DragonBaseEntity)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (isStrongerDragon) continue;
                    if (this.isOwnedBy(living) || this.isOwnersPet(living)) {
                        living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 50 * size));
                        continue;
                    }
                    if (living.getItemBySlot(EquipmentSlot.HEAD).getItem() == IafItems.EARPLUGS.get()) continue;
                    living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 50 * size));
                }
                break block9;
            }
            if (this.getAnimation() != ANIMATION_ROAR) {
                this.setAnimation(ANIMATION_ROAR);
                this.playSound(this.getRoarSound(), this.getSoundVolume() + 2.0f + (float)Math.max(0, this.getDragonStage() - 3), this.getVoicePitch());
            }
            if (this.getDragonStage() > 3) {
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof DragonBaseEntity && ((DragonBaseEntity)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (isStrongerDragon) continue;
                    if (this.isOwnedBy(living) || this.isOwnersPet(living)) {
                        living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 30 * size));
                        continue;
                    }
                    living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 30 * size));
                }
            }
        }
    }

    private boolean isOwnersPet(LivingEntity living) {
        return this.isTame() && this.getOwner() != null && living instanceof TamableAnimal && ((TamableAnimal)living).getOwner() != null && this.getOwner().is((Entity)((TamableAnimal)living).getOwner());
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3 vec1, Vec3 vec2) {
        BlockHitResult movingobjectposition = this.level().clip(new ClipContext(vec1, vec2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return movingobjectposition.getType() != HitResult.Type.BLOCK;
    }

    public boolean shouldRenderEyes() {
        return !this.isSleeping() && !this.isModelDead() && !this.isBlinking() && !GorgonEntity.isStoneMob((LivingEntity)this);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    public boolean isChained() {
        return ChainData.get((LivingEntity)this).getChainedTo().isEmpty();
    }

    protected void dropFromLootTable(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public HitResult rayTraceRider(Entity rider, double blockReachDistance, float partialTicks) {
        Vec3 Vector3d = rider.getEyePosition(partialTicks);
        Vec3 Vector3d1 = rider.getViewVector(partialTicks);
        Vec3 Vector3d2 = Vector3d.add(Vector3d1.x * blockReachDistance, Vector3d1.y * blockReachDistance, Vector3d1.z * blockReachDistance);
        return this.level().clip(new ClipContext(Vector3d, Vector3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    protected float getRideHeightBase() {
        return 0.00223789f * Mth.square((float)this.getRenderSize()) + 0.23313718f * this.getRenderSize() - 1.7179043f;
    }

    protected float getRideHorizontalBase() {
        return 0.00336283f * Mth.square((float)this.getRenderSize()) + 0.19342425f * this.getRenderSize() - 0.026221339f;
    }

    public Vec3 getRiderPosition() {
        float extraXZ = 0.0f;
        float extraY = 0.0f;
        float pitchXZ = 0.0f;
        float pitchY = 0.0f;
        float dragonPitch = this.getDragonPitch();
        if (dragonPitch > 0.0f) {
            pitchXZ = Math.min(dragonPitch / 90.0f, 0.2f);
            pitchY = -(dragonPitch / 90.0f) * 0.6f;
        } else if (dragonPitch < 0.0f) {
            pitchXZ = Math.max(dragonPitch / 90.0f, -0.5f);
            pitchY = dragonPitch / 90.0f * 0.03f;
        }
        extraXZ += pitchXZ * this.getRenderSize();
        extraY += pitchY * this.getRenderSize();
        float linearFactor = Mth.map((float)Math.max(this.getAgeInDays() - 50, 0), (float)0.0f, (float)75.0f, (float)0.0f, (float)1.0f);
        LivingEntity rider = this.getControllingPassenger();
        if (rider != null && rider.getXRot() < 0.0f) {
            extraY += (float)Mth.map((double)rider.getXRot(), (double)60.0, (double)-40.0, (double)-0.1, (double)0.1);
        }
        if (this.isHovering() || this.isFlying()) {
            extraY += 1.1f * linearFactor;
            extraY += this.getRideHeightBase() * 0.6f;
        } else {
            if (rider != null && rider.zza > 0.0f) {
                float MAX_RAISE_HEIGHT = 1.1f * linearFactor + this.getRideHeightBase() * 0.1f;
                this.riderWalkingExtraY = Math.min(MAX_RAISE_HEIGHT, this.riderWalkingExtraY + 0.1f);
            } else {
                this.riderWalkingExtraY = Math.max(0.0f, this.riderWalkingExtraY - 0.15f);
            }
            extraY += this.riderWalkingExtraY;
        }
        float xzMod = this.getRideHorizontalBase() + extraXZ;
        float yMod = this.getRideHeightBase() + extraY;
        float headPosX = (float)(this.getX() + (double)(xzMod * Mth.cos((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.getY() + (double)yMod);
        float headPosZ = (float)(this.getZ() + (double)(xzMod * Mth.sin((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
        return new Vec3((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        if (passenger.isInWall()) {
            return this.position().add(0.0, 1.0, 0.0);
        }
        return this.getRiderPosition().add(0.0, (double)passenger.getBbHeight(), 0.0);
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.setDeathStage(this.getAgeInDays() / 5);
        this.setModelDead(false);
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isModelDead()) {
            return true;
        }
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                TamableAnimal entity = (TamableAnimal)entityIn;
                return entity.isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public Vec3 getHeadPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        int tick = this.getAnimationTick() < 10 ? this.getAnimationTick() : (this.getAnimationTick() > 50 ? 60 - this.getAnimationTick() : 10);
        float epicRoarProg = this.getAnimation() == ANIMATION_EPIC_ROAR ? (float)tick * 0.1f : 0.0f;
        float sleepProg = this.sleepProgress * -0.025f;
        float pitchMulti = 0.0f;
        float pitchAdjustment = 0.0f;
        float pitchMinus = 0.0f;
        float dragonPitch = -this.getDragonPitch();
        if (this.isFlying() || this.isHovering()) {
            pitchMulti = Mth.sin((float)((float)Math.toRadians(dragonPitch)));
            pitchAdjustment = 1.2f;
            if ((pitchMulti *= 2.1f * Math.abs(dragonPitch) / 90.0f) > 0.0f) {
                pitchMulti *= 1.5f - pitchMulti * 0.5f;
            }
            if (pitchMulti < 0.0f) {
                pitchMulti *= 1.3f - pitchMulti * 0.1f;
            }
            pitchMinus = 0.3f * Math.abs(dragonPitch / 90.0f);
            if (dragonPitch >= 0.0f) {
                pitchAdjustment = 0.6f * Math.abs(dragonPitch / 90.0f);
                pitchMinus = 0.95f * Math.abs(dragonPitch / 90.0f);
            }
        }
        float flightXz = 1.0f + flyProg + hoverProg;
        float xzMod = 1.7f * this.getRenderSize() * 0.3f * flightXz + this.getRenderSize() * (0.3f * Mth.sin((float)((float)((double)(dragonPitch + 90.0f) * Math.PI / 180.0))) * pitchAdjustment - pitchMinus - hoverProg * 0.45f);
        float headPosX = (float)(this.getX() + (double)(xzMod * Mth.cos((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.getY() + (double)((0.7f + sitProg + hoverProg + deadProg + epicRoarProg + sleepProg + flyProg + pitchMulti) * this.getRenderSize() * 0.3f));
        float headPosZ = (float)(this.getZ() + (double)(xzMod * Mth.sin((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
        return new Vec3((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public abstract void stimulateFire(double var1, double var3, double var5, int var7);

    public void randomizeAttacks() {
        this.airAttack = IafDragonAttacks.Air.values()[this.getRandom().nextInt(IafDragonAttacks.Air.values().length)];
        this.groundAttack = IafDragonAttacks.Ground.values()[this.getRandom().nextInt(IafDragonAttacks.Ground.values().length)];
    }

    public boolean shouldBlockExplode(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, float explosionPower) {
        return !(blockStateIn.getBlock() instanceof DragonProof) && DragonUtils.canDragonBreak(blockStateIn, (Entity)this);
    }

    public void tryScorchTarget() {
        LivingEntity entity = this.getTarget();
        if (entity != null) {
            float distX = (float)(entity.getX() - this.getX());
            float distZ = (float)(entity.getZ() - this.getZ());
            if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.setYRot(this.yBodyRot);
                    if (this.tickCount % 5 == 0) {
                        this.playSound((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                    }
                    int breathTicks = Mth.clamp((int)this.fireBreathTicks, (int)0, (int)40);
                    this.stimulateFire(this.getX() + (double)(distX * (float)breathTicks / 40.0f), entity.getY(), this.getZ() + (double)(distZ * (float)breathTicks / 40.0f), 1);
                }
            } else {
                this.setBreathingFire(true);
            }
        }
    }

    public void setTarget(LivingEntity LivingEntityIn) {
        super.setTarget(LivingEntityIn);
        this.flightManager.onSetAttackTarget(LivingEntityIn);
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        TamableAnimal tamableTarget;
        UUID targetOwner;
        if (this.isTame() && target instanceof TamableAnimal && (targetOwner = (tamableTarget = (TamableAnimal)target).getOwnerUUID()) != null && targetOwner.equals(this.getOwnerUUID())) {
            return false;
        }
        return super.wantsToAttack(target, owner);
    }

    public boolean canAttack(LivingEntity target) {
        return super.canAttack(target) && DragonUtils.isAlive(target);
    }

    public boolean isPart(Entity entityHit) {
        return this.headPart != null && this.headPart.is(entityHit) || this.neckPart != null && this.neckPart.is(entityHit) || this.leftWingLowerPart != null && this.leftWingLowerPart.is(entityHit) || this.rightWingLowerPart != null && this.rightWingLowerPart.is(entityHit) || this.leftWingUpperPart != null && this.leftWingUpperPart.is(entityHit) || this.rightWingUpperPart != null && this.rightWingUpperPart.is(entityHit) || this.tail1Part != null && this.tail1Part.is(entityHit) || this.tail2Part != null && this.tail2Part.is(entityHit) || this.tail3Part != null && this.tail3Part.is(entityHit) || this.tail4Part != null && this.tail4Part.is(entityHit);
    }

    @Override
    public double getFlightSpeedModifier() {
        return (Double)IafCommonConfig.INSTANCE.dragon.dragonFlightSpeedMod.getValue();
    }

    public boolean isAllowedToTriggerFlight() {
        return (this.hasFlightClearance() && this.onGround() || this.isInWater()) && !this.isOrderedToSit() && this.getPassengers().isEmpty() && !this.isBaby() && !this.isSleeping() && this.canMove();
    }

    public BlockPos getEscortPosition() {
        return this.getOwner() != null ? new BlockPos((Vec3i)this.getOwner().blockPosition()) : this.blockPosition();
    }

    public boolean shouldTPtoOwner() {
        return this.getOwner() != null && this.distanceTo((Entity)this.getOwner()) > 10.0f;
    }

    public boolean isSkeletal() {
        return this.getDeathStage() >= this.getAgeInDays() / 5 / 2;
    }

    public boolean save(CompoundTag compound) {
        return this.saveAsPassenger(compound);
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.GENERIC_EAT || soundIn == this.getAmbientSound() || soundIn == this.getHurtSound(this.level().damageSources().generic()) || soundIn == this.getDeathSound() || soundIn == this.getRoarSound()) {
            if (!this.isSilent() && this.headPart != null) {
                this.level().playSound(null, this.headPart.getX(), this.headPart.getY(), this.headPart.getZ(), soundIn, this.getSoundSource(), volume, pitch);
            }
        } else {
            super.playSound(soundIn, volume, pitch);
        }
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public boolean hasFlightClearance() {
        BlockPos topOfBB = BlockPos.containing((double)this.getBlockX(), (double)this.getBoundingBox().maxY, (double)this.getBlockZ());
        for (int i = 1; i < 4; ++i) {
            if (this.level().isEmptyBlock(topOfBB.above(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return switch (slotIn) {
            case EquipmentSlot.OFFHAND -> this.dragonInventory.getItem(0);
            case EquipmentSlot.HEAD -> this.dragonInventory.getItem(1);
            case EquipmentSlot.CHEST -> this.dragonInventory.getItem(2);
            case EquipmentSlot.LEGS -> this.dragonInventory.getItem(3);
            case EquipmentSlot.FEET -> this.dragonInventory.getItem(4);
            default -> super.getItemBySlot(slotIn);
        };
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn) {
            case OFFHAND: {
                this.dragonInventory.setItem(0, stack);
                break;
            }
            case HEAD: {
                this.dragonInventory.setItem(1, stack);
                break;
            }
            case CHEST: {
                this.dragonInventory.setItem(2, stack);
                break;
            }
            case LEGS: {
                this.dragonInventory.setItem(3, stack);
                break;
            }
            case FEET: {
                this.dragonInventory.setItem(4, stack);
                break;
            }
            default: {
                super.getItemBySlot(slotIn);
                return;
            }
        }
        this.dragonInventory.setChanged();
    }

    public SoundEvent getBabyFireSound() {
        return SoundEvents.FIRE_EXTINGUISH;
    }

    public boolean isPlayingAttackAnimation() {
        return this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_SHAKEPREY || this.getAnimation() == ANIMATION_WINGBLAST || this.getAnimation() == ANIMATION_TAILWHACK;
    }

    protected IafDragonLogic createDragonLogic() {
        return new IafDragonLogic(this);
    }

    public int getFlightChancePerTick() {
        return 1500;
    }

    public void onClientRemoval() {
        DragonPosWorldData data;
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.chunkLoadSummonCrystal.getValue()).booleanValue() && this.isBoundToCrystal() && (data = DragonPosWorldData.get(this.level())) != null) {
            data.addDragon(this.getUUID(), this.blockPosition());
        }
        super.onClientRemoval();
    }

    public int maxSearchNodes() {
        return (int)this.getAttribute(Attributes.FOLLOW_RANGE).getValue();
    }

    public boolean isSmallerThanBlock() {
        return false;
    }

    public float getXZNavSize() {
        return Math.max(1.4f, this.getBbWidth() / 2.0f);
    }

    public int getYNavSize() {
        return Mth.ceil((float)this.getBbHeight());
    }

    public void containerChanged(Container invBasic) {
        if (!this.level().isClientSide) {
            this.updateAttributes();
        }
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 pDeltaMovement, float pFriction) {
        if (this.moveControl instanceof IafDragonFlightManager.PlayerFlightMoveHelper) {
            return pDeltaMovement;
        }
        return super.handleRelativeFrictionAndCalculateMovement(pDeltaMovement, pFriction);
    }

    public boolean isBlockExplicitlyPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return false;
    }

    public boolean isBlockExplicitlyNotPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return false;
    }
}

