/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.SlowPartEntity;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIAttackGoal;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIFindSandTargetGoal;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIGetInSandGoal;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIJumpGoal;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAITargetGoal;
import com.iafenvoy.iceandfire.entity.ai.DeathWormAIWanderGoal;
import com.iafenvoy.iceandfire.entity.ai.DeathwormAITargetItemsGoal;
import com.iafenvoy.iceandfire.entity.ai.EntityGroundAIRideGoal;
import com.iafenvoy.iceandfire.entity.ai.IAFLookControl;
import com.iafenvoy.iceandfire.entity.pathfinding.DeathWormLandNavigation;
import com.iafenvoy.iceandfire.entity.pathfinding.DeathWormSandNavigation;
import com.iafenvoy.iceandfire.entity.util.BlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.BlockLaunchExplosion;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.IGroundMount;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.IafEntityUtil;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.event.IafEvents;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.object.entity.collision.ICustomCollisions;
import com.iafenvoy.uranus.util.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeathWormEntity
extends TamableAnimal
implements ISyncMount,
ICustomCollisions,
BlacklistedFromStatues,
IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IGroundMount,
IHasCustomizableAttributes,
ICustomMoveController {
    public static final ResourceLocation TAN_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/deathworm_tan");
    public static final ResourceLocation WHITE_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/deathworm_white");
    public static final ResourceLocation RED_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/deathworm_red");
    public static final ResourceLocation TAN_GIANT_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/deathworm_tan_giant");
    public static final ResourceLocation WHITE_GIANT_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/deathworm_white_giant");
    public static final ResourceLocation RED_GIANT_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/deathworm_red_giant");
    public static final Animation ANIMATION_BITE = Animation.create((int)10);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(DeathWormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(DeathWormEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> JUMP_TICKS = SynchedEntityData.defineId(DeathWormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.defineId(DeathWormEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> WORM_AGE = SynchedEntityData.defineId(DeathWormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> HOME = SynchedEntityData.defineId(DeathWormEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private final LookControl lookHelper;
    public ChainBuffer tail_buffer;
    public float jumpProgress;
    public float prevJumpProgress;
    public DeathwormAITargetItemsGoal<?> targetItemsGoal;
    private int animationTick;
    private boolean willExplode = false;
    private int ticksTillExplosion = 60;
    private Animation currentAnimation;
    private final SlowPartEntity[] segments = new SlowPartEntity[7];
    private boolean isSandNavigator;
    private int growthCounter = 0;
    private Player thrower;

    public DeathWormEntity(EntityType<DeathWormEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.OPEN, 2.0f);
        this.setPathfindingMalus(PathType.WATER, 4.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
        this.lookHelper = new IAFLookControl((Mob)this);
        this.noCulling = true;
        if (worldIn.isClientSide) {
            this.tail_buffer = new ChainBuffer();
        }
        this.switchNavigator(false);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_DAMAGE, ((Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue()).doubleValue()).add(Attributes.FOLLOW_RANGE, (double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue()).add(Attributes.ARMOR, 3.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, new EntityGroundAIRideGoal<DeathWormEntity>(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new DeathWormAIAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new DeathWormAIJumpGoal(this, 12));
        this.goalSelector.addGoal(4, (Goal)new DeathWormAIFindSandTargetGoal(this, 10));
        this.goalSelector.addGoal(5, (Goal)new DeathWormAIGetInSandGoal(this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new DeathWormAIWanderGoal(this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetItemsGoal = new DeathwormAITargetItemsGoal(this, false, false);
        this.targetSelector.addGoal(4, this.targetItemsGoal);
        this.targetSelector.addGoal(5, new DeathWormAITargetGoal<LivingEntity>(this, LivingEntity.class, false, input -> {
            if (this.isTame()) {
                return input instanceof Monster;
            }
            if (input != null) {
                if (input.isInWater() || !DragonUtils.isAlive(input) || this.isOwnedBy((LivingEntity)input)) {
                    return false;
                }
                if (input instanceof Player || input instanceof Animal) {
                    return true;
                }
                return (Boolean)IafCommonConfig.INSTANCE.deathworm.attackMonsters.getValue();
            }
            return false;
        }));
    }

    @Override
    public void setConfigurableAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(Math.min(0.2, 0.15 * (double)this.getAgeScale()));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(Math.max(1.0, (Double)IafCommonConfig.INSTANCE.deathworm.attackDamage.getValue() * (double)this.getAgeScale()));
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(Math.max(6.0, (Double)IafCommonConfig.INSTANCE.deathworm.maxHealth.getValue() * (double)this.getAgeScale()));
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)((Integer)IafCommonConfig.INSTANCE.deathworm.targetSearchLength.getValue()).intValue());
    }

    public LookControl getLookControl() {
        return this.lookHelper;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public boolean getCanSpawnHere() {
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)this.getBoundingBox().minY);
        int k = Mth.floor((double)this.getZ());
        BlockPos blockpos = new BlockPos(i, j, k);
        this.level().getBlockState(blockpos.below()).is(BlockTags.SAND);
        return this.level().getBlockState(blockpos.below()).is(BlockTags.SAND) && this.level().getMaxLocalRawBrightness(blockpos) > 8;
    }

    public void onUpdateParts() {
        if (this.isRemoved()) {
            return;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] != null && !this.segments[i].isRemoved()) continue;
            this.segments[i] = new SlowPartEntity((Entity)this, -0.8f - (float)i * 0.8f, 0.0f, 0.0f, 0.7f, 0.7f, 1.0f);
            this.segments[i].copyPosition((Entity)this);
            this.segments[i].setParent((Entity)this);
            this.segments[i].updateScale(this.getAgeScale());
            this.level().addFreshEntity((Entity)this.segments[i]);
        }
        for (SlowPartEntity entity : this.segments) {
            IafEntityUtil.updatePart(entity, (LivingEntity)this);
        }
    }

    public void updateScale(float scale) {
        for (SlowPartEntity entity : this.segments) {
            if (entity == null || entity.isRemoved()) continue;
            entity.updateScale(scale);
        }
    }

    public int getBaseExperienceReward() {
        return this.getAgeScale() > 3.0f ? 20 : 10;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    private void clearSegments() {
        for (SlowPartEntity entity : this.segments) {
            if (entity == null || entity.isRemoved()) continue;
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void setExplosive(boolean explosive, Player thrower) {
        this.willExplode = true;
        this.ticksTillExplosion = 60;
        this.thrower = thrower;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.playSound(this.getAgeScale() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_ATTACK.get() : (SoundEvent)IafSounds.DEATHWORM_ATTACK.get(), 1.0f, 1.0f);
        }
        if (this.getRandom().nextInt(3) == 0 && this.getAgeScale() > 1.0f && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && !((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this, entityIn.getX(), entityIn.getY(), entityIn.getZ())) {
            BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.level(), (Mob)this, entityIn.getX(), entityIn.getY(), entityIn.getZ(), this.getAgeScale());
            explosion.explode();
            explosion.finalizeExplosion(true);
        }
        return false;
    }

    public void die(DamageSource cause) {
        this.clearSegments();
        super.die(cause);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return switch (this.getVariant()) {
            case 0 -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)(this.getAgeScale() > 3.0f ? TAN_GIANT_LOOT : TAN_LOOT));
            case 1 -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)(this.getAgeScale() > 3.0f ? RED_GIANT_LOOT : RED_LOOT));
            case 2 -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)(this.getAgeScale() > 3.0f ? WHITE_GIANT_LOOT : WHITE_LOOT));
            default -> null;
        };
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(SCALE, (Object)Float.valueOf(1.0f));
        builder.define(CONTROL_STATE, (Object)0);
        builder.define(WORM_AGE, (Object)10);
        builder.define(HOME, (Object)BlockPos.ZERO);
        builder.define(JUMP_TICKS, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant());
        compound.putInt("GrowthCounter", this.growthCounter);
        compound.putFloat("Scale", this.getDeathwormScale());
        compound.putInt("WormAge", this.getWormAge());
        compound.putLong("WormHome", this.getWormHome().asLong());
        compound.putBoolean("WillExplode", this.willExplode);
        this.clearSegments();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getInt("Variant"));
        this.growthCounter = compound.getInt("GrowthCounter");
        this.setDeathWormScale(compound.getFloat("Scale"));
        this.setWormAge(compound.getInt("WormAge"));
        this.setWormHome(BlockPos.of((long)compound.getLong("WormHome")));
        this.willExplode = compound.getBoolean("WillExplode");
        this.setConfigurableAttributes();
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.entityData.get(CONTROL_STATE);
        if (newState) {
            this.entityData.set(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.entityData.set(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.entityData.get(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.entityData.set(CONTROL_STATE, (Object)state);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getWormJumping() {
        return (Integer)this.entityData.get(JUMP_TICKS);
    }

    public void setWormJumping(int jump) {
        this.entityData.set(JUMP_TICKS, (Object)jump);
    }

    public BlockPos getWormHome() {
        return (BlockPos)this.entityData.get(HOME);
    }

    public void setWormHome(BlockPos home) {
        if (home instanceof BlockPos) {
            this.entityData.set(HOME, (Object)home);
        }
    }

    public int getWormAge() {
        return Math.max(1, (Integer)this.entityData.get(WORM_AGE));
    }

    public void setWormAge(int age) {
        this.entityData.set(WORM_AGE, (Object)age);
    }

    public float getAgeScale() {
        return Math.min(this.getDeathwormScale() * ((float)this.getWormAge() / 5.0f), 7.0f);
    }

    public float getDeathwormScale() {
        float scale = ((Float)this.entityData.get(SCALE)).floatValue();
        if (scale == 0.0f) {
            scale = (float)RandomHelper.nextDouble((double)1.0, (double)7.0);
            this.setDeathWormScale(scale);
        }
        return scale;
    }

    public void setDeathWormScale(float scale) {
        this.entityData.set(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
        this.updateScale(scale * ((float)this.getWormAge() / 5.0f));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setVariant(this.getRandom().nextInt(3));
        float size = 0.25f + (float)(Math.random() * (double)0.35f);
        this.setDeathWormScale(this.getRandom().nextInt(20) == 0 ? size * 4.0f : size);
        return spawnDataIn;
    }

    public void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
        if (this.hasPassenger(passenger)) {
            this.setYBodyRot(passenger.getYRot());
            float radius = -0.5f * this.getAgeScale();
            float angle = (float)Math.PI / 180 * this.yBodyRot;
            double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.cos((float)angle);
            passenger.setPos(this.getX() + extraX, this.getY() + (double)this.getEyeHeight() - (double)0.55f, this.getZ() + extraZ);
        }
    }

    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.getPassengers()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            return player;
        }
        return null;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.getWormAge() > 4 && player.getVehicle() == null && (player.getMainHandItem().is(Items.FISHING_ROD) || player.getOffhandItem().is(Items.FISHING_ROD))) {
            player.startRiding((Entity)this);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    private void switchNavigator(boolean inSand) {
        if (inSand) {
            this.moveControl = new SandMoveHelper();
            this.navigation = new DeathWormSandNavigation(this, this.level());
            this.isSandNavigator = true;
        } else {
            this.moveControl = new MoveControl((Mob)this);
            this.navigation = new DeathWormLandNavigation(this, this.level());
            this.isSandNavigator = false;
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_WALL) || source.is(DamageTypes.FALLING_BLOCK)) {
            return false;
        }
        if (this.isVehicle() && source.getEntity() != null && this.getControllingPassenger() != null && source.getEntity() == this.getControllingPassenger()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void move(MoverType typeIn, Vec3 pos) {
        super.move(typeIn, pos);
    }

    public boolean isInWall() {
        return !this.isInSand() && super.isInWall();
    }

    protected void moveTowardsClosestSpace(double x, double y, double z) {
        Vec3 blockpos = new Vec3(x, y, z);
        Vec3i vec3i = new Vec3i((int)Math.round(blockpos.x()), (int)Math.round(blockpos.y()), (int)Math.round(blockpos.z()));
        Vec3 vector3d = new Vec3(x - blockpos.x(), y - blockpos.y(), z - blockpos.z());
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.setWithOffset(vec3i, dir);
            if (this.level().getBlockState((BlockPos)blockpos$mutable).isCollisionShapeFullBlock((BlockGetter)this.level(), (BlockPos)blockpos$mutable) && !this.level().getBlockState((BlockPos)blockpos$mutable).is(BlockTags.SAND)) continue;
            double d1 = vector3d.get(dir.getAxis());
            double d = d2 = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = dir;
        }
        float f = this.random.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.getAxisDirection().getStep();
        Vec3 vector3d1 = this.getDeltaMovement().scale(0.75);
        if (direction.getAxis() == Direction.Axis.X) {
            this.setDeltaMovement(f1 * f, vector3d1.y, vector3d1.z);
        } else if (direction.getAxis() == Direction.Axis.Y) {
            this.setDeltaMovement(vector3d1.x, f1 * f, vector3d1.z);
        } else if (direction.getAxis() == Direction.Axis.Z) {
            this.setDeltaMovement(vector3d1.x, vector3d1.y, f1 * f);
        }
    }

    private void updateAttributes() {
        this.setConfigurableAttributes();
        this.setHealth((float)this.getAttribute(Attributes.MAX_HEALTH).getBaseValue());
    }

    public boolean killedEntity(ServerLevel world, LivingEntity entity) {
        if (this.isTame()) {
            this.heal(14.0f);
            return false;
        }
        return true;
    }

    public boolean isAlliedTo(Entity entityIn) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                TamableAnimal tameable = (TamableAnimal)entityIn;
                return tameable.isOwnedBy(livingentity);
            }
            if (livingentity != null) {
                return livingentity.isAlliedTo(entityIn);
            }
        }
        return super.isAlliedTo(entityIn);
    }

    public void aiStep() {
        super.aiStep();
        this.prevJumpProgress = this.jumpProgress;
        if (this.getWormJumping() > 0 && this.jumpProgress < 5.0f) {
            this.jumpProgress += 1.0f;
        }
        if (this.getWormJumping() == 0 && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 1.0f;
        }
        if (this.isInSand() && this.horizontalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.05, 0.0));
        }
        if (this.getWormJumping() > 0) {
            float f2 = (float)(-((double)((float)this.getDeltaMovement().y) * 57.2957763671875));
            this.setXRot(f2);
            if (this.isInSand() || this.onGround()) {
                this.setWormJumping(this.getWormJumping() - 1);
            }
        }
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.getTarget() instanceof Player) {
            this.setTarget(null);
        }
        if (!(this.getTarget() == null || this.getTarget().isAlive() && DragonUtils.isAlive(this.getTarget()))) {
            this.setTarget(null);
        }
        if (this.willExplode) {
            if (this.ticksTillExplosion == 0) {
                if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this, this.getX(), this.getY(), this.getZ())) {
                    this.level().explode((Entity)this.thrower, this.getX(), this.getY(), this.getZ(), 2.5f * this.getAgeScale(), false, Level.ExplosionInteraction.MOB);
                }
                this.thrower = null;
            } else {
                --this.ticksTillExplosion;
            }
        }
        if (this.isInSandStrict()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.08, 0.0));
        }
        if (this.growthCounter > 1000 && this.getWormAge() < 5) {
            this.growthCounter = 0;
            this.setWormAge(Math.min(5, this.getWormAge() + 1));
            this.clearSegments();
            this.heal(15.0f);
            this.setDeathWormScale(this.getDeathwormScale());
            if (this.level().isClientSide) {
                int i = 0;
                while ((float)i < 10.0f * this.getAgeScale()) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), (double)((float)this.getSurface((int)Math.floor(this.getX()), (int)Math.floor(this.getY()), (int)Math.floor(this.getZ())) + 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
                    ++i;
                }
            }
        }
        if (this.getWormAge() < 5) {
            ++this.growthCounter;
        }
        if (this.getControllingPassenger() != null && this.getTarget() != null) {
            this.getNavigation().stop();
            this.setTarget(null);
        }
        if (this.getTarget() != null && (double)this.distanceTo((Entity)this.getTarget()) < Math.min(4.0, 4.0 * (double)this.getAgeScale()) && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            float f = (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            this.getTarget().hurt(this.level().damageSources().mobAttack((LivingEntity)this), f);
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)-0.4f, 0.0));
        }
    }

    public int getWormBrightness(boolean sky) {
        Vec3 vec3 = this.getEyePosition(1.0f);
        BlockPos eyePos = BlockPos.containing((Position)vec3);
        while (eyePos.getY() < 256 && !this.level().isEmptyBlock(eyePos)) {
            eyePos = eyePos.above();
        }
        return this.level().getBrightness(sky ? LightLayer.SKY : LightLayer.BLOCK, eyePos.above());
    }

    public int getSurface(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        while (!this.level().isEmptyBlock(pos)) {
            pos = pos.above();
        }
        return pos.getY();
    }

    protected SoundEvent getAmbientSound() {
        return this.getAgeScale() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_IDLE.get() : (SoundEvent)IafSounds.DEATHWORM_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.getAgeScale() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_HURT.get() : (SoundEvent)IafSounds.DEATHWORM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return this.getAgeScale() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_DIE.get() : (SoundEvent)IafSounds.DEATHWORM_DIE.get();
    }

    public void tick() {
        boolean inSand;
        super.tick();
        this.refreshDimensions();
        this.onUpdateParts();
        if (this.tickCount == 1) {
            this.updateScale(this.getAgeScale());
        }
        if (this.attack() && this.getControllingPassenger() != null && this.getControllingPassenger() instanceof Player) {
            LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, this.getControllingPassenger(), 3.0);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
                this.playSound(this.getAgeScale() > 3.0f ? (SoundEvent)IafSounds.DEATHWORM_GIANT_ATTACK.get() : (SoundEvent)IafSounds.DEATHWORM_ATTACK.get(), 1.0f, 1.0f);
                if (this.getRandom().nextInt(3) == 0 && this.getAgeScale() > 1.0f) {
                    float radius = 1.5f * this.getAgeScale();
                    float angle = (float)Math.PI / 180 * this.yBodyRot;
                    double extraX = radius * Mth.sin((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * Mth.cos((float)angle);
                    BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.level(), (Mob)this, this.getX() + extraX, this.getY() - (double)this.getEyeHeight(), this.getZ() + extraZ, this.getAgeScale() * 0.75f);
                    explosion.explode();
                    explosion.finalizeExplosion(true);
                }
            }
            if (target != null) {
                target.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
            }
        }
        if (this.isInSand()) {
            BlockPos pos = new BlockPos(this.getBlockX(), this.getSurface(this.getBlockX(), this.getBlockY(), this.getBlockZ()), this.getBlockZ()).below();
            BlockState state = this.level().getBlockState(pos);
            if (state.isSolidRender((BlockGetter)this.level(), pos) && this.level().isClientSide) {
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), (double)((float)this.getSurface((int)Math.floor(this.getX()), (int)Math.floor(this.getY()), (int)Math.floor(this.getZ())) + 0.5f), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
            }
            if (this.tickCount % 10 == 0) {
                this.playSound(SoundEvents.SAND_BREAK, 1.0f, 0.5f);
            }
        }
        if (this.up() && this.onGround()) {
            this.jumpFromGround();
        }
        boolean bl = inSand = this.isInSand() || this.getControllingPassenger() == null;
        if (inSand && !this.isSandNavigator) {
            this.switchNavigator(true);
        }
        if (!inSand && this.isSandNavigator) {
            this.switchNavigator(false);
        }
        if (this.level().isClientSide) {
            this.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (LivingEntity)this);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean up() {
        return ((Byte)this.entityData.get(CONTROL_STATE) & 1) == 1;
    }

    public boolean dismountIAF() {
        return ((Byte)this.entityData.get(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.entityData.get(CONTROL_STATE) >> 2 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(1, dismount);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
    }

    public boolean isSandBelow() {
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)(this.getY() + 1.0));
        int k = Mth.floor((double)this.getZ());
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState BlockState2 = this.level().getBlockState(blockpos);
        return BlockState2.is(BlockTags.SAND);
    }

    public boolean isInSand() {
        return this.getControllingPassenger() == null && this.isInSandStrict();
    }

    public boolean isInSandStrict() {
        return this.level().getBlockState(this.blockPosition()).is(BlockTags.SAND);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public Entity[] getWormParts() {
        return this.segments;
    }

    public int getMaxHeadYRot() {
        return 10;
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean canPassThrough(BlockPos pos, BlockState state, VoxelShape shape) {
        return this.level().getBlockState(pos).is(BlockTags.SAND);
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRidingPlayer(Player player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().getUUID().equals(player.getUUID());
    }

    @Override
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    @Override
    public double getRideSpeedModifier() {
        return this.isInSand() ? 1.5 : 1.0;
    }

    public double processRiderY(double y) {
        return this.isInSand() ? y + (double)0.2f : y;
    }

    public class SandMoveHelper
    extends MoveControl {
        private final DeathWormEntity worm;

        public SandMoveHelper() {
            super((Mob)DeathWormEntity.this);
            this.worm = DeathWormEntity.this;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                double d1 = this.wantedY - this.worm.getY();
                double d2 = this.wantedZ - this.worm.getZ();
                Vec3 Vector3d = new Vec3(this.wantedX - this.worm.getX(), this.wantedY - this.worm.getY(), this.wantedZ - this.worm.getZ());
                double d0 = Vector3d.length();
                if (d0 < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                } else {
                    this.speedModifier = 1.0;
                    this.worm.setDeltaMovement(this.worm.getDeltaMovement().add(Vector3d.scale(this.speedModifier * 0.05 / d0)));
                    Vec3 Vector3d1 = this.worm.getDeltaMovement();
                    this.worm.setYRot(-((float)Mth.atan2((double)Vector3d1.x, (double)Vector3d1.z)) * 57.295776f);
                }
            }
        }
    }
}

