/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.item;

import com.github.eterdelta.crittersandcompanions.platform.Services;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class PearlNecklaceItem
extends Item {
    private final int level;

    private static Stream<ItemStack> getEquipment(Player player) {
        return Stream.of(player.getInventory().items.stream(), Services.PLATFORM.getAdditionalEquipment(player)).flatMap(Function.identity());
    }

    public static Optional<PearlNecklaceItem> getWearing(Entity entity) {
        if (!(entity instanceof Player)) {
            return Optional.empty();
        }
        Player player = (Player)entity;
        return PearlNecklaceItem.getEquipment(player).map(ItemStack::getItem).filter(it -> it instanceof PearlNecklaceItem).map(it -> (PearlNecklaceItem)((Object)it)).max(Comparator.comparing(PearlNecklaceItem::getLevel));
    }

    public PearlNecklaceItem(Item.Properties properties, int necklaceLevel) {
        super(properties);
        this.level = necklaceLevel;
    }

    private String percentage(int level, double base) {
        return String.format("%.0f", (double)(level * 100) * base);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)"pearl_necklace.level", (Object[])new Object[]{this.level}).withStyle(ChatFormatting.DARK_GRAY));
        components.add((Component)Component.empty());
        components.add((Component)Component.translatable((String)"pearl_necklace.swim_speed", (Object[])new Object[]{this.percentage(this.level, (Double)Services.CONFIGS.common().necklaceSwimSpeed.get())}).withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.translatable((String)"pearl_necklace.drowned_range", (Object[])new Object[]{this.percentage(this.level, (Double)Services.CONFIGS.common().necklaceDrownedDebuff.get())}).withStyle(ChatFormatting.GRAY));
        if (this.level > 1) {
            components.add((Component)Component.translatable((String)"pearl_necklace.guardian_range", (Object[])new Object[]{this.percentage(this.level, (Double)Services.CONFIGS.common().necklaceGuardianDebuff.get())}).withStyle(ChatFormatting.GRAY));
        }
    }

    public int getLevel() {
        return this.level;
    }
}

