/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import toastysmobs.init.ToastysmobsModEntities;
import toastysmobs.procedures.DoDoOnInitialEntitySpawnProcedure;
import toastysmobs.procedures.DoDoRightClickedOnEntityProcedure;
import toastysmobs.procedures.DoDoSittingAnimationProcedure;
import toastysmobs.procedures.DodosittingaicontrolProcedure;
import toastysmobs.procedures.IsentityflyingProcedure;

public class DoDoEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Boolean> DATA_sitting = SynchedEntityData.defineId(DoDoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_variant = SynchedEntityData.defineId(DoDoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public DoDoEntity(EntityType<DoDoEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_sitting, (Object)false);
        builder.define(DATA_variant, (Object)1);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7){

            public boolean canUse() {
                double x = DoDoEntity.this.getX();
                double y = DoDoEntity.this.getY();
                double z = DoDoEntity.this.getZ();
                DoDoEntity entity = DoDoEntity.this;
                Level world = DoDoEntity.this.level();
                return super.canUse() && DodosittingaicontrolProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = DoDoEntity.this.getX();
                double y = DoDoEntity.this.getY();
                double z = DoDoEntity.this.getZ();
                DoDoEntity entity = DoDoEntity.this;
                Level world = DoDoEntity.this.level();
                return super.canUse() && DodosittingaicontrolProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.7f){

            public boolean canUse() {
                double x = DoDoEntity.this.getX();
                double y = DoDoEntity.this.getY();
                double z = DoDoEntity.this.getZ();
                DoDoEntity entity = DoDoEntity.this;
                Level world = DoDoEntity.this.level();
                return super.canUse() && DodosittingaicontrolProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new FollowOwnerGoal(this, 0.7, 10.0f, 2.0f){

            public boolean canUse() {
                double x = DoDoEntity.this.getX();
                double y = DoDoEntity.this.getY();
                double z = DoDoEntity.this.getZ();
                DoDoEntity entity = DoDoEntity.this;
                Level world = DoDoEntity.this.level();
                return super.canUse() && DodosittingaicontrolProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 0.5, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOW_BERRIES}), false){

            public boolean canUse() {
                double x = DoDoEntity.this.getX();
                double y = DoDoEntity.this.getY();
                double z = DoDoEntity.this.getZ();
                DoDoEntity entity = DoDoEntity.this;
                Level world = DoDoEntity.this.level();
                return super.canUse() && DodosittingaicontrolProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 0.7));
        this.targetSelector.addGoal(8, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = DoDoEntity.this.getX();
                double y = DoDoEntity.this.getY();
                double z = DoDoEntity.this.getZ();
                DoDoEntity entity = DoDoEntity.this;
                Level world = DoDoEntity.this.level();
                return super.canUse() && DodosittingaicontrolProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"toastysmobs:caw"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"toastysmobs:caw"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"toastysmobs:caw"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        DoDoOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datasitting", ((Boolean)this.entityData.get(DATA_sitting)).booleanValue());
        compound.putInt("Datavariant", ((Integer)this.entityData.get(DATA_variant)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datasitting")) {
            this.entityData.set(DATA_sitting, (Object)compound.getBoolean("Datasitting"));
        }
        if (compound.contains("Datavariant")) {
            this.entityData.set(DATA_variant, (Object)compound.getInt("Datavariant"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        DoDoEntity entity = this;
        Level world = this.level();
        DoDoRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(DoDoSittingAnimationProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(IsentityflyingProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ()), this.tickCount);
        }
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        DoDoEntity retval = (DoDoEntity)((EntityType)ToastysmobsModEntities.DO_DO.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.GLOW_BERRIES)}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.5);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

