/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import toastysmobs.client.model.ModelSnail;
import toastysmobs.client.model.animations.SnailAnimation;
import toastysmobs.client.model.animations.SnailLowAnimation;
import toastysmobs.entity.SnailEntity;

public class SnailRenderer
extends MobRenderer<SnailEntity, ModelSnail<SnailEntity>> {
    public SnailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelSnail.LAYER_LOCATION)), 0.3f);
    }

    protected void scale(SnailEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(SnailEntity entity) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/snail1.png");
    }

    private static final class AnimatedModel
    extends ModelSnail<SnailEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SnailEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SnailEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, SnailAnimation.snailmove, ageInTicks, 1.0f);
                this.animate(entity.animationState1, SnailLowAnimation.lowhealth, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SnailEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

