/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import toastysmobs.client.model.Modelbear;
import toastysmobs.entity.BearEntity;
import toastysmobs.procedures.BearDisplayConditionProcedure;
import toastysmobs.procedures.BearWinnieThePoohDisplayConditionProcedure;

public class BearRenderer
extends MobRenderer<BearEntity, Modelbear<BearEntity>> {
    public BearRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelbear(context.bakeLayer(Modelbear.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<BearEntity, Modelbear<BearEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/bear_texture_angry.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, BearEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (BearDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                    Modelbear model = new Modelbear(Minecraft.getInstance().getEntityModels().bakeLayer(Modelbear.LAYER_LOCATION));
                    ((Modelbear)this.getParentModel()).copyPropertiesTo(model);
                    model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                    model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<BearEntity, Modelbear<BearEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/winnie_bear_texture.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, BearEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (BearWinnieThePoohDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    Modelbear model = new Modelbear(Minecraft.getInstance().getEntityModels().bakeLayer(Modelbear.LAYER_LOCATION));
                    ((Modelbear)this.getParentModel()).copyPropertiesTo(model);
                    model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                    model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(BearEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(BearEntity entity) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/bear_texture.png");
    }
}

