/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.snowpig.common.entities;

import com.uraneptus.snowpig.SnowPigMod;
import com.uraneptus.snowpig.core.ModIntegrations;
import com.uraneptus.snowpig.core.registry.SPEntityTypes;
import com.uraneptus.snowpig.core.registry.SPSounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SnowPig
extends Pig {
    public static final ResourceKey<LootTable> FROZEN_HAM_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)SnowPigMod.modPrefix("entities/mod_integration/frozen_ham_loot"));

    public SnowPig(EntityType<? extends SnowPig> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.ARMOR, 0.5);
    }

    @NotNull
    public ResourceKey<LootTable> getDefaultLootTable() {
        if (ModIntegrations.IS_FD_LOADED.booleanValue()) {
            return FROZEN_HAM_LOOT;
        }
        return super.getDefaultLootTable();
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
    }

    protected SoundEvent getAmbientSound() {
        return SPSounds.SNOW_PIG_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SPSounds.SNOW_PIG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return SPSounds.SNOW_PIG_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SPSounds.SNOW_PIG_STEP.get(), 0.15f, 1.0f);
    }

    public boolean canFreeze() {
        return false;
    }

    public SnowPig getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        return (SnowPig)SPEntityTypes.SNOW_PIG.get().create((Level)level);
    }
}

