/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.gui.widget;

import immersive_melodies.client.gui.ImmersiveMelodiesScreen;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MelodyListWidget
extends ObjectSelectionList<MelodyEntry> {
    private final ImmersiveMelodiesScreen currentScreen;
    private final boolean showSelection;

    public MelodyListWidget(Minecraft client, ImmersiveMelodiesScreen currentScreen, int left, int width, int listY, int listH, boolean showSelection) {
        super(client, width, listH, listY, 10);
        this.currentScreen = currentScreen;
        this.setX(left);
        this.showSelection = showSelection;
        this.setRenderHeader(false, 0);
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    public void clearEntries() {
        super.clearEntries();
    }

    public void addEntry(ResourceLocation identifier, Component name, Runnable onPress) {
        super.addEntry((AbstractSelectionList.Entry)new MelodyEntry(identifier, name, onPress));
    }

    public void replaceEntries(Collection<MelodyEntry> newEntries) {
        super.replaceEntries(newEntries);
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width + 2;
    }

    public int getRowWidth() {
        return this.width;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth() + this.width + 10) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight());
    }

    protected void enableScissor(GuiGraphics context) {
        context.enableScissor(this.getX() - 15, this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    protected void renderSelection(GuiGraphics context, int y, int entryWidth, int entryHeight, int borderColor, int fillColor) {
        if (this.showSelection) {
            context.fill(this.getX() - 1, y - 1, this.getX() + this.width, y + entryHeight + 3, 0x40000000);
        }
    }

    public class MelodyEntry
    extends ObjectSelectionList.Entry<MelodyEntry> {
        final ResourceLocation identifier;
        final Component name;
        final Runnable onPress;

        public MelodyEntry(ResourceLocation identifier, Component melody, Runnable onPress) {
            this.identifier = identifier;
            this.name = melody;
            this.onPress = onPress;
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.drawString(MelodyListWidget.this.currentScreen.getTextRenderer(), this.name, MelodyListWidget.this.getX() + (this.onPress == null ? -2 : 2), y + 1, 0x404040, false);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && this.onPress != null) {
                this.onPress.run();
                return true;
            }
            return false;
        }

        public Component getNarration() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MelodyEntry)) {
                return false;
            }
            MelodyEntry that = (MelodyEntry)((Object)o);
            return Objects.equals(this.identifier, that.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.identifier);
        }
    }
}

