/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.gui;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.client.gui.ImmersiveMelodiesFreePlayingScreen;
import immersive_melodies.client.gui.widget.MelodyListWidget;
import immersive_melodies.client.gui.widget.TexturedButtonWidget;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.network.Network;
import immersive_melodies.network.PacketSplitter;
import immersive_melodies.network.c2s.ItemActionMessage;
import immersive_melodies.network.c2s.MelodyDeleteRequest;
import immersive_melodies.network.c2s.TrackToggleMessage;
import immersive_melodies.resources.ClientMelodyManager;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.Track;
import immersive_melodies.util.MidiConverter;
import immersive_melodies.util.MidiParser;
import immersive_melodies.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ImmersiveMelodiesScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_TEXTURE = Common.locate("textures/gui/paper.png");
    private MelodyListWidget list;
    private MelodyListWidget trackList;
    private EditBox search;
    private Component error;
    private long lastError;
    private boolean showTrackSelection;
    private List<Integer> enabledTracks = new ArrayList<Integer>();
    private ResourceLocation selected;

    private void setError(Component error) {
        this.error = error;
        this.lastError = System.currentTimeMillis();
        this.search.setValue("");
        this.search.setSuggestion(null);
    }

    public ImmersiveMelodiesScreen() {
        super((Component)Component.translatable((String)"itemGroup.immersive_melodies.immersive_melodies_tab"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        ItemStack stack;
        this.search = new EditBox(this.font, this.width / 2 - 70, this.height / 2 - 103, 140, 20, (Component)Component.translatable((String)"immersive_melodies.search"));
        this.search.setMaxLength(128);
        this.search.setResponder(search -> {
            this.refreshPage();
            this.search.setSuggestion(null);
        });
        this.search.setBordered(false);
        this.search.setTextColor(0x808080);
        this.search.setSuggestion("Search");
        this.setInitialFocus((GuiEventListener)this.search);
        int y = (this.height - 230) / 2 + 22;
        this.list = new MelodyListWidget(this.minecraft, this, this.width / 2 - 75, 150, y, 162, true);
        this.trackList = new MelodyListWidget(this.minecraft, this, this.width / 2 + 100, 85, y + 8, 142, false);
        this.refreshPage();
        if (this.minecraft != null && this.minecraft.player != null && (stack = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof InstrumentItem) {
            this.selected = InstrumentItem.getMelody(stack);
        }
    }

    private void updateTrackList() {
        if (this.minecraft != null && this.minecraft.player != null) {
            ItemStack stack = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
            Item item = stack.getItem();
            if (item instanceof InstrumentItem) {
                InstrumentItem item2 = (InstrumentItem)item;
                List<Integer> newEnabledTracks = item2.getEnabledTracks(stack);
                if (!Objects.equals(newEnabledTracks, this.enabledTracks)) {
                    this.enabledTracks = new ArrayList<Integer>(newEnabledTracks);
                    this.refreshPage();
                }
            } else {
                this.enabledTracks = new ArrayList<Integer>();
            }
        }
    }

    private void openHelp() {
        try {
            Util.getPlatform().openUri(URI.create("https://github.com/Luke100000/ImmersiveMelodies/wiki/Custom-Melodies"));
        }
        catch (Exception e) {
            Common.LOGGER.error((Object)e);
        }
    }

    public void onFilesDrop(List<Path> paths) {
        PathMatcher midiMatcher = FileSystems.getDefault().getPathMatcher("glob:*{.mid,.midi,.MID,.MIDI}");
        PathMatcher abcMatcher = FileSystems.getDefault().getPathMatcher("glob:*{.abc,.ABC}");
        for (Path path : paths) {
            try {
                String rawName = path.getFileName().toString();
                String name = rawName.substring(0, rawName.lastIndexOf(46));
                if (midiMatcher.matches(path.getFileName())) {
                    FileInputStream inputStream = new FileInputStream(path.toFile());
                    this.parseMidi(name, inputStream);
                    continue;
                }
                if (abcMatcher.matches(path.getFileName())) {
                    byte[] bytes = Files.readAllBytes(path);
                    Minecraft.getInstance().execute(() -> {
                        try {
                            MidiConverter.Response request = MidiConverter.request(bytes);
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(request.getBody());
                            this.parseMidi(name, inputStream);
                        }
                        catch (Exception e) {
                            Common.LOGGER.error((Object)e);
                            this.setError((Component)Component.translatable((String)"immersive_melodies.error.empty"));
                        }
                    });
                    continue;
                }
                this.setError((Component)Component.translatable((String)"immersive_melodies.error.unknown_file_type"));
            }
            catch (Exception e) {
                Common.LOGGER.error((Object)e);
                this.setError((Component)Component.literal((String)e.getLocalizedMessage()));
            }
        }
    }

    private void parseMidi(String name, InputStream inputStream) {
        Melody melody;
        if (name.isEmpty()) {
            name = "empty";
        }
        if (!(melody = MidiParser.parseMidi(inputStream, name)).getTracks().isEmpty()) {
            PacketSplitter.sendToServer(name, melody);
            this.search.setValue(name);
            this.list.setScrollAmount(0.0);
        } else {
            this.setError((Component)Component.translatable((String)"immersive_melodies.error.empty"));
        }
    }

    public void tick() {
        super.tick();
        this.updateTrackList();
    }

    protected void renderMenuBackground(GuiGraphics context, int x, int y, int width, int height) {
        int cx = (this.width - 192) / 2;
        int cy = (this.height - 230) / 2;
        if (this.showTrackSelection) {
            int overlap = 10;
            int trackListWidth = 75;
            context.blit(BACKGROUND_TEXTURE, cx + 192 - overlap, cy + 8, 0, 0, 32, 100);
            context.blit(BACKGROUND_TEXTURE, cx + 192 - overlap, cy + 108, 0, 115, 32, 100);
            context.blit(BACKGROUND_TEXTURE, cx + 192 - overlap + 32, cy + 8, 192 - overlap - trackListWidth, 0, overlap + trackListWidth, 100);
            context.blit(BACKGROUND_TEXTURE, cx + 192 - overlap + 32, cy + 108, 192 - overlap - trackListWidth, 115, overlap + trackListWidth, 100);
            context.drawString(this.font, (Component)Component.translatable((String)"immersive_melodies.tracks"), width / 2 + 100, height / 2 - 94, 0, false);
        }
        context.blit(BACKGROUND_TEXTURE, cx, cy, 0, 0, 192, 215);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!Config.getInstance().clickedHelp) {
            context.renderTooltip(this.font, (Component)Component.translatable((String)"immersive_melodies.read"), this.width / 2 + 55, this.height / 2 + 69 + 17);
        }
        if (this.error != null && System.currentTimeMillis() - this.lastError < 5000L) {
            context.drawCenteredString(this.font, this.error, this.width / 2, this.height / 2 - 103, 0xFF0000);
        }
        super.render(context, mouseX, mouseY, delta);
    }

    public void refreshPage() {
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)this.search);
        this.addRenderableWidget((GuiEventListener)this.list);
        this.list.clearEntries();
        Object lastPath = "";
        for (Map.Entry entry : ClientMelodyManager.getMelodiesList().entrySet().stream().filter(e -> this.search.getValue().isEmpty() || ((MelodyDescriptor)e.getValue()).getName().toLowerCase(Locale.ROOT).contains(this.search.getValue().toLowerCase(Locale.ROOT))).sorted((a, b) -> {
            int primarySortB;
            int primarySortA = ImmersiveMelodiesScreen.getSortIndex(a);
            if (primarySortA != (primarySortB = ImmersiveMelodiesScreen.getSortIndex(b))) {
                return primarySortB - primarySortA;
            }
            return ((ResourceLocation)a.getKey()).compareTo((ResourceLocation)b.getKey());
        }).toList()) {
            String dir = Utils.removeLastPart(((ResourceLocation)entry.getKey()).getPath(), "/");
            String path = ((ResourceLocation)entry.getKey()).getNamespace() + "/" + dir;
            if (!path.equals(lastPath)) {
                this.list.addEntry(ResourceLocation.parse((String)path), (Component)Component.literal((String)dir).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY), null);
                lastPath = path;
            }
            String key = ((ResourceLocation)entry.getKey()).getPath().replace(".midi", "").replace(".mid", "");
            String[] split = key.split("/", 2);
            MutableComponent name = Component.translatableWithFallback((String)("immersive_melodies.melodies." + split[split.length - 1]), (String)((MelodyDescriptor)entry.getValue()).getName());
            this.list.addEntry((ResourceLocation)entry.getKey(), (Component)name, () -> {
                Network.sendToServer(ItemActionMessage.fromStateAndMelody(ItemActionMessage.State.PLAY, (ResourceLocation)entry.getKey()));
                this.selected = (ResourceLocation)entry.getKey();
                this.refreshPage();
            });
            if (!((ResourceLocation)entry.getKey()).equals((Object)this.selected)) continue;
            this.list.setSelected((AbstractSelectionList.Entry)((MelodyListWidget.MelodyEntry)((Object)this.list.children().getLast())));
        }
        this.trackList.clearEntries();
        if (this.selected != null && this.showTrackSelection) {
            this.addRenderableWidget((GuiEventListener)this.trackList);
            Melody melody = ClientMelodyManager.getMelody(this.selected);
            if (melody != Melody.DEFAULT) {
                for (int i = 0; i < melody.getTracks().size(); ++i) {
                    Track track = melody.getTracks().get(i);
                    int trackId = i;
                    this.trackList.addEntry(ResourceLocation.parse((String)(this.selected.getPath() + "/" + i)), (Component)Component.translatable((String)track.getName()).withStyle(this.enabledTracks.contains(i) ? ChatFormatting.DARK_GRAY : ChatFormatting.STRIKETHROUGH), () -> {
                        boolean enabled = this.enabledTracks.contains(trackId);
                        Network.sendToServer(new TrackToggleMessage(this.selected, trackId, !enabled));
                        this.refreshPage();
                    });
                }
            }
        }
        this.list.setScrollAmount(this.list.getScrollAmount());
        int y = this.height / 2 + 69;
        this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 - 75, y, 16, 16, BACKGROUND_TEXTURE, 240, 0, 256, 256, Component.nullToEmpty(null), button -> this.onClose(), () -> List.of(Component.translatable((String)"immersive_melodies.close").getVisualOrderText())));
        if (this.selected != null) {
            this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 - 55, y, 16, 16, BACKGROUND_TEXTURE, 208, 16, 256, 256, Component.nullToEmpty(null), button -> {
                this.showTrackSelection = !this.showTrackSelection;
                this.refreshPage();
            }, () -> List.of(Component.translatable((String)"immersive_melodies.tracks").getVisualOrderText())));
        }
        this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 - 33, y, 16, 16, BACKGROUND_TEXTURE, 208, 0, 256, 256, Component.nullToEmpty(null), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new ImmersiveMelodiesFreePlayingScreen());
            }
        }, () -> List.of(Component.translatable((String)"immersive_melodies.keyboard").getVisualOrderText())));
        this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 - 8, y, 16, 16, BACKGROUND_TEXTURE, 224, 32, 256, 256, Component.nullToEmpty(null), button -> Network.sendToServer(ItemActionMessage.fromState(ItemActionMessage.State.PAUSE)), () -> List.of(Component.translatable((String)"immersive_melodies.pause").getVisualOrderText())));
        this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 + 8, y, 16, 16, BACKGROUND_TEXTURE, 240, 32, 256, 256, Component.nullToEmpty(null), button -> Network.sendToServer(ItemActionMessage.fromState(ItemActionMessage.State.CONTINUE)), () -> List.of(Component.translatable((String)"immersive_melodies.play").getVisualOrderText())));
        if (this.selected != null && Utils.canDelete(this.selected, (Player)Minecraft.getInstance().player)) {
            this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 + 30, y, 16, 16, BACKGROUND_TEXTURE, 240, 16, 256, 256, Component.nullToEmpty(null), button -> {
                Network.sendToServer(new MelodyDeleteRequest(this.selected));
                this.selected = null;
            }, () -> List.of(Component.translatable((String)"immersive_melodies.delete").getVisualOrderText())));
        }
        this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 + 50, y, 16, 16, BACKGROUND_TEXTURE, 208, 32, 256, 256, Component.nullToEmpty(null), button -> {
            this.openHelp();
            if (!Config.getInstance().clickedHelp) {
                Config.getInstance().clickedHelp = true;
                Config.getInstance().save();
            }
        }, () -> List.of(Component.translatable((String)"immersive_melodies.help").getVisualOrderText())));
    }

    private static int getSortIndex(Map.Entry<ResourceLocation, MelodyDescriptor> entry) {
        return Utils.ownsMelody(entry.getKey(), (Player)Minecraft.getInstance().player) ? 2 : (Utils.isPlayerMelody(entry.getKey()) ? 0 : 1);
    }

    public Font getTextRenderer() {
        return this.font;
    }
}

