/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.animation;

import immersive_melodies.client.MelodyProgress;
import immersive_melodies.client.MelodyProgressManager;
import immersive_melodies.client.animation.ItemAnimators;
import immersive_melodies.client.animation.accessors.ModelAccessor;
import immersive_melodies.item.InstrumentItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EntityModelAnimator {
    public static Item getInstrument(LivingEntity entity) {
        for (ItemStack handItem : entity.getHandSlots()) {
            if (!(handItem.getItem() instanceof InstrumentItem)) continue;
            return handItem.getItem();
        }
        return null;
    }

    private static boolean isInMainHand(LivingEntity entity) {
        return entity.getMainHandItem().getItem() instanceof InstrumentItem;
    }

    @Deprecated
    public static ModelPart getLeftArm(HumanoidModel<?> model, LivingEntity entity) {
        return EntityModelAnimator.isInMainHand(entity) ? model.leftArm : model.rightArm;
    }

    @Deprecated
    public static ModelPart getRightArm(HumanoidModel<?> model, LivingEntity entity) {
        return EntityModelAnimator.isInMainHand(entity) ? model.rightArm : model.leftArm;
    }

    public static <T extends LivingEntity> void setAngles(ModelAccessor<T> accessor) {
        LivingEntity entity = (LivingEntity)accessor.getEntity();
        Item item = EntityModelAnimator.getInstrument(entity);
        if (item != null) {
            float time = (Minecraft.getInstance().isPaused() ? 0.0f : (float)Minecraft.getInstance().getFrameTimeNs() / 1.0E9f) + (float)entity.tickCount;
            MelodyProgress progress = MelodyProgressManager.INSTANCE.getProgress((Entity)entity);
            progress.visualTick(time);
            ItemAnimators.get(BuiltInRegistries.ITEM.getKey((Object)item)).setAngles(accessor, progress, time);
        }
    }
}

