/*
 * Decompiled with CFR 0.152.
 */
package dev.mlow.mods.snowy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mlow.mods.snowy.ForgeSnowyConfig;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="snowy")
public class SnowyNeoForge {
    private static final ForgeSnowyConfig CONFIG = new ForgeSnowyConfig();
    private static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"snowy");
    private static final DeferredRegister<BiomeModifier> BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (String)"snowy");
    private static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<SnowyBiomeModifier>> BIOME_MODIFIER_CODEC = BIOME_MODIFIER_SERIALIZERS.register("freeze_biome", () -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlacedFeature.CODEC.fieldOf("feature").forGetter(SnowyBiomeModifier::freezeTop)).apply((Applicative)instance, SnowyBiomeModifier::new)));

    public SnowyNeoForge(IEventBus modEventBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, SnowyNeoForge.CONFIG.commonSpec);
        modEventBus.addListener(CONFIG::onLoad);
        NeoForge.EVENT_BUS.addListener(this::serverTick);
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        BIOME_MODIFIERS.register(modEventBus);
    }

    public void serverTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (CONFIG.enableConstantSnow() && (CONFIG.enableNonOverworldBiomes() || level2.dimension().equals(Level.OVERWORLD))) {
                level2.setWeatherParameters(0, 6000, true, false);
            }
        }
    }

    private static boolean canModify(Holder<Biome> biome) {
        for (String forceEnabledBiome : CONFIG.forceEnabledBiomes()) {
            if (!biome.is(ResourceLocation.parse((String)forceEnabledBiome))) continue;
            return true;
        }
        for (String forceDisabledBiome : CONFIG.forceDisabledBiomes()) {
            if (!biome.is(ResourceLocation.parse((String)forceDisabledBiome))) continue;
            return false;
        }
        return CONFIG.enableNonOverworldBiomes() || biome.is(BiomeTags.IS_OVERWORLD);
    }

    private record SnowyBiomeModifier(Holder<PlacedFeature> freezeTop) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                if (SnowyNeoForge.canModify(biome)) {
                    for (Holder feature : builder.getGenerationSettings().getFeatures(GenerationStep.Decoration.TOP_LAYER_MODIFICATION)) {
                        if (!this.freezeTop.is(feature)) continue;
                        return;
                    }
                    builder.getGenerationSettings().addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, this.freezeTop);
                }
            } else if (phase == BiomeModifier.Phase.MODIFY && SnowyNeoForge.canModify(biome)) {
                builder.getClimateSettings().setHasPrecipitation(true);
                builder.getClimateSettings().setTemperature(0.0f);
                builder.getClimateSettings().setDownfall(0.5f);
                builder.getClimateSettings().setTemperatureModifier(CONFIG.enableTemperatureNoise() ? Biome.TemperatureModifier.FROZEN : Biome.TemperatureModifier.NONE);
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return (MapCodec)BIOME_MODIFIER_CODEC.get();
        }
    }
}

