/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import me.shedaniel.rareice.RareIce;
import me.shedaniel.rareice.blocks.entities.RareIceBlockEntity;
import me.shedaniel.rareice.world.gen.feature.RareIceConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class RareIceFeature
extends Feature<RareIceConfig> {
    public RareIceFeature(Codec<RareIceConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RareIceConfig> context) {
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        RareIceConfig config = (RareIceConfig)context.config();
        WorldGenLevel world = context.level();
        float f = random.nextFloat() * (float)Math.PI;
        float g = (float)config.size / 8.0f;
        int i = Mth.ceil((float)(((float)config.size / 16.0f * 2.0f + 1.0f) / 2.0f));
        double d = (float)pos.getX() + Mth.sin((float)f) * g;
        double e = (float)pos.getX() - Mth.sin((float)f) * g;
        double h = (float)pos.getZ() + Mth.cos((float)f) * g;
        double j = (float)pos.getZ() - Mth.cos((float)f) * g;
        double l = pos.getY() + random.nextInt(3) - 2;
        double m = pos.getY() + random.nextInt(3) - 2;
        int n = pos.getX() - Mth.ceil((float)g) - i;
        int o = pos.getY() - 2 - i;
        int p = pos.getZ() - Mth.ceil((float)g) - i;
        int q = 2 * (Mth.ceil((float)g) + i);
        int r = 2 * (2 + i);
        return this.generateVeinPart(world, random, config, d, e, h, j, l, m, n, o, p, q, r);
    }

    protected boolean generateVeinPart(WorldGenLevel world, RandomSource random, RareIceConfig config, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int size, int i) {
        double r;
        double q;
        double p;
        double o;
        int m;
        int j = 0;
        BitSet bitSet = new BitSet(size * i * size);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double[] ds = new double[config.size * 4];
        for (m = 0; m < config.size; ++m) {
            float f = (float)m / (float)config.size;
            o = Mth.lerp((double)f, (double)startX, (double)endX);
            p = Mth.lerp((double)f, (double)startY, (double)endY);
            q = Mth.lerp((double)f, (double)startZ, (double)endZ);
            r = random.nextDouble() * (double)config.size / 16.0;
            double l = ((double)(Mth.sin((float)((float)Math.PI * f)) + 1.0f) * r + 1.0) / 2.0;
            ds[m * 4] = o;
            ds[m * 4 + 1] = p;
            ds[m * 4 + 2] = q;
            ds[m * 4 + 3] = l;
        }
        for (m = 0; m < config.size - 1; ++m) {
            if (!(ds[m * 4 + 3] > 0.0)) continue;
            for (int n = m + 1; n < config.size; ++n) {
                if (!(ds[n * 4 + 3] > 0.0) || !((r = ds[m * 4 + 3] - ds[n * 4 + 3]) * r > (o = ds[m * 4] - ds[n * 4]) * o + (p = ds[m * 4 + 1] - ds[n * 4 + 1]) * p + (q = ds[m * 4 + 2] - ds[n * 4 + 2]) * q)) continue;
                if (r > 0.0) {
                    ds[n * 4 + 3] = -1.0;
                    continue;
                }
                ds[m * 4 + 3] = -1.0;
            }
        }
        for (m = 0; m < config.size; ++m) {
            double t = ds[m * 4 + 3];
            if (!(t >= 0.0)) continue;
            double u = ds[m * 4];
            double v = ds[m * 4 + 1];
            double w = ds[m * 4 + 2];
            int aa = Math.max(Mth.floor((double)(u - t)), x);
            int ab = Math.max(Mth.floor((double)(v - t)), y);
            int ac = Math.max(Mth.floor((double)(w - t)), z);
            int ad = Math.max(Mth.floor((double)(u + t)), aa);
            int ae = Math.max(Mth.floor((double)(v + t)), ab);
            int af = Math.max(Mth.floor((double)(w + t)), ac);
            for (int ag = aa; ag <= ad; ++ag) {
                double ah = ((double)ag + 0.5 - u) / t;
                if (!(ah * ah < 1.0)) continue;
                for (int ai = ab; ai <= ae; ++ai) {
                    double aj = ((double)ai + 0.5 - v) / t;
                    if (!(ah * ah + aj * aj < 1.0)) continue;
                    for (int ak = ac; ak <= af; ++ak) {
                        int am;
                        double al = ((double)ak + 0.5 - w) / t;
                        if (!(ah * ah + aj * aj + al * al < 1.0) || bitSet.get(am = ag - x + (ai - y) * size + (ak - z) * size * i)) continue;
                        bitSet.set(am);
                        mutable.set(ag, ai, ak);
                        if (!config.predicate.test(world.getBlockState((BlockPos)mutable))) continue;
                        world.setBlock((BlockPos)mutable, ((Block)RareIce.RARE_ICE_BLOCK.get()).defaultBlockState(), 2);
                        BlockEntity entity = world.getBlockEntity((BlockPos)mutable);
                        if (entity instanceof RareIceBlockEntity) {
                            ((RareIceBlockEntity)entity).addLootTable((Level)world.getLevel());
                        }
                        ++j;
                    }
                }
            }
        }
        return j > 0;
    }
}

