/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.blocks.entities;

import dev.architectury.event.EventResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rareice.ItemLocation;
import me.shedaniel.rareice.RareIce;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;

public class RareIceBlockEntity
extends BlockEntity
implements Clearable {
    private static final RandomSource RANDOM = RandomSource.create();
    private static final ResourceLocation LOOT_TABLE = ResourceLocation.parse((String)"rare_ice:chests/rare_ice");
    private final NonNullList<ItemStack> itemsContained = NonNullList.create();
    private final List<ItemLocation> itemsLocations = new ArrayList<ItemLocation>();
    private boolean setup = false;
    private int delay = 0;

    public RareIceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RareIce.RARE_ICE_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public void clearContent() {
        this.itemsContained.clear();
        this.itemsLocations.clear();
    }

    public NonNullList<ItemStack> getItemsContained() {
        return this.itemsContained;
    }

    public List<ItemLocation> getItemsLocations() {
        return this.itemsLocations;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.delay = tag.getInt("RevertDelay");
        this.itemsContained.clear();
        this.itemsLocations.clear();
        ListTag itemsTag = tag.getList("Items", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundTag stackTag = itemsTag.getCompound(i);
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)stackTag).orElse(ItemStack.EMPTY);
            this.itemsContained.add((Object)stack);
        }
        ListTag locationsTag = tag.getList("ItemLocations", 10);
        for (int i = 0; i < locationsTag.size(); ++i) {
            CompoundTag locTag = locationsTag.getCompound(i);
            this.itemsLocations.add(ItemLocation.fromTag(locTag));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("RevertDelay", this.delay);
        ListTag itemsTag = new ListTag();
        ListTag locationsTag = new ListTag();
        for (int i = 0; i < this.itemsContained.size(); ++i) {
            ItemStack stack = (ItemStack)this.itemsContained.get(i);
            ItemLocation location = this.itemsLocations.get(i);
            if (!stack.isEmpty()) {
                itemsTag.add((Object)stack.save(provider));
            }
            if (location == null) continue;
            CompoundTag locTag = new CompoundTag();
            location.toTag(locTag);
            locationsTag.add((Object)locTag);
        }
        tag.put("Items", (Tag)itemsTag);
        tag.put("ItemLocations", (Tag)locationsTag);
    }

    public void addLootTable(Level world) {
        this.setup = true;
    }

    public static void tick(Level world, BlockPos pos, BlockState blockState, RareIceBlockEntity blockEntity) {
        if (blockEntity.setup) {
            blockEntity.setup = false;
            blockEntity.delay = 0;
            ServerLevel server = (ServerLevel)world;
            LootTable lootTable = server.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)LOOT_TABLE));
            LootParams.Builder builder = new LootParams.Builder(server);
            ObjectArrayList drops = lootTable.getRandomItems(builder.create(LootContextParamSets.EMPTY));
            int size = Mth.clamp((int)(world.random.nextInt(5) - (world.random.nextInt(1) + 2)), (int)0, (int)drops.size());
            if (!drops.isEmpty()) {
                for (int i = 0; i < size; ++i) {
                    int index = world.random.nextInt(drops.size());
                    blockEntity.addItem(world, (ItemStack)drops.get(index), null);
                    drops.remove(index);
                }
            }
        } else if (blockEntity.itemsContained.isEmpty()) {
            ++blockEntity.delay;
            if (blockEntity.delay > 20) {
                world.setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                blockEntity.setRemoved();
            }
        } else {
            blockEntity.delay = 0;
        }
    }

    public EventResult addItem(Level world, ItemStack itemStack, Player nullablePlayer) {
        return this.addItem(world, itemStack, nullablePlayer, true);
    }

    public EventResult addItem(Level world, ItemStack itemStack, Player nullablePlayer, boolean actuallyDoIt) {
        if (itemStack.getItem() instanceof BlockItem && ((BlockItem)itemStack.getItem()).getBlock().builtInRegistryHolder().is(BlockTags.ICE)) {
            return EventResult.pass();
        }
        if (this.getItemsContained().size() < 8 && itemStack.getCount() >= 1) {
            if (actuallyDoIt) {
                ItemStack added = itemStack.split(1);
                this.getItemsContained().add((Object)added);
                RandomSource random = world.random != null ? world.random : RANDOM;
                ItemLocation loc = new ItemLocation(random.nextDouble() * 0.95 + 0.1, random.nextDouble() * 0.7 + 0.1, random.nextDouble() * 0.95 + 0.1);
                this.getItemsLocations().add(loc);
                this.updateListeners();
            }
            if (nullablePlayer != null && world.isClientSide()) {
                nullablePlayer.playSound(SoundEvents.CORAL_BLOCK_BREAK, 1.0f, 1.0f);
            }
            return EventResult.interruptTrue();
        }
        return EventResult.interruptFalse();
    }

    private void updateListeners() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

