/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import me.shedaniel.rareice.blocks.RareIceBlock;
import me.shedaniel.rareice.blocks.entities.RareIceBlockEntity;
import me.shedaniel.rareice.world.gen.feature.RareIceConfig;
import me.shedaniel.rareice.world.gen.feature.RareIceCountPlacement;
import me.shedaniel.rareice.world.gen.feature.RareIceFeature;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class RareIce {
    public static final String MOD_ID = "rare_ice";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"rare_ice", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> RARE_ICE_BLOCK = BLOCKS.register("rare_ice", () -> new RareIceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE).isValidSpawn((state, world, pos, type) -> type == EntityType.POLAR_BEAR)));
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"rare_ice", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<RareIceBlockEntity>> RARE_ICE_BLOCK_ENTITY_TYPE = BLOCK_ENTITIES.register("rare_ice", () -> BlockEntityType.Builder.of(RareIceBlockEntity::new, (Block[])new Block[]{(Block)RARE_ICE_BLOCK.get()}).build(null));
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((String)"rare_ice", (ResourceKey)Registries.FEATURE);
    public static final RegistrySupplier<Feature<RareIceConfig>> RARE_ICE_FEATURE = FEATURES.register("rare_ice", () -> new RareIceFeature(RareIceConfig.CODEC));
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENTS = DeferredRegister.create((String)"rare_ice", (ResourceKey)Registries.PLACEMENT_MODIFIER_TYPE);
    public static final RegistrySupplier<PlacementModifierType<RareIceCountPlacement>> COUNT_PLACEMENT = PLACEMENTS.register("rare_ice_count", () -> () -> RareIceCountPlacement.CODEC);
    public static boolean allowInsertingItemsToIce = true;
    public static int probabilityOfRareIce = 3;

    private static void loadConfig(Path file) {
        allowInsertingItemsToIce = true;
        probabilityOfRareIce = 3;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                properties.load(Files.newBufferedReader(file));
                allowInsertingItemsToIce = properties.getProperty("allowInsertingItemsToIce", "true").equals("true");
                probabilityOfRareIce = Integer.parseInt(properties.getProperty("probabilityOfRareIce", "3"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RareIce.saveConfig(file);
    }

    private static void saveConfig(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Properties properties = new Properties();
            properties.setProperty("allowInsertingItemsToIce", String.valueOf(allowInsertingItemsToIce));
            properties.setProperty("probabilityOfRareIce", String.valueOf(probabilityOfRareIce));
            properties.store(Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE), "Rare Ice Configuration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onInitialize() {
        RareIce.loadConfig(Platform.getConfigFolder().resolve("rare_ice.properties"));
        BLOCKS.register();
        BLOCK_ENTITIES.register();
        FEATURES.register();
        PLACEMENTS.register();
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, interactionHand, pos, direction) -> {
            if (!allowInsertingItemsToIce) {
                return EventResult.pass();
            }
            Level world = player.level();
            BlockState state = world.getBlockState(pos);
            if (player == null || player.isShiftKeyDown()) {
                return EventResult.pass();
            }
            if (state.getBlock() == Blocks.ICE || state.getBlock() == RARE_ICE_BLOCK) {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity == null) {
                    world.setBlockAndUpdate(pos, ((Block)RARE_ICE_BLOCK.get()).defaultBlockState());
                    blockEntity = world.getBlockEntity(pos);
                }
                if (blockEntity instanceof RareIceBlockEntity) {
                    RareIceBlockEntity rareIceBlockEntity = (RareIceBlockEntity)blockEntity;
                    ItemStack itemStack = player.getItemInHand(interactionHand);
                    itemStack = player.getAbilities().instabuild ? itemStack.copy() : itemStack;
                    return rareIceBlockEntity.addItem(world, itemStack, player, !world.isClientSide());
                }
            }
            return EventResult.pass();
        });
    }
}

