/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.spawn;

import com.cerbon.bosses_of_mass_destruction.entity.spawn.ISpawnPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MobEntitySpawnPredicate
implements ISpawnPredicate {
    private final LevelReader levelReader;

    public MobEntitySpawnPredicate(LevelReader worldView) {
        this.levelReader = worldView;
    }

    @Override
    public boolean canSpawn(Vec3 pos, Entity entity) {
        BlockPos blockPos = BlockPos.containing((Position)pos);
        if (!this.levelReader.hasChunkAt(blockPos)) {
            return false;
        }
        BlockState blockState = this.levelReader.getBlockState(blockPos);
        FluidState fluidState = this.levelReader.getFluidState(blockPos);
        AABB prospectiveBoundingBox = entity.getType().getSpawnAABB(pos.x, pos.y, pos.z);
        return !this.levelReader.containsAnyLiquid(prospectiveBoundingBox) && this.levelReader.noCollision(prospectiveBoundingBox) && NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)this.levelReader, (BlockPos)blockPos, (BlockState)blockState, (FluidState)fluidState, (EntityType)entity.getType());
    }
}

