/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.lich;

import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.CometAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.CometRageAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichUtils;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.VolleyAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.VolleyRageAction;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityEventHandler;
import com.cerbon.bosses_of_mass_destruction.entity.util.IEntityTick;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.particle.ParticleFactories;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.general.particle.ClientParticleBuilder;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.MobUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LichParticleHandler
implements IEntityEventHandler,
IEntityTick<Level> {
    private final LichEntity entity;
    private final EventScheduler eventScheduler;
    private final ClientParticleBuilder summonMissileParticleBuilder;
    private final ClientParticleBuilder teleportParticleBuilder;
    private final ClientParticleBuilder summonCometParticleBuilder;
    private final ClientParticleBuilder flameRingFactory;
    private final ClientParticleBuilder minionSummonParticleBuilder;
    private final ClientParticleBuilder thresholdParticleBuilder;
    private final ClientParticleBuilder summonRingFactory;
    private final ClientParticleBuilder summonRingCompleteFactory;
    private final ClientParticleBuilder deathParticleFactory;
    private final ClientParticleBuilder idleParticles;

    public LichParticleHandler(LichEntity entity, EventScheduler eventScheduler) {
        this.entity = entity;
        this.eventScheduler = eventScheduler;
        this.summonMissileParticleBuilder = ParticleFactories.soulFlame().age(2).colorVariation(0.5);
        this.teleportParticleBuilder = new ClientParticleBuilder((ParticleOptions)BMDParticles.DISAPPEARING_SWIRL.get()).color(Vec3Colors.TELEPORT_PURPLE).age(10, 15).brightness(0xF000F0);
        this.summonCometParticleBuilder = ParticleFactories.cometTrail().colorVariation(0.5);
        this.flameRingFactory = ParticleFactories.soulFlame().color(t -> MathUtils.lerpVec((float)t.floatValue(), (Vec3)Vec3Colors.WHITE, (Vec3)Vec3Colors.WHITE.multiply(0.5, 0.5, 0.5))).age(0, 7);
        this.minionSummonParticleBuilder = ParticleFactories.soulFlame().color(Vec3Colors.WHITE);
        this.thresholdParticleBuilder = ParticleFactories.soulFlame().age(20).scale(0.5f);
        this.summonRingFactory = ParticleFactories.soulFlame().color(LichUtils.blueColorFade).colorVariation(0.5).age(10);
        this.summonRingCompleteFactory = ParticleFactories.soulFlame().color(Vec3Colors.WHITE).age(20, 30);
        this.deathParticleFactory = ParticleFactories.soulFlame().color(LichUtils.blueColorFade).age(40, 80).colorVariation(0.5).scale(t -> Float.valueOf(0.5f - t.floatValue() * 0.3f));
        this.idleParticles = ParticleFactories.soulFlame().color(LichUtils.blueColorFade).age(30, 40).colorVariation(0.5).scale(t -> Float.valueOf(0.25f - t.floatValue() * 0.1f));
    }

    @Override
    public void tick(Level level) {
        if (this.entity.getRandom().nextDouble() > 0.9) {
            this.idleParticles.build(this.entity.position().subtract(VecUtils.yAxis).add(RandomUtils.randVec().scale(0.2)), this.entity.getDeltaMovement());
        }
    }

    @Override
    public void handleEntityEvent(byte status) {
        switch (status) {
            case 5: {
                this.cometEffect();
                break;
            }
            case 6: {
                this.volleyEffect();
                break;
            }
            case 7: {
                this.minionEffect();
                break;
            }
            case 8: {
                this.minionRageEffect();
                break;
            }
            case 9: {
                this.teleportEffect();
                break;
            }
            case 10: {
                this.endTeleportEffect();
                break;
            }
            case 12: {
                this.cometRageEffect();
                break;
            }
            case 11: {
                this.volleyRageEffect();
                break;
            }
            case 13: {
                this.hpThresholdEffect();
                break;
            }
            case 3: {
                this.deathEffect();
            }
        }
    }

    private void cometEffect() {
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> this.summonCometParticleBuilder.build(MobUtils.eyePos((Entity)this.entity).add(CometAction.getCometLaunchOffset()), Vec3.ZERO), 15, 45, this::shouldCancelParticles));
    }

    private void volleyEffect() {
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            for (Vec3 offset : VolleyAction.getMissileLaunchOffsets((Entity)this.entity)) {
                this.summonMissileParticleBuilder.build(MobUtils.eyePos((Entity)this.entity).add(offset), Vec3.ZERO);
            }
        }, 16, 30, this::shouldCancelParticles));
    }

    private void minionEffect() {
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> this.minionSummonParticleBuilder.build(MobUtils.eyePos((Entity)this.entity).add(VecUtils.yAxis.scale(1.0)).add(VecUtils.planeProject((Vec3)RandomUtils.randVec(), (Vec3)VecUtils.yAxis).normalize().scale(this.entity.getRandom().nextGaussian())), VecUtils.yAxis.scale(RandomUtils.randDouble((double)0.2))), 40, 30, this::shouldCancelParticles));
    }

    private void minionRageEffect() {
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            this.animatedParticleMagicCircle(3.0, 30, 12, 0.0f);
            this.animatedParticleMagicCircle(6.0, 60, 24, 120.0f);
            this.animatedParticleMagicCircle(9.0, 90, 36, 240.0f);
        }, 10, 1, this::shouldCancelParticles));
    }

    private void teleportEffect() {
        this.eventScheduler.addEvent((IEvent)new TimedEvent(this::spawnTeleportParticles, 15, 10, this::shouldCancelParticles));
    }

    private void endTeleportEffect() {
        this.eventScheduler.addEvent((IEvent)new TimedEvent(this::spawnTeleportParticles, 1, 10, this::shouldCancelParticles));
    }

    private void cometRageEffect() {
        int numComets = CometRageAction.getRageCometOffsets(this.entity).size();
        for (int i = 0; i < numComets; ++i) {
            int i1 = i;
            this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                Vec3 cometOffset = CometRageAction.getRageCometOffsets(this.entity).get(i1);
                this.summonCometParticleBuilder.build(cometOffset.add(MobUtils.eyePos((Entity)this.entity)), Vec3.ZERO);
            }, i * 30, 60, this::shouldCancelParticles));
        }
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> MathUtils.circleCallback((double)3.0, (int)72, (Vec3)this.entity.getLookAngle(), vec3 -> this.flameRingFactory.build(vec3.add(MobUtils.eyePos((Entity)this.entity)), Vec3.ZERO)), 0, 240, this::shouldCancelParticles));
    }

    private void volleyRageEffect() {
        int numVolleys = VolleyRageAction.getRageMissileVolleys(this.entity).size();
        int i = 0;
        while (i < numVolleys) {
            int i1 = i++;
            this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                for (Vec3 offset : VolleyRageAction.getRageMissileVolleys(this.entity).get(i1)) {
                    this.summonMissileParticleBuilder.build(MobUtils.eyePos((Entity)this.entity).add(offset), Vec3.ZERO);
                }
            }, 30 + i1 * 30, 30, this::shouldCancelParticles));
        }
    }

    private void hpThresholdEffect() {
        for (int i = 0; i < 20; ++i) {
            this.thresholdParticleBuilder.build(MobUtils.eyePos((Entity)this.entity), RandomUtils.randVec());
        }
    }

    private void deathEffect() {
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
            for (int i = 0; i <= 4; ++i) {
                this.deathParticleFactory.build(MobUtils.eyePos((Entity)this.entity), RandomUtils.randVec());
            }
        }, 0, 10, () -> false));
    }

    private void spawnTeleportParticles() {
        this.teleportParticleBuilder.build(MobUtils.eyePos((Entity)this.entity).add(RandomUtils.randVec().scale(3.0)), Vec3.ZERO);
    }

    private void animatedParticleMagicCircle(double radius, int points, int time, float rotationDegrees) {
        Vec3 spellPos = this.entity.position();
        List circlePoints = MathUtils.circlePoints((double)radius, (int)points, (Vec3)this.entity.getLookAngle()).stream().toList();
        float timeScale = (float)time / (float)points;
        IntStream.range(0, circlePoints.size()).forEach(index -> {
            Vec3 off = (Vec3)circlePoints.get(index);
            this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                off.yRot(rotationDegrees);
                this.summonRingFactory.build(off.add(spellPos), Vec3.ZERO);
            }, (int)((float)index * timeScale)));
        });
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> circlePoints.stream().peek(vec3 -> this.summonRingCompleteFactory.build(vec3.add(spellPos), Vec3.ZERO)), (int)((float)points * timeScale)));
    }

    private boolean shouldCancelParticles() {
        return !this.entity.isAlive();
    }
}

