/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class AttackRevengeTargetGoal
extends Goal {
    private final AbstractGoblinEntity entity;

    public AttackRevengeTargetGoal(AbstractGoblinEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.entity.canAttackBack() && this.entity.getLastHurtByMob() != null && this.entity.getLastHurtByMob().isAlive() && this.entity.distanceTo((Entity)this.entity.getLastHurtByMob()) <= 10.0f && (!(this.entity.getLastHurtByMob() instanceof Player) || !((Player)this.entity.getLastHurtByMob()).isCreative());
    }

    public void tick() {
        LivingEntity revengeTarget = this.entity.getLastHurtByMob();
        if (revengeTarget != null && this.entity.getTradingPlayer() == null && !this.entity.isStunned()) {
            this.entity.getLookControl().setLookAt((Entity)revengeTarget, 10.0f, (float)this.entity.getHeadRotSpeed());
            if ((double)this.entity.distanceTo((Entity)revengeTarget) >= 1.5) {
                this.entity.getNavigation().moveTo((Entity)revengeTarget, 0.5);
            } else {
                revengeTarget.hurt(this.entity.damageSources().mobAttack((LivingEntity)this.entity), 1.0f);
                this.entity.swing(InteractionHand.MAIN_HAND);
                this.entity.setLastHurtByMob(null);
            }
        }
    }

    public boolean canContinueToUse() {
        return this.entity.getLastHurtByMob() != null && this.entity.getLastHurtByMob().isAlive() && this.entity.distanceTo((Entity)this.entity.getLastHurtByMob()) <= 10.0f && this.entity.getTradingPlayer() == null;
    }

    public void stop() {
        this.entity.setLastHurtByMob(null);
    }
}

