/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.tornado.simple;

import com.corosus.coroutil.util.CULog;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.entity.PivotingParticle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import weather2.Weather;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.tornado.ActiveTornadoConfig;
import weather2.weathersystem.tornado.simple.Layer;

public class TornadoFunnelSimple {
    private ActiveTornadoConfig config;
    public Vec3 pos = new Vec3(0.0, 0.0, 0.0);
    public List<Layer> listLayers = new ArrayList<Layer>();
    private float heightPerLayer = 1.0f;
    private StormObject stormObject;
    private float targetSizeRadius = 0.0f;
    private float sizeRadiusRate = 0.0f;
    private float renderDistCutoff = 50.0f;
    private boolean wasFirenado = false;

    public TornadoFunnelSimple(ActiveTornadoConfig config, StormObject stormObject) {
        this.config = config;
        this.stormObject = stormObject;
        config.setRadiusOfBase(stormObject.tornadoHelper.getTornadoBaseSize() / 2);
    }

    public void init() {
        this.listLayers.clear();
    }

    public void tick() {
        if (this.stormObject.isPet()) {
            this.heightPerLayer = 0.2f;
        }
        this.targetSizeRadius = this.stormObject.tornadoHelper.getTornadoBaseSize() / 2;
        this.sizeRadiusRate = 0.01f;
        if (this.config.getRadiusOfBase() != this.targetSizeRadius) {
            if (this.config.getRadiusOfBase() < this.targetSizeRadius) {
                this.config.setRadiusOfBase(this.config.getRadiusOfBase() + this.sizeRadiusRate);
                if (this.config.getRadiusOfBase() > this.targetSizeRadius) {
                    this.config.setRadiusOfBase(this.targetSizeRadius);
                }
            } else {
                this.config.setRadiusOfBase(this.config.getRadiusOfBase() - this.sizeRadiusRate);
                if (this.config.getRadiusOfBase() < this.targetSizeRadius) {
                    this.config.setRadiusOfBase(this.targetSizeRadius);
                }
            }
        }
        int layers = (int)(this.config.getHeight() / this.heightPerLayer);
        float radiusMax = this.config.getRadiusOfBase() + this.config.getRadiusIncreasePerLayer() * (float)(layers + 1);
        for (int i = 0; i < layers; ++i) {
            double dynamicSpeed;
            Vec3 posLayerLower;
            if (i >= this.listLayers.size()) {
                this.listLayers.add(new Layer(this.stormObject.posBaseFormationPos));
            }
            float radius = this.config.getRadiusOfBase() + this.config.getRadiusIncreasePerLayer() * (float)i;
            Vec3 posLayer = this.listLayers.get(i).getPos();
            float relYDown1 = this.heightPerLayer * (radius / radiusMax);
            if (i == 0) {
                posLayerLower = new Vec3(this.pos.x, this.pos.y, this.pos.z);
            } else {
                Vec3 temp = this.listLayers.get(i - 1).getPos();
                posLayerLower = new Vec3(temp.x, temp.y + (double)relYDown1, temp.z);
            }
            double dist = posLayer.distanceTo(posLayerLower);
            if (dist > 50.0) {
                this.listLayers.get(i).setPos(new Vec3(posLayerLower.x, posLayerLower.y, posLayerLower.z));
                continue;
            }
            if (!(dist > (double)(0.1f * (radius / radiusMax)))) continue;
            double speed = dynamicSpeed = 15.0 * (Math.min(30.0, dist) / 30.0);
            Vec3 moveVec = posLayer.vectorTo(posLayerLower).normalize().multiply(speed, speed * 1.0, speed);
            Vec3 newPos = posLayer.add(moveVec);
            this.listLayers.get(i).setPos(new Vec3(newPos.x, newPos.y, newPos.z));
        }
        Level level = this.stormObject.manager.getWorld();
        if (this.stormObject.isSharknado() && !level.isClientSide() && level.getGameTime() % 20L == 0L) {
            Dolphin ent = null;
            if (Weather.isLoveTropicsInstalled()) {
                // empty if block
            }
            if (ent == null) {
                if (Weather.isLoveTropicsInstalled()) {
                    CULog.dbg((String)"failed to create shark, falling back to dolphin");
                }
                ent = new Dolphin(EntityType.DOLPHIN, level);
            }
            Vec3 posRand = new Vec3(this.pos.x + 0.0, this.pos.y + 25.0, this.pos.z - 5.0);
            ent.setPos(posRand);
            ent.setDeltaMovement(3.0, 0.0, 0.0);
            level.addFreshEntity((Entity)ent);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient() {
        long gameTime = this.stormObject.getAge();
        Level level = this.stormObject.manager.getWorld();
        this.renderDistCutoff = Minecraft.getInstance().gameRenderer.getRenderDistance() * 4.0f;
        int layers = (int)(this.config.getHeight() / this.heightPerLayer);
        float radiusMax = this.config.getRadiusOfBase() + this.config.getRadiusIncreasePerLayer() * (float)(layers + 1);
        boolean isBaby = this.stormObject.isBaby();
        boolean isPet = this.stormObject.isPet();
        for (int i = layers; i < this.listLayers.size(); ++i) {
            List<PivotingParticle> listLayer = this.listLayers.get(i).getListParticles();
            Iterator<PivotingParticle> it = listLayer.iterator();
            while (it.hasNext()) {
                PivotingParticle particle = it.next();
                it.remove();
                particle.remove();
            }
        }
        int particleCount = 0;
        float adjustedRate = 1.0f;
        if (!isPet) {
            if (Minecraft.getInstance().options.particles.get() == ParticleStatus.DECREASED) {
                adjustedRate = 0.6f;
            } else if (Minecraft.getInstance().options.particles.get() == ParticleStatus.MINIMAL) {
                adjustedRate = 0.3f;
            }
        }
        int layersWithDebris = this.stormObject.getAgeSinceTornadoTouchdown() / 5;
        for (int i = 0; i < layers; ++i) {
            PivotingParticle particle;
            List<PivotingParticle> listLayer = this.listLayers.get(i).getListParticles();
            List<PivotingParticle> listLayerExtra = this.listLayers.get(i).getListParticlesExtra();
            float radius = this.config.getRadiusOfBase() + this.config.getRadiusIncreasePerLayer() * (float)i;
            float radiusAdjustedForParticleSize = radius * (radius / radiusMax);
            float circumference = radius * 2.0f * (float)Math.PI;
            float particleSpaceOccupy = 15.0f / adjustedRate * (radius / radiusMax);
            if (isBaby) {
                particleSpaceOccupy = 2.0f / adjustedRate * (radius / radiusMax);
            }
            if (isPet) {
                particleSpaceOccupy = 0.2f / adjustedRate * (radius / radiusMax);
            }
            float particlesPerLayer = circumference / particleSpaceOccupy;
            Iterator<PivotingParticle> itt = listLayer.iterator();
            float indexx = 0.0f;
            while (itt.hasNext()) {
                PivotingParticle particle2 = itt.next();
                if (!particle2.isAlive() || indexx >= particlesPerLayer) {
                    particle2.remove();
                    itt.remove();
                    continue;
                }
                indexx += 1.0f;
            }
            int firstLayerForParticles = 6;
            if (this.stormObject.isBaby()) {
                firstLayerForParticles = 0;
            }
            while ((float)listLayer.size() < particlesPerLayer && i >= firstLayerForParticles) {
                PivotingParticle particle3 = this.createParticle((ClientLevel)level, this.pos.x, this.pos.y, this.pos.z);
                particle3.spawnAsWeatherEffect();
                listLayer.add(particle3);
            }
            float particleSpacingDegrees = 360.0f / particlesPerLayer;
            float spinSpeedLayer = 1.0f - (float)(i + 1) / (float)layers + 1.0f;
            if (isPet) {
                this.listLayers.get(i).setRotation(this.listLayers.get(i).getRotation() + 10.0f * spinSpeedLayer / radiusAdjustedForParticleSize);
            } else {
                this.listLayers.get(i).setRotation(this.listLayers.get(i).getRotation() + 50.22f * spinSpeedLayer / radiusAdjustedForParticleSize);
            }
            Iterator<PivotingParticle> it = listLayer.iterator();
            int index = 0;
            while (it.hasNext()) {
                ++particleCount;
                particle = it.next();
                float rot = particleSpacingDegrees * (float)index + this.listLayers.get(i).getRotation();
                particle.setPivotRotPrev(particle.getPivotRot());
                particle.setPivotRot(new Vec3(0.0, (double)rot, 0.0));
                particle.setPivotPrev(particle.getPivot());
                particle.setPivot(new Vec3(0.0, (double)radiusAdjustedForParticleSize, 0.0));
                Vec3 pivotedPosition = particle.getPivotedPosition(0.0f);
                double vecX = 0.0 - pivotedPosition.x;
                double vecZ = 0.0 - pivotedPosition.z;
                particle.prevRotationYaw = particle.rotationYaw;
                particle.rotationYaw = -((float)(Mth.atan2((double)vecZ, (double)vecX) * 180.0 / Math.PI)) - 90.0f + 180.0f;
                int rotationVarianceSize = 90;
                particle.rotationYaw -= (float)(particle.getEntityId() % rotationVarianceSize - rotationVarianceSize / 2);
                particle.rotationPitch = -30.0f;
                if (particle.rotationYaw > 0.0f && particle.prevRotationYaw < 0.0f) {
                    particle.prevRotationYaw += 360.0f;
                }
                Vec3 posLayer = this.listLayers.get(i).getPos();
                particle.setPosition(posLayer.x, posLayer.y, posLayer.z);
                particle.setPrevPosX(particle.x);
                particle.setPrevPosY(particle.y);
                particle.setPrevPosZ(particle.z);
                particle.setScale(10.0f * (radius / radiusMax));
                if (isBaby) {
                    particle.setScale(3.3333333f * (radius / radiusMax));
                }
                if (isPet) {
                    particle.setScale(0.47619048f * (radius / radiusMax));
                }
                if ((float)particle.getAge() > particle.getTicksFadeInMax() + 1.0f) {
                    particle.setAge((int)particle.getTicksFadeInMax() + 1);
                }
                if (this.stormObject.isFirenado && !this.wasFirenado) {
                    if (particle.getSprite() == ParticleRegistry.cloud256) {
                        particle.setSprite(ParticleRegistry.cloud256_fire);
                    }
                    float baseBright = 0.8f;
                    float randFloat = level.random.nextFloat() * 0.2f;
                    float finalBright = Math.min(1.0f, baseBright + randFloat);
                    particle.setColor(finalBright, finalBright, finalBright);
                }
                ++index;
            }
            particlesPerLayer = (int)(20.0f * adjustedRate);
            if (isBaby) {
                particlesPerLayer = (int)(10.0f * adjustedRate);
            }
            if (isPet) {
                particlesPerLayer = (int)(5.0f * adjustedRate);
            }
            if (this.stormObject.levelCurIntensityStage == StormObject.STATE_FORMING) {
                particlesPerLayer = 0.0f;
            }
            this.cleanupList(listLayerExtra, (int)particlesPerLayer);
            if (i <= layersWithDebris && i >= firstLayerForParticles + 1) {
                while ((float)listLayerExtra.size() < particlesPerLayer) {
                    particle = this.createParticleDebris((ClientLevel)level, this.pos.x, this.pos.y, this.pos.z);
                    particle.spawnAsWeatherEffect();
                    listLayerExtra.add(particle);
                }
            }
            particleSpacingDegrees = 360.0f / particlesPerLayer;
            it = listLayerExtra.iterator();
            index = 0;
            while (it.hasNext()) {
                ++particleCount;
                particle = it.next();
                float radAdj = (float)particle.getEntityId() % particlesPerLayer / particlesPerLayer;
                radAdj = 0.4f + radAdj * 0.6f;
                float moar = (float)i * 0.5f;
                if (isPet) {
                    moar = 0.5f;
                }
                radiusAdjustedForParticleSize = (radius * (radius / radiusMax) + moar) * radAdj;
                float rot = particleSpacingDegrees * (float)index + this.listLayers.get(i).getRotation();
                particle.setPivotRotPrev(particle.getPivotRot());
                particle.setPivotRot(new Vec3(0.0, (double)rot, 0.0));
                particle.setPivotPrev(particle.getPivot());
                particle.setPivot(new Vec3(0.0, (double)radiusAdjustedForParticleSize, 0.0));
                particle.prevRotationYaw = particle.rotationYaw;
                particle.rotationYaw += 5.0f;
                particle.rotationPitch = -30.0f;
                Vec3 posLayer = this.listLayers.get(i).getPos();
                particle.setPosition(posLayer.x, posLayer.y, posLayer.z);
                particle.setPrevPosX(particle.x);
                particle.setPrevPosY(particle.y);
                particle.setPrevPosZ(particle.z);
                particle.setScale(1.2f);
                if (isPet) {
                    particle.setScale(0.22222222f * (radius / radiusMax));
                }
                if ((float)particle.getAge() > particle.getTicksFadeInMax() + 1.0f) {
                    particle.setAge((int)particle.getTicksFadeInMax() + 1);
                }
                particle.setGravity(0.0f);
                ++index;
            }
        }
        this.wasFirenado = this.stormObject.isFirenado;
    }

    public void cleanupList(List<PivotingParticle> list, int particlesPerLayer) {
        Iterator<PivotingParticle> it = list.iterator();
        float index = 0.0f;
        while (it.hasNext()) {
            PivotingParticle particle = it.next();
            if (!particle.isAlive() || index >= (float)particlesPerLayer) {
                particle.remove();
                it.remove();
                continue;
            }
            index += 1.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private PivotingParticle createParticle(ClientLevel world, double x, double y, double z) {
        TextureAtlasSprite sprite = ParticleRegistry.cloud256;
        if (this.stormObject.isFirenado) {
            sprite = ParticleRegistry.cloud256_fire;
        }
        PivotingParticle particle = new PivotingParticle(world, x, y, z, 0.0, 0.0, 0.0, sprite);
        particle.setMaxAge(300);
        particle.setTicksFadeInMax(80.0f);
        particle.setParticleSpeed(0.0, 0.0, 0.0);
        particle.setScale(0.1f);
        particle.setScale(5.0f);
        particle.setScale(15.0f);
        if (!this.stormObject.isFirenado) {
            float baseBright = 0.3f;
            float randFloat = world.random.nextFloat() * 0.6f;
            float finalBright = Math.min(1.0f, baseBright + randFloat);
            particle.setColor(finalBright - 0.2f, finalBright - 0.2f, finalBright - 0.2f);
        } else {
            float baseBright = 0.6f;
            float randFloat = world.random.nextFloat() * 0.3f;
            float finalBright = Math.min(1.0f, baseBright + randFloat);
            particle.setColor(finalBright - 0.2f, finalBright - 0.2f, finalBright - 0.2f);
        }
        particle.setGravity(0.0f);
        particle.rotationYaw = world.random.nextFloat() * 360.0f;
        particle.setRenderDistanceCull(this.renderDistCutoff);
        return particle;
    }

    @OnlyIn(value=Dist.CLIENT)
    private PivotingParticle createParticleDebris(ClientLevel world, double x, double y, double z) {
        int chance = world.getRandom().nextInt(3);
        TextureAtlasSprite sprite = ParticleRegistry.debris_1;
        if (chance == 1) {
            sprite = ParticleRegistry.debris_2;
        } else if (chance == 2) {
            sprite = ParticleRegistry.debris_3;
        }
        PivotingParticle particle = new PivotingParticle(world, x, y, z, 0.0, 0.0, 0.0, sprite);
        particle.setMaxAge(25000);
        particle.setTicksFadeInMax(80.0f);
        particle.setParticleSpeed(0.0, 0.0, 0.0);
        particle.setFacePlayer(false);
        particle.spinFast = true;
        particle.isTransparent = true;
        particle.rotationYaw = world.getRandom().nextInt(360);
        particle.rotationPitch = world.getRandom().nextInt(360);
        particle.setGravity(0.0f);
        float brightnessMulti = 1.0f - world.getRandom().nextFloat() * 0.5f;
        particle.setColor(1.0f * brightnessMulti, 1.0f * brightnessMulti, 1.0f * brightnessMulti);
        particle.setScale(1.2f);
        particle.aboveGroundHeight = 0.5;
        particle.collisionSpeedDampen = false;
        particle.bounceSpeed = 0.03;
        particle.bounceSpeedAhead = 0.03;
        particle.setKillOnCollide(false);
        particle.windWeight = 5.0f;
        particle.setRenderDistanceCull(this.renderDistCutoff);
        return particle;
    }

    public Vec3 getPosTop() {
        if (this.listLayers.size() == 0) {
            return this.pos;
        }
        return this.listLayers.get(this.listLayers.size() - 1).getPos();
    }

    public StormObject getStormObject() {
        return this.stormObject;
    }

    public void setStormObject(StormObject stormObject) {
        this.stormObject = stormObject;
    }

    public void cleanup() {
        this.listLayers.clear();
    }

    public void cleanupClient() {
        for (int i = 0; i < this.listLayers.size(); ++i) {
            this.listLayers.get(i).getListParticles().stream().forEach(pivotingParticle -> this.disperseParticleSmoothly((PivotingParticle)pivotingParticle, true));
            this.listLayers.get(i).getListParticlesExtra().stream().forEach(pivotingParticle -> this.disperseParticleSmoothly((PivotingParticle)pivotingParticle, true));
            this.listLayers.get(i).getListParticles().clear();
            this.listLayers.get(i).getListParticlesExtra().clear();
        }
    }

    public void fadeOut() {
        for (int i = 0; i < this.listLayers.size(); ++i) {
            this.listLayers.get(i).getListParticles().stream().forEach(pivotingParticle -> this.disperseParticleSmoothly((PivotingParticle)pivotingParticle, false));
            this.listLayers.get(i).getListParticlesExtra().stream().forEach(pivotingParticle -> this.disperseParticleSmoothly((PivotingParticle)pivotingParticle, false));
            this.listLayers.get(i).getListParticles().clear();
            this.listLayers.get(i).getListParticlesExtra().clear();
        }
    }

    public void disperseParticleSmoothly(PivotingParticle pivotingParticle, boolean explode) {
        pivotingParticle.prevRotationYaw = pivotingParticle.rotationYaw;
        pivotingParticle.setPivotPrev(pivotingParticle.getPivot());
        pivotingParticle.setPivotRotPrev(pivotingParticle.getPivotRot());
        Random rand = new Random();
        if (explode) {
            pivotingParticle.setMotionX((rand.nextFloat() - rand.nextFloat()) * 2.0f);
            pivotingParticle.setMotionZ((rand.nextFloat() - rand.nextFloat()) * 2.0f);
        } else {
            pivotingParticle.setMotionX((rand.nextFloat() - rand.nextFloat()) * 0.4f);
            pivotingParticle.setMotionZ((rand.nextFloat() - rand.nextFloat()) * 0.4f);
        }
        pivotingParticle.setAge(100);
        pivotingParticle.setMaxAge(200);
        pivotingParticle.setTicksFadeOutMax(80.0f);
        pivotingParticle.spinFast = false;
    }

    public void cleanupClientQuick() {
        for (int i = 0; i < this.listLayers.size(); ++i) {
            this.listLayers.get(i).getListParticles().stream().forEach(pivotingParticle -> pivotingParticle.remove());
            this.listLayers.get(i).getListParticlesExtra().stream().forEach(pivotingParticle -> pivotingParticle.remove());
            this.listLayers.get(i).getListParticles().clear();
            this.listLayers.get(i).getListParticlesExtra().clear();
        }
    }

    public ActiveTornadoConfig getConfig() {
        return this.config;
    }

    public void setConfig(ActiveTornadoConfig config) {
        this.config = config;
    }
}

